/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import MITI.util.config.MimbConfiguration;
import MITI.util.config.MitiConfig;
import java.io.File;
import java.util.TreeSet;

public final class XmlVersion
extends Enum<XmlVersion> {
    public static final /* enum */ XmlVersion XML_10;
    public static final /* enum */ XmlVersion XML_11;
    private String version;
    private String[] escapedCharacters;
    private TreeSet<Character> normalizedCharacters;
    private static final /* synthetic */ XmlVersion[] $VALUES;

    public static XmlVersion[] values() {
        return (XmlVersion[])$VALUES.clone();
    }

    public static XmlVersion valueOf(String string) {
        return Enum.valueOf(XmlVersion.class, string);
    }

    private XmlVersion(String string2, String[] stringArray) {
        this.version = string2;
        this.escapedCharacters = stringArray;
        this.normalizedCharacters = new TreeSet();
    }

    public String getVersion() {
        return this.version;
    }

    public String[] getEscapes() {
        return this.escapedCharacters;
    }

    public String getEscape(char c) {
        if (c < this.escapedCharacters.length) {
            return this.escapedCharacters[c];
        }
        if (this.normalizedCharacters.contains(Character.valueOf(c))) {
            return String.format("&#x%02X;", c);
        }
        return null;
    }

    public String getDecl() {
        return this.getDecl(null);
    }

    public String getDecl(String string) {
        return "<?xml version='" + this.version + "'" + (string != null ? " encoding='" + string + "'" : "") + "?>";
    }

    public static XmlVersion get() {
        MitiConfig mitiConfig;
        File file = MimbConfiguration.getMimbHome();
        if (file != null && (mitiConfig = MitiConfig.loadConfig(MimbConfiguration.getMimbHome())) != null && "1.0".equals(mitiConfig.getXmlVersion())) {
            return XML_10;
        }
        return XML_11;
    }

    static {
        int n;
        XML_10 = new XmlVersion("1.0", new String[128]);
        XML_11 = new XmlVersion("1.1", new String[256]);
        $VALUES = new XmlVersion[]{XML_10, XML_11};
        XmlVersion.XML_11.escapedCharacters[0] = "";
        XmlVersion.XML_10.escapedCharacters[0] = "";
        for (n = 1; n < 32; ++n) {
            XmlVersion.XML_10.escapedCharacters[n] = "";
            XmlVersion.XML_11.escapedCharacters[n] = String.format("&#x%02X;", n);
        }
        XmlVersion.XML_11.escapedCharacters[9] = "&#09;";
        XmlVersion.XML_10.escapedCharacters[9] = "&#09;";
        XmlVersion.XML_11.escapedCharacters[10] = "&#10;";
        XmlVersion.XML_10.escapedCharacters[10] = "&#10;";
        XmlVersion.XML_11.escapedCharacters[13] = "&#13;";
        XmlVersion.XML_10.escapedCharacters[13] = "&#13;";
        XmlVersion.XML_11.escapedCharacters[34] = "&quot;";
        XmlVersion.XML_10.escapedCharacters[34] = "&quot;";
        XmlVersion.XML_11.escapedCharacters[38] = "&amp;";
        XmlVersion.XML_10.escapedCharacters[38] = "&amp;";
        XmlVersion.XML_11.escapedCharacters[39] = "&apos;";
        XmlVersion.XML_10.escapedCharacters[39] = "&apos;";
        XmlVersion.XML_11.escapedCharacters[60] = "&lt;";
        XmlVersion.XML_10.escapedCharacters[60] = "&lt;";
        XmlVersion.XML_11.escapedCharacters[62] = "&gt;";
        XmlVersion.XML_10.escapedCharacters[62] = "&gt;";
        for (n = 127; n < 160; ++n) {
            XmlVersion.XML_11.escapedCharacters[n] = String.format("&#x%02X;", n);
        }
        XmlVersion.XML_11.normalizedCharacters.add(Character.valueOf('\u0085'));
        XmlVersion.XML_11.normalizedCharacters.add(Character.valueOf('\u2028'));
    }
}

