/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import MITI.util.file.FileUtil;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StringDigest {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA-1";
    private static final String SHA256 = "SHA-256";
    private static final String SHA512 = "SHA-512";
    private MessageDigest md = null;

    private StringDigest(String string) {
        try {
            this.md = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static StringDigest getMd5() {
        return new StringDigest(MD5);
    }

    public static StringDigest getSha1() {
        return new StringDigest(SHA1);
    }

    public static StringDigest getSha256() {
        return new StringDigest(SHA256);
    }

    public static StringDigest getSha512() {
        return new StringDigest(SHA512);
    }

    public StringDigest update(ByteBuffer byteBuffer) {
        this.md.update(byteBuffer);
        return this;
    }

    public StringDigest update(byte[] byArray) {
        this.md.update(byArray);
        return this;
    }

    public StringDigest update(byte by) {
        this.md.update(by);
        return this;
    }

    public StringDigest update(String string) {
        this.md.update(string.getBytes(FileUtil.UTF8));
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : this.md.digest()) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }
}

