/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import MITI.util.Shutdown;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ProcessBuilder {
    private List<String> cmd = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private File baseDir;
    private Charset charset;
    private String stdin;
    private PrintStream stdout;
    private PrintStream stderr;
    private boolean redirect;
    private File shutdownFile;

    public ProcessBuilder addArgument(String string) {
        this.cmd.add(string);
        return this;
    }

    public ProcessBuilder setArguments(String ... stringArray) {
        this.cmd.clear();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.cmd.add(string);
            }
        }
        return this;
    }

    public ProcessBuilder setEnvironmentVariables(Map<String, String> map) {
        if (map != null) {
            this.env.putAll(map);
        }
        return this;
    }

    public ProcessBuilder addEnvironmentVariable(String string, String string2) {
        this.env.put(string, string2);
        return this;
    }

    public ProcessBuilder removeEnvironmentVariable(String string) {
        this.env.put(string, null);
        return this;
    }

    public ProcessBuilder setBaseDirector(File file) {
        this.baseDir = file;
        return this;
    }

    public ProcessBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public ProcessBuilder setInputStream(String string) {
        this.stdin = string;
        return this;
    }

    public ProcessBuilder setOutputStream(PrintStream printStream) {
        this.stdout = printStream;
        return this;
    }

    public ProcessBuilder setErrorStream(PrintStream printStream) {
        this.stderr = printStream;
        return this;
    }

    public ProcessBuilder redirectErrToOut(boolean bl) {
        this.redirect = bl;
        return this;
    }

    public ProcessBuilder setShutdownFile(File file) {
        this.shutdownFile = file;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec() throws IOException {
        Map.Entry<String, String> entry2;
        java.lang.ProcessBuilder processBuilder = new java.lang.ProcessBuilder(this.cmd);
        for (Map.Entry<String, String> entry2 : this.env.entrySet()) {
            if (entry2.getValue() == null) {
                processBuilder.environment().remove(entry2.getKey());
                continue;
            }
            processBuilder.environment().put(entry2.getKey(), entry2.getValue());
        }
        if (this.baseDir != null) {
            processBuilder.directory(this.baseDir);
        }
        if (this.redirect) {
            processBuilder.redirectErrorStream(true);
        }
        if (this.charset == null) {
            this.charset = Charset.defaultCharset();
        }
        Process process = processBuilder.start();
        if (this.stdin != null) {
            ProcessBuilder.redirectStream(new BufferedReader(new StringReader(this.stdin)), new PrintStream(process.getOutputStream(), false, this.charset.name()), true);
        } else {
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.stdout == null) {
            this.stdout = new LocalStream();
        }
        entry2 = ProcessBuilder.redirectStream(new BufferedReader(new InputStreamReader(process.getInputStream(), this.charset)), this.stdout, false);
        if (this.stderr == null) {
            this.stderr = new LocalStream();
        }
        Thread thread = null;
        thread = !this.redirect ? ProcessBuilder.redirectStream(new BufferedReader(new InputStreamReader(process.getErrorStream(), this.charset)), this.stderr, false) : new Thread(new Runnable(){

            @Override
            public void run() {
            }
        });
        int n = -1;
        Thread thread2 = Shutdown.create(this.shutdownFile);
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            if (Shutdown.message(thread2)) {
                try {
                    process.waitFor(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException2) {
                    // empty catch block
                }
            }
            if (process.isAlive()) {
                process.destroy();
            }
            ((Thread)((Object)entry2)).interrupt();
            if (thread != null) {
                thread.interrupt();
            }
        }
        finally {
            Shutdown.close(thread2);
            try {
                ((Thread)((Object)entry2)).join();
            }
            catch (InterruptedException interruptedException) {}
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stdout.flush();
        this.stderr.flush();
        return n;
    }

    private static Thread redirectStream(final Reader reader, final PrintStream printStream, final boolean bl) throws IOException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int n = 0;
                char[] cArray = new char[1024];
                do {
                    try {
                        n = reader.read(cArray);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (n > 0 && printStream != null) {
                        for (int i = 0; i < n; ++i) {
                            printStream.print(cArray[i]);
                        }
                    } else {
                        if (n != 0) continue;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (n != -1 && !Thread.currentThread().isInterrupted());
                if (bl) {
                    printStream.flush();
                    printStream.close();
                }
            }
        });
        thread.start();
        return thread;
    }

    public String getStdOut() {
        if (this.stdout instanceof LocalStream) {
            return this.stdout.toString();
        }
        return null;
    }

    public String getStdErr() {
        if (this.stderr instanceof LocalStream) {
            return this.stderr.toString();
        }
        return null;
    }

    private class LocalStream
    extends PrintStream {
        private StringBuilder sb;

        public LocalStream() {
            super(new ByteArrayOutputStream());
            this.sb = new StringBuilder();
        }

        @Override
        public void print(char c) {
            this.sb.append(c);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

