/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MiscParams {
    public static final String ENV_VARIABLE = "-environment.variable";
    public static final String JAVA_EXE = "-java.executable";
    public static final String JAVA_MEMORY = "-java.memory";
    public static final String JAVA_PARAMS = "-java.parameters";
    private Map<String, LinkedList<MiscParam>> params = new LinkedHashMap<String, LinkedList<MiscParam>>();
    private static final String KEY = "-[^\\s]+";
    private static final String SIMPLE_VALUE = "([^-=\\s\"][^=\\s\"]*)";
    private static final String QUOTED_VALUE = "\"((?:\\\\\"|[^\"])*)\"";
    private static final String VALUE = "(?:([^-=\\s\"][^=\\s\"]*)|\"((?:\\\\\"|[^\"])*)\")";
    private static final Pattern ARGUMENTS = Pattern.compile("(-[^\\s]+)\\s*(((?:([^-=\\s\"][^=\\s\"]*)|\"((?:\\\\\"|[^\"])*)\"))(?:\\s*=\\s*((?:([^-=\\s\"][^=\\s\"]*)|\"((?:\\\\\"|[^\"])*)\")))?)?");

    private MiscParams() {
    }

    public Collection<String> getKeys() {
        return this.params.keySet();
    }

    public boolean contains(String string) {
        return this.params.containsKey(string);
    }

    public void addValue(String string, String string2) {
        this.add(string, string2, string2, null);
    }

    public String getValue(String string) {
        LinkedList<MiscParam> linkedList = this.params.get(string);
        return linkedList != null ? linkedList.getLast().value : null;
    }

    public void removeValue(String string) {
        this.params.remove(string);
    }

    protected String getRawValue(String string) {
        LinkedList<MiscParam> linkedList = this.params.get(string);
        return linkedList != null ? linkedList.getLast().originalValue : null;
    }

    public Map<String, String> getMappedValues(String string) {
        LinkedHashMap<String, String> linkedHashMap = null;
        List list = this.params.get(string);
        if (list != null) {
            linkedHashMap = new LinkedHashMap<String, String>();
            for (MiscParam miscParam : list) {
                linkedHashMap.put(miscParam.value, miscParam.mappedValue);
            }
        }
        return linkedHashMap;
    }

    private void add(String string, String string2) {
        this.add(string, string2, string2, null);
    }

    private void add(String string, String string2, String string3, String string4) {
        LinkedList<MiscParam> linkedList = this.params.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList();
            this.params.put(string, linkedList);
        }
        linkedList.add(new MiscParam(string2, string3, string4));
    }

    public static MiscParams parse(String string) {
        MiscParams miscParams = new MiscParams();
        Matcher matcher = ARGUMENTS.matcher(string);
        while (matcher.find()) {
            String string2;
            String string3 = matcher.group(1);
            if ("-j".equals(string3)) {
                string3 = JAVA_PARAMS;
            } else if ("-jre".equals(string3)) {
                string3 = JAVA_EXE;
            } else if ("-m".equals(string3)) {
                string3 = JAVA_MEMORY;
            } else if ("-v".equals(string3)) {
                string3 = ENV_VARIABLE;
            }
            if (JAVA_PARAMS.equals(string3)) {
                string2 = string.substring(matcher.start() + matcher.group(1).length() + 1);
                miscParams.add(string3, string2);
                break;
            }
            string2 = matcher.group(2);
            String string4 = null;
            String string5 = null;
            if (string2 != null && matcher.group(3) != null) {
                string4 = matcher.group(4);
                if (string4 == null) {
                    string4 = matcher.group(5).replace("\\\"", "\"");
                }
                if (matcher.group(6) != null && (string5 = matcher.group(7)) == null) {
                    string5 = matcher.group(8).replace("\\\"", "\"");
                }
            }
            miscParams.add(string3, string2, string4, string5);
        }
        return miscParams;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        MiscParam miscParam = null;
        for (Map.Entry<String, LinkedList<MiscParam>> entry : this.params.entrySet()) {
            if (JAVA_PARAMS.equals(entry.getKey())) {
                miscParam = entry.getValue().getFirst();
                continue;
            }
            for (MiscParam miscParam2 : entry.getValue()) {
                stringBuilder.append(entry.getKey());
                if (miscParam2.value != null) {
                    stringBuilder.append(" \"").append(miscParam2.value.replace("\"", "\\\"")).append("\"");
                    if (miscParam2.mappedValue != null) {
                        stringBuilder.append("=\"").append(miscParam2.mappedValue.replace("\"", "\\\"")).append("\"");
                    }
                }
                stringBuilder.append(" ");
            }
        }
        if (miscParam != null) {
            stringBuilder.append(JAVA_PARAMS).append(" ").append(miscParam.value);
        }
        return stringBuilder.toString();
    }

    private static class MiscParam {
        public String originalValue;
        public String value;
        public String mappedValue;

        private MiscParam(String string, String string2, String string3) {
            this.originalValue = string;
            this.value = string2;
            this.mappedValue = string3;
        }
    }
}

