/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import MITI.util.MacAddress;
import MITI.util.ProcessBuilder;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MachineInfo {
    private static String hostId = null;
    private static final String PROCESSOR_IDENTIFIER = "PROCESSOR_IDENTIFIER";
    private static final String USER_LANGUAGE = "user.language";
    private static final String FILE_ENCODING = "file.encoding";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String JAVA_VERSION = "java.version";
    private static final String JAVA_RUNTIME_VERSION = "java.runtime.version";
    private static final String JAVA_HOME = "java.home";
    private static String OS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    private static boolean isWindows = MachineInfo.getOperatingSystemType() == OSType.Windows;

    public static String getMacAddress() {
        return MacAddress.getMacAddress();
    }

    public static List<String> getMacAddresses(boolean bl) {
        return MacAddress.getMacAddresses(bl);
    }

    public static String getHostId() {
        if (hostId == null) {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder();
                Pattern pattern = null;
                if (MachineInfo.isWindows()) {
                    processBuilder.setArguments("cmd", "/c", "vol", "%SystemDrive%");
                    pattern = Pattern.compile("[0-9A-F]+-[0-9A-F]+", 2);
                } else {
                    processBuilder.setArguments("hostid");
                    pattern = Pattern.compile("[0-9a-f]+", 2);
                }
                processBuilder.exec();
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = processBuilder.getStdOut();
                if (string != null) {
                    for (String string2 : string.split("(\\\r)?\\\n")) {
                        Matcher matcher = pattern.matcher(string2);
                        if (!matcher.find()) continue;
                        String string3 = matcher.group();
                        arrayList.add(string3.toLowerCase().replace("-", ""));
                    }
                }
                if (arrayList.size() == 1) {
                    hostId = (String)arrayList.get(0);
                } else if (arrayList.size() == 2 && MachineInfo.isWindows()) {
                    hostId = (String)arrayList.get(1);
                }
                if ("00000000".equals(hostId)) {
                    hostId = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hostId;
    }

    public static String getHostName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    public static String getHardware() {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        return MachineInfo.getHardwareProcessorId() + ", " + operatingSystemMXBean.getAvailableProcessors() + " CPU(s)/Core(s), " + MachineInfo.getHardwareMemory() + " MB RAM accessible";
    }

    public static String getHardwareMemory() {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        String string = "unknown";
        try {
            long l = ((OperatingSystemMXBean)operatingSystemMXBean).getTotalPhysicalMemorySize();
            if (l != Long.MAX_VALUE) {
                string = String.valueOf(l / 1024L / 1024L);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return string;
    }

    public static String getHardwareProcessorId() {
        String string = System.getenv(PROCESSOR_IDENTIFIER);
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    public static String getSoftware() {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        Locale locale = new Locale(System.getProperty(USER_LANGUAGE));
        return operatingSystemMXBean.getName() + " " + operatingSystemMXBean.getVersion() + " " + operatingSystemMXBean.getArch() + ", " + locale.getDisplayLanguage();
    }

    public static String getEncoding() {
        String string = System.getProperty(FILE_ENCODING);
        Charset charset = Charset.forName(string);
        if (charset != null) {
            return charset.displayName();
        }
        return string;
    }

    public static String getJavaVersion() {
        String string = System.getProperty(JAVA_RUNTIME_VERSION);
        if (string == null || string.isEmpty()) {
            string = System.getProperty(JAVA_VERSION);
        }
        return "Java " + System.getProperty(JAVA_VENDOR) + " version " + string;
    }

    public static String getJavaMemory() {
        String string = "unlimited";
        long l = Runtime.getRuntime().maxMemory();
        if (l != Long.MAX_VALUE) {
            string = String.valueOf(l / 1024L / 1024L);
        }
        return string + " MB RAM";
    }

    public static String getJavaHome() {
        return System.getProperty(JAVA_HOME);
    }

    public static String getJavaOptions() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String string = "";
        for (String string2 : runtimeMXBean.getInputArguments()) {
            String string3;
            if (!string2.startsWith("-X") && !string2.startsWith("-D") || (string3 = string2.split("=")[0].substring(2).toLowerCase()).startsWith("mimb") || string3.contains("user") || string3.contains("password")) continue;
            if (!string.isEmpty()) {
                string = string + ", ";
            }
            string = string + string2;
        }
        return string;
    }

    public static String getJavaInfo() {
        return "" + MachineInfo.getJavaVersion() + " using " + MachineInfo.getJavaMemory();
    }

    public static long getJavaProcessId() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String string = runtimeMXBean.getName();
        int n = string.indexOf(64);
        if (n == -1) {
            return 0L;
        }
        String string2 = string.substring(0, n);
        try {
            return Long.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static OSType getOperatingSystemType() {
        if (OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0) {
            return OSType.MacOS;
        }
        if (OS.indexOf("win") >= 0) {
            return OSType.Windows;
        }
        if (OS.indexOf("nux") >= 0) {
            return OSType.Linux;
        }
        if (OS.indexOf("solaris") >= 0 || OS.indexOf("sunos") >= 0) {
            return OSType.Solaris;
        }
        return OSType.Other;
    }

    public static String getOperatingSystemName() {
        return OS;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static String getUsername() {
        if (MachineInfo.isWindows()) {
            return System.getenv().get("USERDOMAIN") + "\\" + System.getenv().get("USERNAME");
        }
        return System.getProperty("user.name");
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Solaris,
        Other;

    }
}

