/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import MITI.util.MachineInfo;
import MITI.util.ProcessBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Exec {
    private static final Pattern ARGUMENTS = Pattern.compile("(?:[^\\s\"]|\"[^\"]*\")+");
    private static final Pattern ENV_VAR = Pattern.compile("((?:[^\\s=\"]|\"[^\"]*\")+)\\s*=\\s*((?:[^\\s=\"]|\"[^\"]*\")*)");

    public static int exec(String[] stringArray, Map<String, String> map, File file, PrintStream printStream, PrintStream printStream2, Charset charset) throws IOException {
        return Exec.exec(stringArray, map, file, null, printStream, printStream2, charset);
    }

    public static int exec(String[] stringArray, Map<String, String> map, File file, String string, PrintStream printStream, PrintStream printStream2, Charset charset) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder().setArguments(stringArray).setEnvironmentVariables(map).setBaseDirector(file).setInputStream(string).setOutputStream(printStream).setErrorStream(printStream2).redirectErrToOut(printStream != null && printStream == printStream2).setCharset(charset);
        return processBuilder.exec();
    }

    public static List<String> splitCommandLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = ARGUMENTS.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList;
    }

    public static Map<String, String> getArguments(String string) {
        return Exec.getArguments(string, Collections.emptyList(), Collections.emptyList());
    }

    public static Map<String, String> getMiscellaneousArguments(String string) {
        return Exec.getArguments(string, Arrays.asList("-j", "-java.parameters"), Arrays.asList("-v", "-environment.variable"));
    }

    private static Map<String, String> getArguments(String string, Collection<String> collection, Collection<String> collection2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Matcher matcher = ARGUMENTS.matcher(string);
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        while (matcher.find()) {
            if (matcher.group(0).startsWith("-") && !bl) {
                if (!string2.isEmpty()) {
                    if (hashMap.containsKey(string2)) {
                        if (collection2.contains(string2)) {
                            hashMap.put(string2, (String)hashMap.get(string2) + " " + string3);
                        }
                    } else {
                        hashMap.put(string2, string3);
                    }
                }
                string2 = matcher.group();
                string3 = "";
                bl = collection.contains(string2);
                continue;
            }
            if (!string3.isEmpty()) {
                string3 = string3 + " ";
            }
            string3 = string3 + matcher.group();
        }
        if (!string2.isEmpty()) {
            if (hashMap.containsKey(string2)) {
                if (collection2.contains(string2)) {
                    hashMap.put(string2, (String)hashMap.get(string2) + " " + string3);
                }
            } else {
                hashMap.put(string2, string3);
            }
        }
        return hashMap;
    }

    public static Map<String, String> getEnvVars(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Matcher matcher = ENV_VAR.matcher(string);
        while (matcher.find()) {
            String string2;
            String string3 = matcher.group(1);
            if (string3.startsWith("\"") && string3.endsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if ((string2 = matcher.group(2)) == null) {
                string2 = "";
            } else if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean is64bits(File file) {
        if (!file.exists()) return false;
        if (!file.canRead()) return false;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray = new byte[1024];
            int n = fileInputStream.read(byArray, 0, byArray.length);
            if (n <= 0) return false;
            if (MachineInfo.isWindows()) {
                int n2 = Exec.getInt(byArray, 60, 4);
                if (n2 >= n) return false;
                int n3 = Exec.getInt(byArray, n2 + 4, 2);
                boolean bl = n3 == 34404;
                return bl;
            }
            int n4 = Exec.getInt(byArray, 4, 1);
            boolean bl = n4 == 2;
            return bl;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static int getInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += (byArray[n + i] & 0xFF) << 8 * i;
        }
        return n3;
    }
}

