/*
 * Decompiled with CFR 0.152.
 */
package MITI.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final String SIMPLE = "yyyy-MM-dd HH:mm:ss";
    private static final String ISO_LOCALE = "yyyy-MM-dd'T'HH:mm:ss'G'";
    private static final String ISO_UTC = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static TimeZone getUtcTimeZone() {
        return UTC;
    }

    public static Calendar getUtcCalendar() {
        return Calendar.getInstance(UTC);
    }

    public static SimpleDateFormat getSimpleFormat(boolean bl) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SIMPLE);
        if (bl) {
            simpleDateFormat.setTimeZone(UTC);
        }
        return simpleDateFormat;
    }

    public static SimpleDateFormat getIsoLocaleFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_LOCALE);
        return simpleDateFormat;
    }

    public static SimpleDateFormat getIsoUtcFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO_UTC);
        simpleDateFormat.setTimeZone(UTC);
        return simpleDateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(long l, SimpleDateFormat simpleDateFormat) {
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(new Date(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String string, SimpleDateFormat simpleDateFormat) {
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    public static String formatSimpleDate(long l, boolean bl) {
        return DateUtil.formatDate(l, DateUtil.getSimpleFormat(bl));
    }

    public static Date parseSimpleDate(String string, boolean bl) {
        return DateUtil.parseDate(string, DateUtil.getSimpleFormat(bl));
    }

    public static String formatLocaleDate(long l) {
        return DateUtil.formatDate(l, DateUtil.getIsoLocaleFormat());
    }

    public static Date parseLocaleDate(String string) {
        return DateUtil.parseDate(string, DateUtil.getIsoLocaleFormat());
    }

    public static String formatUtcDate(long l) {
        return DateUtil.formatDate(l, DateUtil.getIsoUtcFormat());
    }

    public static Date parseUtcDate(String string) {
        return DateUtil.parseDate(string, DateUtil.getIsoUtcFormat());
    }
}

