/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common;

import MITI.server.services.common.SessionHandle;
import MITI.util.DateUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class LogEvent {
    private int sessionId;
    private int userId;
    private String threadId;
    private String text;
    private String code;
    private int level = 0;
    private String stackTrace;
    private Throwable throwable;
    private long time = System.currentTimeMillis();
    private long sequenceNumber;

    public LogEvent() {
        SessionHandle sessionHandle = SessionHandle.getUserSession();
        if (sessionHandle != null) {
            if (sessionHandle.getParentSessionId() != 0) {
                this.sessionId = sessionHandle.getSessionId();
            }
            this.userId = sessionHandle.getUserId();
        }
        this.threadId = Thread.currentThread().getName();
    }

    public LogEvent(String string, int n, String string2) {
        this();
        this.text = string;
        this.code = string2;
        this.level = n;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String string) {
        this.threadId = string;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int n) {
        this.userId = n;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String string) {
        this.stackTrace = string;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setStackTrace(Throwable throwable) {
        this.throwable = throwable;
        if (throwable != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, "UTF-8");
                throwable.printStackTrace(printStream);
                this.stackTrace = byteArrayOutputStream.toString("UTF-8");
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l) {
        this.time = l;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public void useInfoForStatus() {
        if (this.level == 4) {
            this.level = 5;
        } else if (this.level == 1) {
            this.level = 2;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.threadId != null) {
            if (this.sessionId != 0) {
                stringBuilder.append('[').append(this.sessionId).append('/').append(this.getThreadId()).append("] ");
            } else {
                stringBuilder.append('[').append(this.getThreadId()).append("] ");
            }
        } else if (this.sessionId != 0) {
            stringBuilder.append('[').append(this.sessionId).append("] ");
        }
        stringBuilder.append(DateUtil.formatSimpleDate(this.getTime(), false)).append(' ');
        stringBuilder.append(this.getCode()).append(' ');
        stringBuilder.append(this.getText());
        return stringBuilder.toString();
    }
}

