/*
 * Decompiled with CFR 0.152.
 */
package MITI.server;

import MITI.util.Encryption;
import MITI.util.file.PropertyFile;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;

public class MmConfProperties
extends PropertyFile {
    private static final String DB_CONNECTION_URL = "db.connection.url";
    private static final String DB_CONNECTION_USER = "db.connection.user";
    private static final String DB_CONNECTION_PASSWORD = "db.connection.password";
    private static final String DB_POOL_MAX_SIZE = "db.pool.max.size";
    private static final String DB_POOL_MAX_IDLE = "db.pool.max.idle";
    private static final String DB_POOL_MAX_WAIT = "db.pool.max.wait";
    private static final String DB_POOL_STEP_SIZE = "db.pool.step.size";
    private static final String DB_AUTO_UPGRADE = "db.auto.upgrade";
    private static final String MAIL_HOST = "mail.host";
    private static final String MAIL_PORT = "mail.port";
    private static final String MAIL_USER = "mail.user";
    private static final String MAIL_PASSWORD = "mail.password";
    private static final String MAIL_EXT_URL = "mail.external.url";
    private static final String MAIL_SENDER = "mail.sender";
    private static final String MAIL_REPLY_TO = "mail.replyto";
    private static final String MAIL_TENANT_ID = "mail.tenant.id";
    private static final String MAIL_CLIENT_ID = "mail.client.id";
    private static final String MAIL_CLIENT_SECRET = "mail.client.secret";
    private static final String MAIL_ADMIN = "mail.admin";
    private static final String USER_SESSION_TIMEOUT = "user.session.timeout";
    private static final String OPERATION_SESSION_TIMEOUT = "operation.session.timeout";
    private static final String MIMB_SERVER_HEARTBEAT_FREQUENCY = "mimb.heartbeat.frequency";

    public MmConfProperties(File file) {
        super(file);
    }

    public boolean exists() {
        return !this.getProperties().isEmpty();
    }

    public String getDbConnectionUrl() {
        return this.getStringProperty(DB_CONNECTION_URL);
    }

    public void setDbConnectionUrl(String string) {
        this.setProperty(DB_CONNECTION_URL, string);
    }

    public String getDbConnectionUser() {
        return this.getStringProperty(DB_CONNECTION_USER);
    }

    public void setDbConnectionUser(String string) {
        this.setProperty(DB_CONNECTION_USER, string);
    }

    public String getDbConnectionPassword() {
        return this.getPasswordProperty(DB_CONNECTION_PASSWORD);
    }

    public void setDbConnectionPassword(String string) {
        this.setPasswordProperty(DB_CONNECTION_PASSWORD, string);
    }

    public int getDbPoolMaxSize() {
        return this.getIntProperty(DB_POOL_MAX_SIZE);
    }

    public void setDbPoolMaxSize(int n) {
        this.setProperty(DB_POOL_MAX_SIZE, String.valueOf(n));
    }

    public int getDbPoolMaxIdle() {
        return this.getIntProperty(DB_POOL_MAX_IDLE);
    }

    public void setDbPoolMaxIdle(int n) {
        this.setProperty(DB_POOL_MAX_IDLE, String.valueOf(n));
    }

    public int getDbPoolMaxWait() {
        return this.getIntProperty(DB_POOL_MAX_WAIT);
    }

    public void setDbPoolMaxWait(int n) {
        this.setProperty(DB_POOL_MAX_WAIT, String.valueOf(n));
    }

    public int getDbPoolStepSize() {
        return this.getIntProperty(DB_POOL_STEP_SIZE);
    }

    public void setDbPoolStepSize(int n) {
        this.setProperty(DB_POOL_STEP_SIZE, String.valueOf(n));
    }

    public boolean isDbAutoUpgrade() {
        return this.getBooleanProperty(DB_AUTO_UPGRADE);
    }

    public void setDbAutoUpgrade(boolean bl) {
        this.setProperty(DB_AUTO_UPGRADE, String.valueOf(bl));
    }

    public String getMailHost() {
        return this.getStringProperty(MAIL_HOST);
    }

    public void setMailHost(String string) {
        this.setProperty(MAIL_HOST, string);
    }

    public int getMailPort() {
        return this.getIntProperty(MAIL_PORT);
    }

    public void setMailPort(int n) {
        this.setProperty(MAIL_PORT, String.valueOf(n));
    }

    public String getMailUser() {
        return this.getStringProperty(MAIL_USER);
    }

    public void setMailUser(String string) {
        this.setProperty(MAIL_USER, string);
    }

    public String getMailPassword() {
        return this.getPasswordProperty(MAIL_PASSWORD);
    }

    public void setMailPassword(String string) {
        this.setPasswordProperty(MAIL_PASSWORD, string);
    }

    public String getMailExternalUrl() {
        return this.getStringProperty(MAIL_EXT_URL);
    }

    public void setMailExternalUrl(String string) {
        this.setProperty(MAIL_EXT_URL, string);
    }

    public String getMailSender() {
        return this.getStringProperty(MAIL_SENDER);
    }

    public void setMailSender(String string) {
        this.setProperty(MAIL_SENDER, string);
    }

    public String getMailReplyTo() {
        return this.getStringProperty(MAIL_REPLY_TO);
    }

    public void setMailReplyTo(String string) {
        this.setProperty(MAIL_REPLY_TO, string);
    }

    public String getMailTenantId() {
        return this.getStringProperty(MAIL_TENANT_ID);
    }

    public void setMailTenantId(String string) {
        this.setProperty(MAIL_TENANT_ID, string);
    }

    public String getMailClientId() {
        return this.getStringProperty(MAIL_CLIENT_ID);
    }

    public void setMailClientId(String string) {
        this.setProperty(MAIL_CLIENT_ID, string);
    }

    public String getMailClientSecret() {
        return this.getStringProperty(MAIL_CLIENT_SECRET);
    }

    public void setMailClientSecret(String string) {
        this.setProperty(MAIL_CLIENT_SECRET, string);
    }

    public Collection<String> getAdminEmails() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.getStringProperty(MAIL_ADMIN).split(",")) {
            if ((string = string.trim()).isEmpty()) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void setAdminEmails(String string) {
        this.setProperty(MAIL_ADMIN, string);
    }

    public int getUserSessionTimeout() {
        return this.getIntProperty(USER_SESSION_TIMEOUT);
    }

    public void setUserSessionTimeout(int n) {
        this.setProperty(USER_SESSION_TIMEOUT, String.valueOf(n));
    }

    public int getOperationSessionTimeout() {
        return this.getIntProperty(OPERATION_SESSION_TIMEOUT);
    }

    public void setOperationSessionTimeout(int n) {
        this.setProperty(OPERATION_SESSION_TIMEOUT, String.valueOf(n));
    }

    private String getPasswordProperty(String string) {
        return Encryption.decrypt(this.getStringProperty(string), true);
    }

    private void setPasswordProperty(String string, String string2) {
        this.setProperty(string, Encryption.encrypt(string2, true));
    }

    public int getMimbServerHeartbeatFrequency() {
        return this.getIntProperty(MIMB_SERVER_HEARTBEAT_FREQUENCY);
    }

    public void setMimbServerHeartbeatFrequency(int n) {
        this.setProperty(MIMB_SERVER_HEARTBEAT_FREQUENCY, String.valueOf(n));
    }
}

