/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.migration;

import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.workspace.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ETLMigrationStatus {
    private ILogger m_logger = null;
    private String m_sDisplayObjectName = null;
    private String m_sPublicType = null;
    private int m_totalObjects = 0;
    private int m_migrationExecuted = 0;
    private int m_deletedObjects = 0;
    private int m_alreadyMigrated = 0;
    private int m_migrationSuccess = 0;
    private List m_notInTreesList = new ArrayList();
    private List m_multipleTreesList = new ArrayList();
    private List m_publicTypeNotSetList = new ArrayList();
    private Map m_Errors = new HashMap();
    private List m_migrateNotAttemptedList = new ArrayList();
    private List m_FailedMigrationList = new ArrayList();
    private List m_usageVersionNotValidList = new ArrayList();

    public ETLMigrationStatus(ILogger logger, String displayObjectName, String publicType) {
        this.m_logger = logger;
        this.m_sDisplayObjectName = displayObjectName;
        this.m_sPublicType = publicType;
    }

    public boolean hasErrors() {
        boolean returnValue = false;
        if (this.m_FailedMigrationList.size() > 0) {
            returnValue = true;
        } else if (this.m_Errors.size() > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    public String getDisplayName() {
        return this.m_sDisplayObjectName;
    }

    public void logSuccessStats() {
        this.m_logger.info((Object)("-#- BEGIN " + this.m_sDisplayObjectName.toUpperCase() + " STATUS REPORT -#-"));
        this.m_logger.info((Object)(this.m_totalObjects + " " + this.m_sDisplayObjectName + "(s) total found to process for migration"));
        if (this.m_migrationExecuted > 0 && this.m_migrationExecuted != this.m_totalObjects) {
            this.m_logger.info((Object)(this.m_migrationExecuted + " " + this.m_sDisplayObjectName + "(s) migrations necessary."));
        }
        if (this.m_migrationSuccess > 0) {
            this.m_logger.info((Object)(this.m_migrationSuccess + " " + this.m_sDisplayObjectName + "(s) processed for migration."));
        }
        if (this.m_alreadyMigrated > 0) {
            this.m_logger.info((Object)(this.m_alreadyMigrated + " " + this.m_sDisplayObjectName + "(s) found which have already been upgraded."));
        }
        if (!this.m_Errors.isEmpty()) {
            this.m_logger.error((Object)(this.m_Errors.size() + " Error(s) found migrating the following object(s):"));
            for (BrowseMetadataInterface object : this.m_Errors.keySet()) {
                Throwable e = (Throwable)this.m_Errors.get(object);
                Throwable cause = e.getCause();
                Throwable rootCause = e;
                if (cause != null) {
                    rootCause = cause;
                }
                this.m_logger.error((Object)("\tError migrating " + object.getName() + " error: " + rootCause.getLocalizedMessage()), rootCause);
            }
        }
        if (this.m_notInTreesList.size() > 0 && this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)(this.m_notInTreesList.size() + " " + this.m_sDisplayObjectName + "(s) found not in a folder before migration"));
            this.logActionListOfObjectsToDebug(this.m_notInTreesList);
        }
        if (this.m_multipleTreesList.size() > 0) {
            this.m_logger.info((Object)(this.m_multipleTreesList.size() + " " + this.m_sDisplayObjectName + "(s) found in multiple folders"));
            this.logActionListOfObjects(this.m_notInTreesList);
        }
        if (this.m_publicTypeNotSetList.size() > 0) {
            this.m_logger.info((Object)(this.m_publicTypeNotSetList.size() + " " + this.m_sDisplayObjectName + "(s) found without PublicType=\"" + this.m_sPublicType + "\""));
            this.logActionListOfObjects(this.m_publicTypeNotSetList);
        }
        if (this.m_usageVersionNotValidList.size() > 0) {
            this.m_logger.info((Object)(this.m_usageVersionNotValidList.size() + " " + this.m_sDisplayObjectName + "(s) found where migration is required."));
            this.logActionListOfObjects(this.m_usageVersionNotValidList);
        }
        if (this.m_FailedMigrationList.size() > 0) {
            this.m_logger.info((Object)(this.m_FailedMigrationList.size() + " " + this.m_sDisplayObjectName + "(s) found for which migration has failed, errors are logged above."));
            this.logActionListOfObjects(this.m_FailedMigrationList);
        }
        if (this.m_migrateNotAttemptedList.size() > 0) {
            this.m_logger.info((Object)(this.m_migrateNotAttemptedList.size() + " " + this.m_sDisplayObjectName + "(s) found for which migration has not been attempted."));
            this.logActionListOfObjects(this.m_migrateNotAttemptedList);
        }
        if (this.m_deletedObjects > 0) {
            this.m_logger.info((Object)(this.m_deletedObjects + " " + this.m_sDisplayObjectName + "(s) deleted for migration to new version."));
        }
        this.m_logger.info((Object)("-#- END " + this.m_sDisplayObjectName.toUpperCase() + " STATUS REPORT -#-"));
    }

    private void logActionListOfObjects(List objectList) {
        for (String objectNameWType : objectList) {
            this.m_logger.info((Object)("\t" + objectNameWType));
        }
    }

    private void logActionListOfObjectsToDebug(List objectList) {
        for (String objectNameWType : objectList) {
            this.m_logger.debug((Object)("\t" + objectNameWType));
        }
    }

    public void incrementTotalObjects() {
        ++this.m_totalObjects;
    }

    public void incrementNotInTrees(String name, String publicType) {
        this.addObjectToList(this.m_notInTreesList, name, publicType);
    }

    public void incrementMultipleTrees(String name, String publicType) {
        this.addObjectToList(this.m_notInTreesList, name, publicType);
    }

    public void addErrorException(BrowseMetadataInterface upgradeObject, Throwable e) {
        this.m_Errors.put(upgradeObject, e);
    }

    public void incrementMigrationExecution() {
        ++this.m_migrationExecuted;
    }

    public void incrementDeletedObjects() {
        ++this.m_deletedObjects;
    }

    public Map getExceptions() {
        return Collections.unmodifiableMap(this.m_Errors);
    }

    public void setDisplayName(String displayName) {
        if (displayName != null && !displayName.equals(this.m_sDisplayObjectName)) {
            this.m_sDisplayObjectName = displayName;
        }
    }

    public void incrementMigrationNotAttempted(String name, String publicType) {
        this.addObjectToList(this.m_migrateNotAttemptedList, name, publicType);
    }

    public void incrementFailedMigrationVersion(String name, String publicType) {
        this.addObjectToList(this.m_FailedMigrationList, name, publicType);
    }

    public void incrementUsageVersionNotValid(String name, String publicType) {
        this.addObjectToList(this.m_usageVersionNotValidList, name, publicType);
    }

    private void addObjectToList(List objectList, String name, String publicType) {
        String listObject = null;
        listObject = publicType != null && publicType.length() > 0 ? "\"" + name + "\" (" + publicType + ")" : "\"" + name + "\" ( TYPE UNKNOWN )";
        objectList.add(listObject);
    }

    public void incrementPublicTypeNotSet(String name, String publicType) {
        this.addObjectToList(this.m_publicTypeNotSetList, name, publicType);
    }

    public void incrementAlreadyMigrated() {
        ++this.m_alreadyMigrated;
    }

    public void incrementMigrationSuccess() {
        ++this.m_migrationSuccess;
    }
}

