/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.migration;

import com.sas.etl.migration.AbstractMigrationProcessor;
import com.sas.etl.migration.ETLMigrationStatus;
import com.sas.etl.migration.ETLMigrationUtility;
import com.sas.etl.migration.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.util.UpgradeInterface;
import com.sas.text.Message;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ETLMigrationProcessor
extends AbstractMigrationProcessor {
    private static final String SCHEDULER_BRIDGE_JOB = "SCHEDULER_BRIDGE_JOB";
    private ServerInterface m_Server = null;
    private static final String TABLE_TREES_TEMPLATE = "<Templates><PhysicalTable><Trees/></PhysicalTable></Templates>";
    private static final String EXTERNALTABLE_TREES_TEMPLATE = "<Templates><ExternalTable><Trees/></ExternalTable></Templates>";
    private static final String PROTOTYPE_TREES_TEMPLATE = "<Templates><Prototype><Trees/></Prototype></Templates>";
    private static final String JOB_TREES_TEMPLATE = "<Templates><Job><Trees/></Job></Templates>";
    private static final String TRANSFORMATION_TREES_TEMPLATE = "<Templates><Transformation><Trees/></Transformation></Templates>";
    private static final String SOFTWARE_COMPONENT_TREES_TEMPLATE = "<Templates><SoftwareComponent><SoftwareTrees/></SoftwareComponent><Tree><SoftwareComponents/></Tree></Templates>";
    private static final String OLD_SOFTWARE_COMPONENT_CLASS = "com.sas.wadmin.visuals.TheAppWA";
    private List m_status = new ArrayList();
    private static final String[] DI_STUDIO_GUIDS = new String[]{"8337799b-0a17-0c86-0135-76a23269c227", "6da3c715-0a1a-0b30-0082-e4f38cca6909", "901f5002-0a17-0c86-0073-1e90e63b81f8", "9da80356-0a17-0c86-0135-76a2cdd8c13f", "6da3ca32-0a1a-0b30-0082-e4f362a1580f", "6da3c7d1-0a1a-0b30-0082-e4f38fdf70b8", "9024248b-0a17-0c86-0073-1e90cf0a0b3d", "6da3c82f-0a1a-0b30-0082-e4f3a9939ea1", "734e7c50-0a17-0ba6-012b-6c899c7899f4", "d6bee957-0a17-0c86-00b4-0ec49e7e78b4", "6da3c85e-0a1a-0b30-0082-e4f37effbc74", "6da3c8cb-0a1a-0b30-0082-e4f37a13a228", "1c98d152-0a17-0c2a-014a-e2c14c1f69d2", "9028bb90-0a17-0c86-0073-1e909a21dcde", "6da3c929-0a1a-0b30-0082-e4f3124f196d", "6da3c80f-0a1a-0b30-0082-e4f378676645", "6da3c948-0a1a-0b30-0082-e4f3ea2439d4", "63c22abc-0a1a-0b2d-014f-79cb7acfc2c0", "6da3c967-0a1a-0b30-0082-e4f349f5e9e9", "d66ab4c3-0a17-0c86-0135-76a29c1b5834", "9ddf11d2-0a17-0c86-0135-76a28ddfcb1f", "bc5ac953-0a17-0c86-018e-18a359caad3e", "bc64bec3-0a17-0c86-00cf-e0499e662a78", "6da3c8fa-0a1a-0b30-0082-e4f3f27a69c0", "bc68ee4c-0a17-0c86-00cf-e04915e867ce", "6da3c6a8-0a1a-0b30-0082-e4f3bf2404ca", "6da3ca13-0a1a-0b30-0082-e4f3d278309e", "6da3c7a2-0a1a-0b30-0082-e4f3768cee0b", "6da3c7f0-0a1a-0b30-0082-e4f3167822ec"};

    public ETLMigrationProcessor(ServerInterface server) {
        this.m_Server = server;
    }

    public void migrate() throws RemoteException, ServiceException, MdException {
        if (!this.isExecuteMigration()) {
            this.m_logger.info((Object)"Executing analyze for migration of ETL objects");
        }
        ETLMigrationStatus tableStatus = null;
        ETLMigrationStatus externalFileStatus = null;
        ETLMigrationStatus genTransStatus = null;
        ETLMigrationStatus jobStatus = null;
        if (this.isMigrateDataTypes()) {
            tableStatus = new ETLMigrationStatus(this.m_logger, "table", "Table");
            this.migrateTables(tableStatus);
            externalFileStatus = new ETLMigrationStatus(this.m_logger, "external file", "ExternalFile");
            this.migrateExternalFiles(externalFileStatus);
        }
        if (this.isMigrateETLTypes()) {
            genTransStatus = new ETLMigrationStatus(this.m_logger, "generated transformation", "GeneratedTransform");
            this.migrateGeneratedTransforms(genTransStatus);
            jobStatus = new ETLMigrationStatus(this.m_logger, "job", "Job");
            this.migrateJobs(jobStatus);
        }
        if (this.isMigrateDataTypes()) {
            this.m_status.add(tableStatus);
            this.m_status.add(externalFileStatus);
        }
        if (this.isMigrateETLTypes()) {
            this.m_status.add(genTransStatus);
            this.m_status.add(jobStatus);
        }
    }

    public void prep() throws RemoteException, ServiceException, MdException {
        ETLMigrationStatus genTransStatus = new ETLMigrationStatus(this.m_logger, "generated transformation", "GeneratedTransform");
        this.m_status.add(genTransStatus);
        this.removePreviousVersionGeneratedTransforms(genTransStatus);
        this.removeOldSoftwareComponent(genTransStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateTables(ETLMigrationStatus status) throws RemoteException, ServiceException, MdException {
        List allTables = ETLMigrationUtility.getAllObjectsByMetadataType(this.m_Server, "PhysicalTable", TABLE_TREES_TEMPLATE);
        for (BrowseMetadataInterface browseTable : allTables) {
            String publicType = (String)browseTable.get("PublicType");
            status.incrementTotalObjects();
            String tablePath = this.validateContainer(browseTable, status);
            boolean bAlreadyUpgraded = this.validatePublicObjectAttributes(browseTable, status);
            ChildServerInterface cTransaction = this.m_Server.newChild(true);
            boolean upgradeSuccess = false;
            try {
                MetadataInterface tableSmartObject = this.validateUpgradeInterface(cTransaction, browseTable, "Table");
                if (tableSmartObject instanceof UpgradeInterface) {
                    UpgradeInterface tableUp = (UpgradeInterface)tableSmartObject;
                    this.executeUpgrade(status, browseTable, tablePath, bAlreadyUpgraded, tableUp);
                    this.validateFolder(tablePath, tableSmartObject, RB.getStringResource("ETLMigrationProcessor.typeName.Table.txt"));
                    upgradeSuccess = true;
                    continue;
                }
                status.addErrorException(browseTable, new Exception("Error creating object of proper type"));
            }
            catch (Exception e) {
                status.addErrorException(browseTable, e);
            }
            finally {
                if (upgradeSuccess) {
                    status.incrementMigrationSuccess();
                    cTransaction.commit();
                    continue;
                }
                status.incrementFailedMigrationVersion(browseTable.getName(), publicType);
                cTransaction.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateExternalFiles(ETLMigrationStatus status) throws RemoteException, ServiceException, MdException {
        List allTables = ETLMigrationUtility.getAllObjectsByMetadataType(this.m_Server, "ExternalTable", EXTERNALTABLE_TREES_TEMPLATE);
        for (BrowseMetadataInterface browseExtFile : allTables) {
            String publicType = (String)browseExtFile.get("PublicType");
            status.incrementTotalObjects();
            String extFilePath = this.validateContainer(browseExtFile, status);
            boolean bAlreadyUpgraded = this.validatePublicObjectAttributes(browseExtFile, status);
            ChildServerInterface cTransaction = this.m_Server.newChild(true);
            boolean upgradeSuccess = false;
            try {
                MetadataInterface extFileSmartObject = this.validateUpgradeInterface(cTransaction, browseExtFile, "ExternalFile");
                if (extFileSmartObject instanceof UpgradeInterface) {
                    UpgradeInterface externalFileUp = (UpgradeInterface)extFileSmartObject;
                    this.executeUpgrade(status, browseExtFile, extFilePath, bAlreadyUpgraded, externalFileUp);
                    this.validateFolder(extFilePath, extFileSmartObject, RB.getStringResource("ETLMigrationProcessor.typeName.ExternalFile.txt"));
                    upgradeSuccess = true;
                    continue;
                }
                status.addErrorException(browseExtFile, new Exception("Error creating object of proper type"));
            }
            catch (Exception e) {
                status.addErrorException(browseExtFile, e);
            }
            finally {
                if (upgradeSuccess) {
                    status.incrementMigrationSuccess();
                    cTransaction.commit();
                    continue;
                }
                status.incrementFailedMigrationVersion(browseExtFile.getName(), publicType);
                cTransaction.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateMessageQueue(ETLMigrationStatus status, Transformation messageQueue) throws RemoteException, ServiceException, MdException {
        List allQueues = ETLMigrationUtility.getObjectsByMetadataTypeAndAttrValue(this.m_Server, "Transformation", TRANSFORMATION_TREES_TEMPLATE, "Id", messageQueue.getId());
        for (BrowseMetadataInterface browseMessageQueue : allQueues) {
            String publicType = (String)browseMessageQueue.get("PublicType");
            String queuePath = this.validateContainer(browseMessageQueue, status);
            boolean bAlreadyUpgraded = false;
            ChildServerInterface cTransaction = this.m_Server.newChild(true);
            boolean upgradeSuccess = false;
            try {
                MetadataInterface extFileSmartObject = this.validateUpgradeInterface(cTransaction, browseMessageQueue, "MessageQueue");
                if (extFileSmartObject instanceof UpgradeInterface) {
                    UpgradeInterface messageQueueUp = (UpgradeInterface)extFileSmartObject;
                    this.executeUpgrade(status, browseMessageQueue, queuePath, bAlreadyUpgraded, messageQueueUp);
                    this.validateFolder(queuePath, extFileSmartObject, RB.getStringResource("ETLMigrationProcessor.typeName.MessageQueue.txt"));
                    upgradeSuccess = true;
                    continue;
                }
                status.addErrorException(browseMessageQueue, new Exception("Error creating object of proper type"));
            }
            catch (Exception e) {
                status.addErrorException(browseMessageQueue, e);
            }
            finally {
                if (upgradeSuccess) {
                    status.incrementMigrationSuccess();
                    cTransaction.commit();
                    continue;
                }
                status.incrementFailedMigrationVersion(browseMessageQueue.getName(), publicType);
                cTransaction.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateGeneratedTransforms(ETLMigrationStatus status) throws RemoteException, ServiceException, MdException {
        List allTables = ETLMigrationUtility.getObjectsByMetadataTypeAndAttrValue(this.m_Server, "Prototype", PROTOTYPE_TREES_TEMPLATE, "MetadataType", "TransformationStep2");
        for (BrowseMetadataInterface browseGenTxfrm : allTables) {
            status.incrementTotalObjects();
            String publicType = (String)browseGenTxfrm.get("PublicType");
            String genTxfrmFolder = this.validateContainer(browseGenTxfrm, status);
            boolean bAlreadyUpgraded = this.validatePublicObjectAttributes(browseGenTxfrm, status);
            ChildServerInterface cTransaction = this.m_Server.newChild(true);
            boolean upgradeSuccess = false;
            try {
                MetadataInterface generatedTransfromSO = this.validateUpgradeInterface(cTransaction, browseGenTxfrm, "GeneratedTransform");
                if (generatedTransfromSO instanceof UpgradeInterface) {
                    UpgradeInterface generatedTxFrmUpgrade = (UpgradeInterface)generatedTransfromSO;
                    this.executeUpgrade(status, browseGenTxfrm, genTxfrmFolder, bAlreadyUpgraded, generatedTxFrmUpgrade);
                    this.validateFolder(genTxfrmFolder, generatedTransfromSO, RB.getStringResource("ETLMigrationProcessor.typeName.GeneratedTransform.txt"));
                    upgradeSuccess = true;
                    continue;
                }
                status.addErrorException(browseGenTxfrm, new Exception("Error creating object of proper type"));
            }
            catch (Exception e) {
                status.addErrorException(browseGenTxfrm, e);
            }
            finally {
                if (upgradeSuccess) {
                    status.incrementMigrationSuccess();
                    cTransaction.commit();
                    continue;
                }
                status.incrementFailedMigrationVersion(browseGenTxfrm.getName(), publicType);
                cTransaction.rollback();
            }
        }
    }

    private MetadataInterface validateUpgradeInterface(ChildServerInterface cTransaction, BrowseMetadataInterface browseGenTxfrm, String publicType) throws RemoteException, MdException, ServiceException {
        Object reposObj;
        MetadataInterface generatedTransfromSO = cTransaction.fetch(browseGenTxfrm.getISEntityKey(), true);
        if (!(generatedTransfromSO instanceof UpgradeInterface) && (reposObj = generatedTransfromSO.getRepositoryEntity()) instanceof PrimaryType) {
            PrimaryType jOMAObject = (PrimaryType)reposObj;
            jOMAObject.setPublicType(publicType);
            jOMAObject.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
            String id = jOMAObject.getId();
            String type = jOMAObject.getCMetadataType();
            jOMAObject.updateMetadataAll();
            generatedTransfromSO = cTransaction.fetch(id + '/' + type, true);
        }
        return generatedTransfromSO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePreviousVersionGeneratedTransforms(ETLMigrationStatus status) throws RemoteException, ServiceException, MdException {
        List allTables = ETLMigrationUtility.getObjectsByMetadataTypeAndAttrValue(this.m_Server, "Prototype", PROTOTYPE_TREES_TEMPLATE, "MetadataType", "TransformationStep2");
        for (BrowseMetadataInterface browseGenTxfrm : allTables) {
            status.incrementTotalObjects();
            ChildServerInterface cTransaction = this.m_Server.newChild(true);
            boolean bChanges = false;
            try {
                Prototype genTxfrmPrototype;
                String currentObjectGUID;
                MetadataInterface generatedTransformSO = cTransaction.fetch(browseGenTxfrm.getISEntityKey(), true);
                Object re = generatedTransformSO.getRepositoryEntity();
                if (!(re instanceof Prototype) || !this.isDIStudioGUID(currentObjectGUID = MacroPluginUtilities.getGuid((Prototype)(genTxfrmPrototype = (Prototype)re)))) continue;
                bChanges = this.deleteGeneratedTransformation(status, browseGenTxfrm, generatedTransformSO, genTxfrmPrototype);
            }
            finally {
                if (bChanges) {
                    cTransaction.commit();
                    continue;
                }
                cTransaction.rollback();
            }
        }
    }

    private boolean deleteGeneratedTransformation(ETLMigrationStatus status, BrowseMetadataInterface browseTxfm, MetadataInterface generatedTransformSO, Prototype genTxfrmPrototype) {
        boolean bChanges = false;
        status.incrementDeletedObjects();
        try {
            if (this.isPreviousVersionRemovable()) {
                this.m_logger.debug((Object)"Setting public type and usage version to ensure proper delete");
                genTxfrmPrototype.setPublicType("GeneratedTransform");
                genTxfrmPrototype.setUsageVersion(FAILED_UPGRADE_VERSION.encode());
                genTxfrmPrototype.updateMetadataAll();
                this.m_logger.info((Object)Message.format((String)RB.getStringResource("ETLMigraitonProcessor.RemovingGeneratedTransformation.fmt"), (Object)generatedTransformSO.getName()));
                generatedTransformSO.delete();
                bChanges = true;
            }
        }
        catch (RemoteException e) {
            status.addErrorException(browseTxfm, e);
        }
        catch (ServiceException e) {
            status.addErrorException(browseTxfm, e);
        }
        catch (MdException e) {
            status.addErrorException(browseTxfm, e);
        }
        return bChanges;
    }

    private boolean isDIStudioGUID(String currentObjectGUID) {
        boolean returnValue = false;
        for (int i = 0; i < DI_STUDIO_GUIDS.length && !returnValue; ++i) {
            String diGUID = DI_STUDIO_GUIDS[i];
            if (!diGUID.equals(currentObjectGUID)) continue;
            returnValue = true;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrateJobs(ETLMigrationStatus status) throws RemoteException, ServiceException, MdException {
        List allJobs = ETLMigrationUtility.getAllObjectsByMetadataType(this.m_Server, "Job", JOB_TREES_TEMPLATE);
        String excludedJobTypes = "Job.";
        for (BrowseMetadataInterface browseJob : allJobs) {
            double usageVersion;
            String publicType = (String)browseJob.get("PublicType");
            String transformRole = (String)browseJob.get("TransformRole");
            status.incrementTotalObjects();
            String sUsage = (String)browseJob.get("UsageVersion");
            try {
                usageVersion = Double.parseDouble(sUsage);
            }
            catch (NumberFormatException e) {
                usageVersion = 0.0;
            }
            if (SCHEDULER_BRIDGE_JOB.equalsIgnoreCase(transformRole)) {
                status.incrementMigrationNotAttempted(browseJob.getName(), SCHEDULER_BRIDGE_JOB);
                ETLMigrationUtility.getLogger().info("Skipping Scheduler Bridge Job: \"" + browseJob.getName() + "\"");
                continue;
            }
            if (publicType != null && publicType.startsWith(excludedJobTypes)) {
                status.incrementMigrationNotAttempted(browseJob.getName(), publicType);
                ETLMigrationUtility.getLogger().info("Skipping Job subtype " + publicType + " named: \"" + browseJob.getName() + "\"");
                continue;
            }
            if (usageVersion > 0.0 && !"Job".equals(publicType)) {
                status.incrementMigrationNotAttempted(browseJob.getName(), publicType);
                ETLMigrationUtility.getLogger().info("the object named " + browseJob.getName() + " of type " + publicType + " has the nonzero UsageVersion " + usageVersion + " and will not be upgraded");
                continue;
            }
            String jobFolder = this.validateContainer(browseJob, status);
            boolean bAlreadyUpgraded = this.validatePublicObjectAttributes(browseJob, status);
            ChildServerInterface cTransaction = this.m_Server.newChild(true);
            boolean upgradeSuccess = false;
            try {
                MetadataInterface jobSmartObject = this.validateUpgradeInterface(cTransaction, browseJob, "Job");
                if (jobSmartObject instanceof UpgradeInterface) {
                    UpgradeInterface jobUp = (UpgradeInterface)jobSmartObject;
                    this.executeUpgrade(status, browseJob, jobFolder, bAlreadyUpgraded, jobUp);
                    this.validateFolder(jobFolder, jobSmartObject, RB.getStringResource("ETLMigrationProcessor.typeName.Job.txt"));
                    upgradeSuccess = true;
                    continue;
                }
                status.incrementFailedMigrationVersion(browseJob.getName(), publicType);
                status.addErrorException(browseJob, new Exception("Error creating object of proper type"));
            }
            catch (Exception e) {
                status.addErrorException(browseJob, e);
            }
            catch (Throwable e) {
                status.addErrorException(browseJob, e);
            }
            finally {
                if (upgradeSuccess) {
                    status.incrementMigrationSuccess();
                    cTransaction.commit();
                    continue;
                }
                status.incrementFailedMigrationVersion(browseJob.getName(), publicType);
                cTransaction.rollback();
            }
        }
    }

    private void validateFolder(String folderName, MetadataInterface smartObject, String typeName) throws ServiceException, RemoteException {
        if (folderName != null && folderName.length() > 0) {
            PathUrl jobPath = smartObject.getPathUrl();
            if (jobPath == null) {
                this.m_logger.warn((Object)Message.format((String)RB.getStringResource("ETLMigrationProcessor.invalidPathUrl.fmt"), (Object)typeName, (Object)smartObject.getName()));
            } else {
                this.m_logger.debug((Object)("Processed \"" + jobPath.getAbsolutePath() + "\""));
            }
        }
    }

    public List getStatusList() {
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldSoftwareComponent(ETLMigrationStatus status) throws RemoteException, ServiceException, MdException {
        List sftwreComps = ETLMigrationUtility.getObjectsByMetadataTypeAndAttrValue(this.m_Server, "SoftwareComponent", SOFTWARE_COMPONENT_TREES_TEMPLATE, "ClassIdentifier", OLD_SOFTWARE_COMPONENT_CLASS);
        for (BrowseMetadataInterface browseGenTxfrm : sftwreComps) {
            status.incrementTotalObjects();
            ChildServerInterface cTransaction = this.m_Server.newChild(true);
            boolean bChanges = false;
            try {
                MetadataInterface softwareCompDI = cTransaction.fetch(browseGenTxfrm.getISEntityKey(), true);
                this.m_logger.info((Object)Message.format((String)RB.getStringResource("ETLMigraitonProcessor.RemovingSoftwareComponent.fmt"), (Object)softwareCompDI.getName()));
                softwareCompDI.delete();
                bChanges = true;
            }
            finally {
                if (bChanges) {
                    cTransaction.commit();
                    continue;
                }
                cTransaction.rollback();
            }
        }
    }
}

