/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.migration;

import com.sas.etl.migration.ETLMigrationStatus;
import com.sas.etl.migration.ETLMigrationUtility;
import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.ILogger;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.List;

public class AbstractMigrationProcessor {
    protected ILogger m_logger = ETLMigrationUtility.getLogger(0);
    private boolean m_bExecuteMigration = true;
    private boolean m_bFixBrokenObjects = false;
    private boolean m_bRemovePrevVerObjects = false;
    private boolean m_bMigrateDataTypes = false;
    private boolean m_bMigrateETLTypes = true;
    public static final UsageVersion FAILED_UPGRADE_VERSION = new UsageVersion(0, 5);

    protected String validateContainer(BrowseMetadataInterface browseObject, ETLMigrationStatus status) {
        List parents = browseObject.getParents();
        String oPublicType = (String)browseObject.get("PublicType");
        String tablePath = "";
        if (parents != null && parents.size() == 1) {
            BrowseMetadataInterface parent = (BrowseMetadataInterface)parents.get(0);
            tablePath = parent.getName();
        } else if (parents != null) {
            if (parents.size() > 0) {
                status.incrementMultipleTrees(browseObject.getName(), oPublicType);
            } else {
                status.incrementNotInTrees(browseObject.getName(), oPublicType);
            }
        }
        return tablePath;
    }

    protected boolean validatePublicTypeSet(BrowseMetadataInterface browseObject, ETLMigrationStatus status) {
        String publicType;
        boolean returnValue = true;
        String oPublicType = (String)browseObject.get("PublicType");
        if (oPublicType == null) {
            status.incrementPublicTypeNotSet(browseObject.getName(), oPublicType);
            returnValue = false;
        } else if (oPublicType instanceof String && (publicType = oPublicType).length() == 0) {
            status.incrementPublicTypeNotSet(browseObject.getName(), oPublicType);
            returnValue = false;
            ETLMigrationUtility.getLogger().debug("Public type not set: " + browseObject.toString());
        }
        return returnValue;
    }

    protected boolean validateUsageVersionSet(BrowseMetadataInterface browseObject, ETLMigrationStatus status) throws ParseException {
        boolean returnValue = true;
        String oPublicType = (String)browseObject.get("PublicType");
        Object oUsageVersion = browseObject.get("UsageVersion");
        if (oUsageVersion == null) {
            status.incrementUsageVersionNotValid(browseObject.getName(), oPublicType);
            returnValue = false;
        } else if (oUsageVersion instanceof String) {
            String name = (String)oUsageVersion;
            if (name.length() == 0) {
                status.incrementUsageVersionNotValid(browseObject.getName(), oPublicType);
                returnValue = false;
            } else {
                UsageVersion usageVersion = UsageVersion.decode((double)Double.parseDouble(name));
                if (WsAbstractVersionedObjectManager.isUpgradeable((String)oPublicType, (UsageVersion)usageVersion)) {
                    status.incrementUsageVersionNotValid(browseObject.getName(), oPublicType);
                    if (usageVersion.encode() == FAILED_UPGRADE_VERSION.encode()) {
                        status.incrementFailedMigrationVersion(browseObject.getName(), browseObject.getSmartType());
                    }
                    returnValue = false;
                    ETLMigrationUtility.getLogger().debug("UsageVersion not correct was \"" + name + "\" on object " + browseObject.toString());
                }
            }
        }
        return returnValue;
    }

    protected boolean validatePublicObjectAttributes(BrowseMetadataInterface object, ETLMigrationStatus status) {
        boolean returnValue = true;
        boolean publicTypeCorrect = false;
        boolean usageVersionIncorrect = false;
        try {
            publicTypeCorrect = this.validatePublicTypeSet(object, status);
            usageVersionIncorrect = this.validateUsageVersionSet(object, status);
        }
        catch (ParseException pe) {
            status.addErrorException(object, pe);
        }
        if (!publicTypeCorrect || !usageVersionIncorrect) {
            returnValue = false;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeUpgrade(ETLMigrationStatus status, BrowseMetadataInterface browseObject, String folderName, boolean bAlreadyUpgraded, UpgradeInterface upgradeObject) {
        block10: {
            try {
                if (this.m_bExecuteMigration) {
                    if (this.m_bFixBrokenObjects) {
                        if (!bAlreadyUpgraded) {
                            this.m_logger.debug((Object)("Migrating \"" + upgradeObject + "\" from folder \"" + folderName + "\""));
                            status.incrementMigrationExecution();
                            upgradeObject.upgradeFromPreviousVersion();
                        } else {
                            status.incrementAlreadyMigrated();
                            this.m_logger.info((Object)("Excluding object \"" + upgradeObject + "\" from folder \"" + folderName + "\" already upgraded"));
                        }
                    } else {
                        this.m_logger.debug((Object)("Migrating \"" + upgradeObject + "\" from folder \"" + folderName + "\""));
                        status.incrementMigrationExecution();
                        upgradeObject.upgradeFromPreviousVersion();
                    }
                    break block10;
                }
                this.m_logger.debug((Object)("Analyzing \"" + upgradeObject + "\" from folder \"" + folderName + "\""));
            }
            catch (ServiceException se) {
                this.m_logger.error((Object)se.getLocalizedMessage(), (Throwable)se);
                status.addErrorException(browseObject, se);
            }
            catch (RemoteException re) {
                this.m_logger.error((Object)re.getLocalizedMessage(), (Throwable)re);
                status.addErrorException(browseObject, re);
            }
        }
    }

    public void setExecuteMigration(boolean execute) {
        this.m_bExecuteMigration = execute;
    }

    public void setFixBrokenObjectsOnly(boolean fixOnly) {
        this.m_bFixBrokenObjects = fixOnly;
    }

    public void setRemovePreviousVersionObjects(boolean removePrevVerObjects) {
        this.m_bRemovePrevVerObjects = removePrevVerObjects;
    }

    public boolean isPreviousVersionRemovable() {
        return this.m_bRemovePrevVerObjects;
    }

    public void setMigrateDataTypes(boolean migrateDataTypes) {
        this.m_bMigrateDataTypes = migrateDataTypes;
    }

    public boolean isMigrateDataTypes() {
        return this.m_bMigrateDataTypes;
    }

    public void setMigrateETLTypes(boolean migrateETLTypes) {
        this.m_bMigrateETLTypes = migrateETLTypes;
    }

    public boolean isMigrateETLTypes() {
        return this.m_bMigrateETLTypes;
    }

    public boolean isExecuteMigration() {
        return this.m_bExecuteMigration;
    }

    public boolean isFixBrokenObjects() {
        return this.m_bFixBrokenObjects;
    }

    public boolean isRemovePreviousVersionObjects() {
        return this.m_bRemovePrevVerObjects;
    }
}

