/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.armreader;

import com.sas.tools.armreader.Transaction;
import java.util.Comparator;
import java.util.Hashtable;

public class TransactionComparator {
    public static Hashtable lookupTable = new Hashtable();
    public static Comparator byOccurrences = new Comparator(){

        public int compare(Object o1, Object o2) {
            int v2;
            int v1 = ((Transaction)o1).getOccurrences();
            return v1 < (v2 = ((Transaction)o2).getOccurrences()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator byWallTotal = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v2;
            double v1 = ((Transaction)o1).getWallTime();
            return v1 < (v2 = ((Transaction)o2).getWallTime()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator byWallAvg = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v2;
            double v1 = ((Transaction)o1).getWallTime() / (double)((Transaction)o1).getOccurrences();
            return v1 < (v2 = ((Transaction)o2).getWallTime() / (double)((Transaction)o2).getOccurrences()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator byCpuTotal = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v2;
            double v1 = ((Transaction)o1).getCpuTime();
            return v1 < (v2 = ((Transaction)o2).getCpuTime()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator byCpuAvg = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v2;
            double v1 = ((Transaction)o1).getCpuTime() / (double)((Transaction)o1).getOccurrences();
            return v1 < (v2 = ((Transaction)o2).getCpuTime() / (double)((Transaction)o2).getOccurrences()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator bySysTotal = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v2;
            double v1 = ((Transaction)o1).getSysTime();
            return v1 < (v2 = ((Transaction)o2).getSysTime()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator bySysAvg = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v2;
            double v1 = ((Transaction)o1).getSysTime() / (double)((Transaction)o1).getOccurrences();
            return v1 < (v2 = ((Transaction)o2).getSysTime() / (double)((Transaction)o2).getOccurrences()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator byRowsTotal = new Comparator(){

        public int compare(Object o1, Object o2) {
            long v2;
            long v1 = ((Transaction)o1).getNumRows();
            return v1 < (v2 = ((Transaction)o2).getNumRows()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator byRowsAvg = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v2;
            double v1 = (double)((Transaction)o1).getNumRows() / (double)((Transaction)o1).getOccurrences();
            return v1 < (v2 = (double)((Transaction)o2).getNumRows() / (double)((Transaction)o2).getOccurrences()) ? 1 : (v1 == v2 ? 0 : -1);
        }
    };
    public static Comparator byRegionLevels = new Comparator(){

        public int compare(Object o1, Object o2) {
            String v1 = ((Transaction)o1).getRegionLevels();
            String v2 = ((Transaction)o2).getRegionLevels();
            return v1.compareTo(v2);
        }
    };
    public static Comparator byAggrLevels = new Comparator(){

        public int compare(Object o1, Object o2) {
            String v1 = ((Transaction)o1).getAggrLevels();
            String v2 = ((Transaction)o2).getAggrLevels();
            return v1.compareTo(v2);
        }
    };

    public static Comparator lookup(String comparatorName) {
        return (Comparator)lookupTable.get(comparatorName);
    }

    static {
        lookupTable.put("occurrences", byOccurrences);
        lookupTable.put("wall", byWallTotal);
        lookupTable.put("wallavg", byWallAvg);
        lookupTable.put("cpu", byCpuTotal);
        lookupTable.put("cpuavg", byCpuAvg);
        lookupTable.put("sys", bySysTotal);
        lookupTable.put("sysavg", bySysAvg);
        lookupTable.put("rows", byRowsTotal);
        lookupTable.put("rowsavg", byRowsAvg);
        lookupTable.put("regionlevels", byRegionLevels);
        lookupTable.put("aggrlevels", byAggrLevels);
    }
}

