/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.armreader;

import com.sas.tools.armreader.ArmReaderException;
import com.sas.tools.armreader.IProgressMonitor;
import com.sas.tools.armreader.Messages;
import com.sas.tools.armreader.StringSplitter;
import com.sas.tools.armreader.Transaction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Analyzer {
    private static final StringSplitter commaSplitter = StringSplitter.compile(',');
    private static final String OLAP_APPLICATION = "2";
    private static final String OLAP_SESSION_NAME = "OLAP_SESSION";
    private static final String DATA_QUERY_NAME = "DATA_QUERY";
    private String OLAP_SESSION_CLASS;
    private String DATA_QUERY_CLASS;
    private String cubeName;
    private File inputFile;
    private long charsRead;
    private long numCompletedTransactions;
    private Map completedTransactions = new Hashtable();
    private Map pendingTransactions = new Hashtable();
    private Map allRegions = new Hashtable();
    private Hashtable allHierarchies = new Hashtable();
    private Set allCubes = new HashSet();
    private String charsetName = System.getProperty("file.encoding");

    private void aggregate(Transaction transaction) {
        ++this.numCompletedTransactions;
        Transaction existing = (Transaction)this.completedTransactions.get(transaction.getRegionLevels());
        if (existing == null) {
            this.completedTransactions.put(transaction.getRegionLevels(), transaction);
        } else {
            existing.aggregateWith(transaction);
        }
    }

    public void doit(IProgressMonitor monitor) throws IOException, ArmReaderException {
        String line;
        if (this.cubeName == null) {
            throw new RuntimeException(Messages.getString("Analyzer.NoCubeName"));
        }
        if (this.inputFile == null) {
            throw new RuntimeException(Messages.getString("Analyzer.NoInputFile"));
        }
        if (monitor != null) {
            monitor.beginTask(this.inputFile.getName(), (int)(this.inputFile.length() / 0x100000L));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.inputFile), this.charsetName));
        long worked = 0L;
        while ((line = reader.readLine()) != null) {
            String[] tokens;
            this.charsRead += (long)(line.length() + 1);
            if (monitor != null) {
                if (monitor.isCanceled()) break;
                if ((worked += (long)(line.length() + 1)) > 0x100000L) {
                    monitor.worked((int)(worked / 0x100000L));
                    worked = 0L;
                }
            }
            if ((tokens = commaSplitter.split(line)).length < 3) {
                throw new ArmReaderException(Messages.getString("Analyzer.InvalidARMFile"));
            }
            char type = tokens[0].charAt(0);
            if (type == '\ufeff' && tokens[0].length() > 1) {
                type = tokens[0].charAt(1);
            }
            if (!OLAP_APPLICATION.equals(tokens[2])) continue;
            this.parseOlapApplication(line, tokens, type);
        }
        this.postProcess();
        if (monitor != null) {
            monitor.done();
        }
    }

    private void postProcess() throws ArmReaderException {
        if (this.pendingTransactions.size() != 0) {
            this.error(MessageFormat.format(Messages.getString("Analyzer.ARMFileProblem"), new Integer(this.pendingTransactions.size())));
        }
        if (this.completedTransactions.size() > 0 & this.allHierarchies.isEmpty()) {
            throw new ArmReaderException(Messages.getString("Analyzer.MissingRequiredRecords"));
        }
        Hashtable<Map, Transaction> allLevels = new Hashtable<Map, Transaction>();
        Iterator iter = this.completedTransactions.values().iterator();
        while (iter.hasNext()) {
            Transaction transaction = (Transaction)iter.next();
            transaction.setRegionLevelsMap(this.mapLevels(transaction.getRegionLevels()));
            transaction.setAggrLevelsMap(this.mapLevels(transaction.getAggrLevels()));
            Transaction existing = (Transaction)allLevels.get(transaction.getRegionLevelsMap());
            if (existing == null) {
                allLevels.put(transaction.getRegionLevelsMap(), transaction);
                continue;
            }
            existing.aggregateWith(transaction);
            iter.remove();
        }
    }

    private void parseOlapApplication(String line, String[] tokens, char type) throws ArmReaderException {
        switch (type) {
            case 'G': {
                if (tokens.length < 6) break;
                if (OLAP_SESSION_NAME.equals(tokens[4])) {
                    this.OLAP_SESSION_CLASS = tokens[3];
                    break;
                }
                if (!DATA_QUERY_NAME.equals(tokens[4])) break;
                this.DATA_QUERY_CLASS = tokens[3];
                break;
            }
            case 'C': 
            case 'P': 
            case 'S': 
            case 'U': {
                if (this.OLAP_SESSION_CLASS == null || this.DATA_QUERY_CLASS == null) {
                    throw new ArmReaderException(Messages.getString("Analyzer.MissingClasses"));
                }
                if (tokens.length < 5) break;
                String transactionId = tokens[4];
                if (this.DATA_QUERY_CLASS.equals(tokens[3])) {
                    this.parseDataQuery(line, tokens, type, transactionId);
                    break;
                }
                if (!this.OLAP_SESSION_CLASS.equals(tokens[3])) break;
                this.parseOlapSession(line, tokens, type, transactionId);
                break;
            }
        }
    }

    private void parseOlapSession(String line, String[] tokens, char type, String transactionId) throws ArmReaderException {
        try {
            switch (type) {
                case 'U': {
                    if (tokens.length < 9) break;
                    if (!OLAP_APPLICATION.equals(tokens[7])) {
                        this.error(line, Messages.getString("Analyzer.InvalidBufferType") + tokens[7]);
                        break;
                    }
                    String info = tokens[8];
                    for (int i = 9; i < tokens.length; ++i) {
                        info = info + "," + tokens[i];
                    }
                    String updatedCubeName = info.substring(0, 32).trim();
                    this.allCubes.add(updatedCubeName);
                    if (this.cubeName.equalsIgnoreCase(updatedCubeName)) {
                        String hierarchyId = info.substring(32, 36).trim();
                        this.allHierarchies.put(hierarchyId, info.substring(36, 68).trim());
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ArmReaderException(Messages.getString("Analyzer.InvalidARMFile"));
        }
    }

    private void parseDataQuery(String line, String[] tokens, char type, String transactionId) throws ArmReaderException {
        try {
            switch (type) {
                case 'C': {
                    if (tokens.length < 9) break;
                    this.pendingTransactions.put(transactionId, new Transaction(tokens[1], tokens[7], tokens[8]));
                    break;
                }
                case 'S': {
                    if (tokens.length < 7) break;
                    this.pendingTransactions.put(transactionId, new Transaction(tokens[1], tokens[5], tokens[6]));
                    break;
                }
                case 'U': {
                    if (tokens.length < 9) break;
                    if (!OLAP_APPLICATION.equals(tokens[7])) {
                        this.error(line, Messages.getString("Analyzer.InvalidBufferType") + tokens[7]);
                        break;
                    }
                    String info = tokens[8];
                    for (int i = 9; i < tokens.length; ++i) {
                        info = info + "," + tokens[i];
                    }
                    String tempCubeName = info.substring(0, 32).trim();
                    if (this.cubeName.equalsIgnoreCase(tempCubeName)) {
                        String regionId = info.substring(32, 48).trim();
                        this.allRegions.put(regionId, info.substring(48));
                    }
                    break;
                }
                case 'P': {
                    if (tokens.length < 14) break;
                    Transaction transaction = (Transaction)this.pendingTransactions.get(transactionId);
                    if (transaction == null) {
                        this.error(line, Messages.getString("Analyzer.UnknownTransaction") + transactionId);
                        break;
                    }
                    String tempCubeName = tokens[13].trim();
                    for (int i = 14; i < tokens.length; ++i) {
                        tempCubeName = tempCubeName + "," + tokens[i];
                    }
                    if (this.cubeName.equalsIgnoreCase(tempCubeName = tempCubeName.trim())) {
                        String regionId = tokens[8];
                        String aggrId = tokens[9];
                        boolean exact = aggrId.equals(regionId);
                        String regionLevels = (String)this.allRegions.get(regionId);
                        String aggrLevels = (String)this.allRegions.get(aggrId);
                        if (regionLevels == null) {
                            this.error(line, Messages.getString("Analyzer.UnknownRegion") + regionId);
                        } else if (aggrLevels == null) {
                            this.error(line, Messages.getString("Analyzer.UnknownAggregate") + aggrId);
                        } else {
                            transaction.stop(tokens[1], tokens[5], tokens[6], tokens[10], tokens[11], regionLevels, aggrLevels, exact);
                            this.aggregate(transaction);
                        }
                        if (!exact) {
                            this.allRegions.remove(regionId);
                        }
                    }
                    this.pendingTransactions.remove(transactionId);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new ArmReaderException(Messages.getString("Analyzer.InvalidARMFile"));
        }
    }

    private void error(String errorMessage) {
        System.err.println(errorMessage);
    }

    private void error(String line, String errorMessage) {
        System.err.println(MessageFormat.format(Messages.getString("Analyzer.ParsingError"), line, errorMessage));
    }

    private Map mapLevels(String levels) {
        Hashtable<String, Integer> levelMap = new Hashtable<String, Integer>();
        String[] levTokens = levels.trim().split("\\s++");
        int numHierarchies = Integer.parseInt(levTokens[0].trim());
        for (int i = 1; i <= numHierarchies; ++i) {
            String hierarchyId = levTokens[i * 2 - 1];
            String hierarchyName = (String)this.allHierarchies.get(hierarchyId);
            Integer hierarchyLevel = Integer.valueOf(levTokens[i * 2].trim());
            levelMap.put(hierarchyName, hierarchyLevel);
        }
        return levelMap;
    }

    public Transaction[] getCompletedTransactions() {
        return this.completedTransactions.values().toArray(new Transaction[this.completedTransactions.values().size()]);
    }

    public long getCharsRead() {
        return this.charsRead;
    }

    public long getNumCompletedTransactions() {
        return this.numCompletedTransactions;
    }

    public Set getAllCubes() {
        return this.allCubes;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

