/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tk.tkwsc;

import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.environment.Environment;
import com.sas.svcs.environment.xml.XmlEnvironmentManager;
import com.sas.tk.tkwsc.ResponseInterceptor;
import com.sas.tk.tkwsc.SoapMessageCallback;
import java.io.File;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.axiom.AxiomSoapMessageFactory;
import org.springframework.ws.soap.client.SoapFaultClientException;
import org.springframework.ws.soap.security.wss4j2.Wss4jSecurityInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponentsMessageSender;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapThread
extends Thread {
    String m_action = null;
    boolean m_responseEnvelope = false;
    PipedOutputStream m_response = null;
    PipedInputStream m_request = null;
    Exception m_exception = null;
    ArrayList m_soapHeaderElements = null;
    StreamSource m_source = null;
    StreamResult m_result = null;
    WebServiceTemplate m_webServiceTemplate = null;
    SoapMessageCallback m_soapMessageCallback = null;
    Logger m_logger = null;
    FileAppender m_logFile = null;

    private RequestElement getRequestElement() throws Exception {
        try (XMLStreamReader reader = null;){
            reader = XMLInputFactory.newInstance().createXMLStreamReader(this.m_request);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)fac, (XMLStreamReader)reader);
            OMElement request = builder.getDocumentElement();
            request.build();
            String name = request.getLocalName();
            OMNamespace omNS = request.getNamespace();
            String nameSpace = omNS.getNamespaceURI();
            if (name.equals("Envelope") && nameSpace.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                QName qName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                OMElement soapBody = request.getFirstChildWithName(qName);
                QName headerQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header");
                OMElement headerElement = request.getFirstChildWithName(headerQName);
                if (headerElement != null) {
                    Iterator headerIterator = headerElement.getChildElements();
                    while (headerIterator.hasNext()) {
                        if (this.m_soapHeaderElements == null) {
                            this.m_soapHeaderElements = new ArrayList();
                        }
                        this.m_soapHeaderElements.add(headerIterator.next());
                    }
                }
                Iterator iter = soapBody.getChildElements();
                OMElement first = (OMElement)iter.next();
                RequestElement reqElem = new RequestElement(first, true);
                while (iter.hasNext()) {
                    OMElement elem = (OMElement)iter.next();
                    reqElem.addElement(elem);
                }
                Iterator nsIterator = request.getAllDeclaredNamespaces();
                while (nsIterator.hasNext()) {
                    Object o = nsIterator.next();
                    if (!(o instanceof OMNamespace)) continue;
                    iter = soapBody.getChildElements();
                    while (iter.hasNext()) {
                        OMElement elem = (OMElement)iter.next();
                        elem.declareNamespace((OMNamespace)o);
                    }
                }
                if (reader != null) {
                    reader.close();
                }
                RequestElement requestElement = reqElem;
                return requestElement;
            }
            RequestElement requestElement = new RequestElement(request, false);
            return requestElement;
        }
    }

    public SoapThread(String url, String action, PipedInputStream request, PipedOutputStream response, String configFile, String debugFile, String proxyHost, int proxyPort, String proxyUserName, String proxyPassword, String proxyDomain, String webUserName, String webPassword, String webDomain, String wsUserName, String wsPassword, String srsUrl, String envFile, String environment, String service, boolean responseEnvelope, boolean mustUnderstand) throws Exception {
        if (debugFile.length() > 0) {
            this.m_logger = LogManager.getLogger((String)"httpclient.wire");
            if (!this.m_logger.isTraceEnabled()) {
                LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
                Configuration config = lc.getConfiguration();
                PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%d %5p [%c] %m%n").build();
                FileAppender fp1 = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName(debugFile)).withFileName(debugFile).setLayout((Layout)layout)).setConfiguration(config)).build();
                fp1.start();
                config.addAppender((Appender)fp1);
                lc.getLogger(this.m_logger.getName()).addAppender(config.getAppender(fp1.getName()));
                lc.getLogger(this.m_logger.getName()).setLevel(Level.DEBUG);
                lc.updateLoggers();
            }
        }
        ClientInterceptor[] clientInterceptors = null;
        int numInterceptor = 1;
        if (wsUserName.length() > 0) {
            ++numInterceptor;
        }
        if (numInterceptor > 0) {
            clientInterceptors = new ClientInterceptor[numInterceptor];
            numInterceptor = 0;
        }
        this.m_soapMessageCallback = new SoapMessageCallback();
        try {
            RequestConfig requestConfig = null;
            if (configFile.length() > 0) {
                XmlBeanFactory beanFactory = new XmlBeanFactory((Resource)new FileSystemResource(configFile));
                requestConfig = (RequestConfig)beanFactory.getBean("requestConfig");
            } else {
                String contextName = "soap-client-config.xml";
                String packageName = this.getClass().getPackage().getName();
                int packageNameL = packageName.length();
                int bufL = packageNameL + "soap-client-config.xml".length() + 1;
                StringBuffer buf = new StringBuffer(bufL);
                buf.append(packageName);
                for (int i = 0; i < packageNameL; ++i) {
                    if (buf.charAt(i) != '.') continue;
                    buf.setCharAt(i, '/');
                }
                buf.append('/').append("soap-client-config.xml");
                String contextPath = buf.toString();
                ClassPathXmlApplicationContext soapThreadContext = new ClassPathXmlApplicationContext(contextPath);
                requestConfig = ((RequestConfig.Builder)soapThreadContext.getBean("requestConfigBuilder")).build();
            }
            this.m_webServiceTemplate = new WebServiceTemplate();
            AxiomSoapMessageFactory messageFactory = new AxiomSoapMessageFactory();
            messageFactory.setAttachmentCacheDir(new File(System.getProperty("java.io.tmpdir")));
            this.m_webServiceTemplate.setMessageFactory((WebServiceMessageFactory)messageFactory);
            this.m_soapMessageCallback.SetAction(action);
            this.m_request = request;
            this.m_response = response;
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (proxyHost != null && proxyHost.length() > 0) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                httpClientBuilder.setProxy(proxy);
                if (proxyUserName != null && proxyUserName.length() > 0 && proxyPassword != null && proxyPassword.length() > 0 && proxyDomain != null && proxyDomain.length() > 0) {
                    credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUserName, proxyPassword, proxyHost, proxyDomain));
                } else if (proxyUserName != null && proxyUserName.length() > 0 && proxyPassword != null && proxyPassword.length() > 0) {
                    credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUserName, proxyPassword));
                }
            }
            if (webUserName != null && webUserName.length() > 0 && webPassword != null && webPassword.length() > 0) {
                URL hostUrl = new URL(url);
                Object defaultcreds = null;
                defaultcreds = webDomain != null && webDomain.length() > 0 ? new NTCredentials(webUserName, webPassword, hostUrl.getHost(), webDomain) : new UsernamePasswordCredentials(webUserName, webPassword);
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            }
            CloseableHttpClient httpClient = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            if (wsUserName != null && wsUserName.length() > 0 && wsPassword != null) {
                if (environment.length() > 0) {
                    XmlEnvironmentManager envMgr = null;
                    Environment env = null;
                    envMgr = envFile.length() > 0 ? new XmlEnvironmentManager(envFile) : new XmlEnvironmentManager();
                    Map environments = envMgr.getEnvironments();
                    Set keys = environments.keySet();
                    for (String keyEnv : keys) {
                        if (!keyEnv.equals(environment)) continue;
                        env = (Environment)environments.get(keyEnv);
                        break;
                    }
                    if (env != null) {
                        srsUrl = env.getServiceRegistry();
                    }
                    ServiceRegistryClient srClient = new ServiceRegistryClient(srsUrl);
                    srClient.obtainServices();
                    url = srClient.getServiceURL(service);
                }
                if (srsUrl.length() > 0) {
                    SecurityTokenServiceClient sts = new SecurityTokenServiceClient(srsUrl, wsUserName, wsPassword);
                    sts.obtainToken();
                    wsUserName = sts.getSecurityContextKey();
                    wsPassword = sts.getBinarySecret();
                }
                Wss4jSecurityInterceptor wsSecurityInterceptor = new Wss4jSecurityInterceptor();
                wsSecurityInterceptor.setSecureRequest(true);
                wsSecurityInterceptor.setSecureResponse(false);
                wsSecurityInterceptor.setSecurementMustUnderstand(mustUnderstand);
                if (srsUrl.length() > 0) {
                    wsSecurityInterceptor.setSecurementPasswordType("PasswordDigest");
                    wsSecurityInterceptor.setSecurementActions("UsernameToken Timestamp");
                } else {
                    wsSecurityInterceptor.setSecurementPasswordType("PasswordText");
                    wsSecurityInterceptor.setSecurementActions("UsernameToken");
                }
                wsSecurityInterceptor.setSecurementUsername(wsUserName);
                wsSecurityInterceptor.setSecurementPassword(wsPassword);
                clientInterceptors[numInterceptor++] = wsSecurityInterceptor;
            }
            this.m_webServiceTemplate.setDefaultUri(url);
            ResponseInterceptor responseInterceptor = new ResponseInterceptor();
            responseInterceptor.setResponseStream(this.m_response);
            responseInterceptor.setEnvelope(responseEnvelope);
            clientInterceptors[numInterceptor++] = responseInterceptor;
            this.m_webServiceTemplate.setInterceptors(clientInterceptors);
            HttpComponentsMessageSender messageSender = new HttpComponentsMessageSender((HttpClient)httpClient);
            this.m_webServiceTemplate.setMessageSender((WebServiceMessageSender)messageSender);
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                }
            });
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.m_logger != null) {
                Configurator.setLevel((String)this.m_logger.getName(), (Level)Level.OFF);
                this.m_logFile.stop();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            RequestElement reqElement = this.getRequestElement();
            String request = reqElement.toString();
            if (this.m_soapHeaderElements != null) {
                for (OMElement header : this.m_soapHeaderElements) {
                    this.m_soapMessageCallback.addHeader(header);
                }
            }
            if (reqElement.isMulti()) {
                ArrayList<OMElement> elements = reqElement.getElements();
                this.m_soapMessageCallback.addElements(elements);
            }
            this.m_source = new StreamSource(new StringReader(request));
            StringWriter outWriter = new StringWriter();
            this.m_result = new StreamResult(outWriter);
            this.m_webServiceTemplate.sendSourceAndReceiveToResult((Source)this.m_source, (WebServiceMessageCallback)this.m_soapMessageCallback, (Result)this.m_result);
        }
        catch (Exception e) {
            this.m_exception = e;
        }
        catch (OutOfMemoryError e) {
            this.m_exception = new Exception("Java Process is out of memory", e);
        }
        catch (Throwable t) {
            this.m_exception = new Exception(t);
        }
        finally {
            try {
                this.m_response.close();
            }
            catch (Exception eatit) {
                eatit.printStackTrace();
            }
            if (this.m_logger != null) {
                try {
                    Configurator.setLevel((String)this.m_logger.getName(), (Level)Level.OFF);
                    this.m_logFile.stop();
                }
                catch (Exception eatit) {}
            }
        }
    }

    public void getException() throws Exception {
        if (this.m_exception != null) {
            if (this.m_exception instanceof SoapFaultClientException) {
                SoapFaultClientException soapFaultEx = (SoapFaultClientException)this.m_exception;
                String msg = soapFaultEx.getMessage();
                SoapFault soapFault = soapFaultEx.getSoapFault();
                SoapFaultDetail soapDetail = soapFault.getFaultDetail();
                if (soapDetail != null) {
                    Iterator it = soapDetail.getDetailEntries();
                    while (it.hasNext()) {
                        SoapFaultDetailElement element = (SoapFaultDetailElement)it.next();
                        DOMResult dom = new DOMResult();
                        Source elementSource = element.getSource();
                        TransformerFactory tf = TransformerFactory.newInstance();
                        Transformer trans = tf.newTransformer();
                        trans.transform(elementSource, dom);
                        Node detailNode = dom.getNode();
                        NodeList childNodes = detailNode.getChildNodes();
                        for (int i = 0; i < childNodes.getLength(); ++i) {
                            Node currentNode = childNodes.item(i);
                            if (currentNode.getLocalName().compareTo("errorstring") != 0) continue;
                            String value = currentNode.getTextContent();
                            msg = msg + ": " + value;
                        }
                    }
                }
                msg = msg.replaceAll("\t", " ");
                msg = msg.replaceAll("\n", " ");
                throw new Exception(msg);
            }
            throw this.m_exception;
        }
    }

    private class RequestElement {
        private OMElement element = null;
        private boolean isbody = false;
        private ArrayList<OMElement> elements = null;

        public RequestElement(OMElement element, boolean isbody) {
            this.element = element;
            this.isbody = isbody;
            if (isbody) {
                this.elements = new ArrayList();
            }
        }

        public void addElement(OMElement element) {
            if (this.elements != null) {
                this.elements.add(element);
            }
        }

        public String toString() {
            return this.element.toString();
        }

        public ArrayList<OMElement> getElements() {
            return this.elements;
        }

        public boolean isMulti() {
            return this.elements != null && this.elements.size() > 0;
        }
    }
}

