/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tk.tkwsc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPMessage;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.axiom.AxiomSoapMessage;

public class ResponseInterceptor
implements ClientInterceptor {
    private PipedOutputStream m_response = null;
    private boolean m_envelope;

    public void setEnvelope(boolean envelope) {
        this.m_envelope = envelope;
    }

    public void setResponseStream(PipedOutputStream response) {
        this.m_response = response;
    }

    public boolean handleFault(MessageContext arg0) throws WebServiceClientException {
        this.serializeResponse(arg0);
        return false;
    }

    public boolean handleRequest(MessageContext arg0) throws WebServiceClientException {
        return true;
    }

    public boolean handleResponse(MessageContext arg0) throws WebServiceClientException {
        this.serializeResponse(arg0);
        return false;
    }

    public void afterCompletion(MessageContext arg0, Exception e) throws WebServiceClientException {
    }

    private void serializeResponse(MessageContext arg0) {
        AxiomSoapMessage resultMsg = (AxiomSoapMessage)arg0.getResponse();
        SOAPMessage soapMsg = resultMsg.getAxiomMessage();
        try {
            if (this.m_envelope) {
                soapMsg.serialize((OutputStream)this.m_response);
            } else {
                SOAPBody body = soapMsg.getSOAPEnvelope().getBody();
                int i = 0;
                Iterator iter = body.getChildElements();
                while (iter.hasNext()) {
                    ++i;
                    iter.next();
                }
                if (i > 1) {
                    this.m_response.write(body.toString().getBytes("UTF-8"));
                } else {
                    this.m_response.write(body.getFirstElement().toString().getBytes("UTF-8"));
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

