/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.visuals;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTException;
import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.metadata.tools.cst.Validations;
import com.sas.metadata.tools.cst.visuals.AbstractCSTTab;
import com.sas.metadata.tools.cst.visuals.CSTDataProviderInterface;
import com.sas.metadata.tools.cst.visuals.RB;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class UserInputTab
extends AbstractCSTTab {
    private JComboBox _cmbCSC;
    private JLabel _lblCSC;
    private WAPanel _pnlAttributes;
    private WAPanel _pnlFiltering;
    private WAPanel _pnlExternalTable;
    private WAPanel _pnlGrouping;
    private JLabel _lblExternalTable;
    private JLabel _lblGrouping;
    private JLabel _lblFiltering;
    private JLabel _lblAttributes;
    private JTextField _txtCSC;
    private JCheckBox _chkSelectAll;
    private JCheckBox _chkExternalTable;
    private DualListSelector _dualListLibraries;
    private AttributeCheckBox[] _chkAttribs;
    private boolean isSelected = false;
    private static final int _totalSteps = 4;
    private static final int _currStep = 1;
    private int common;
    private String message;
    private boolean userinputProcessed;

    public UserInputTab(CSTDataProviderInterface dataProvider) {
        super(dataProvider);
        this.setHelpTopic("col_std_user_inputs");
        this._logger.debug("User Input Tab initialized successfully.");
    }

    @Override
    protected String getTabHeader() {
        return RB.getStringResource("UserInputTab.header.txt");
    }

    @Override
    protected String getTabStatus() {
        return Message.format((String)RB.getStringResource("UserInputTab.status.fmt"), (Object)1, (Object)4);
    }

    @Override
    protected void initContentPanel() {
        this._logger.debug("User Input Tab's initContentPanel() started.");
        WAPanel contentsPanel = this.getContentsPanel();
        this._pnlAttributes = new WAPanel();
        this._pnlFiltering = new WAPanel();
        this._pnlExternalTable = new WAPanel();
        this._pnlGrouping = new WAPanel();
        this._lblExternalTable = new JLabel("<html><b>" + RB.getStringResource("UserInputTab.tableselection.criteria.txt") + "</b></html>");
        this._lblGrouping = new JLabel("<html><b>" + RB.getStringResource("UserInputTab.grouping.criteria.txt") + "</b></html>");
        this._lblFiltering = new JLabel("<html><b>" + RB.getStringResource("UserInputTab.select.libraries.txt") + "</b></html>");
        this._lblAttributes = new JLabel("<html><b>" + RB.getStringResource("UserInputTab.select.column.attribs.txt") + "</b></html>");
        this._lblCSC = new JLabel();
        this._cmbCSC = new JComboBox();
        this._txtCSC = new JTextField();
        this._chkExternalTable = new JCheckBox(Util.getLabelWithoutMnemonic((String)RB.getStringResource("UserInputTab.Include.externaltable.txt")));
        this._chkSelectAll = new JCheckBox(Util.getLabelWithoutMnemonic((String)RB.getStringResource("UserInputTab.select.all.txt")));
        ControllerFactory.StandardAttributes stdAttribs = this._dataProvider.getStandardizableAttributes();
        List<Attribute> attribs = null;
        if (stdAttribs != null && (attribs = stdAttribs.getAttributes()) != null && !attribs.isEmpty()) {
            this._chkAttribs = new AttributeCheckBox[attribs.size()];
            for (int i = 0; i < attribs.size(); ++i) {
                Attribute att = attribs.get(i);
                this._chkAttribs[i] = new AttributeCheckBox(att);
                int mnemonic = att.getMnemonic();
                this._chkAttribs[i].setMnemonic(mnemonic);
                this._chkAttribs[i].setDisplayedMnemonicIndex(att.getMnemonicIndex());
            }
        }
        contentsPanel.setLayout((LayoutManager)new GridBagLayout());
        contentsPanel.setMinimumSize(new Dimension(580, 360));
        contentsPanel.setPreferredSize(new Dimension(580, 360));
        this._pnlFiltering.setLayout((LayoutManager)new BorderLayout());
        this._pnlFiltering.setBorder((Border)BorderFactory.createTitledBorder(""));
        this._lblFiltering.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this._pnlFiltering.add((Component)this._lblFiltering, (Object)"North");
        this._dualListLibraries = new DualListSelector();
        DefaultListModel<String> dlmSrc = new DefaultListModel<String>();
        DefaultListModel dlmTgt = new DefaultListModel();
        try {
            List<String> libraryNames = this._dataProvider.getAvailableLibraries();
            if (libraryNames != null) {
                Collections.sort(libraryNames);
                for (int i = 0; i < libraryNames.size(); ++i) {
                    dlmSrc.addElement(libraryNames.get(i));
                }
            }
        }
        catch (CSTException e) {
            this._logger.error(RB.getStringResource("UserInputTab.Exception.GetLibraries.txt"), (Throwable)e);
            e.printStackTrace();
        }
        this._dualListLibraries.setModel(dlmSrc);
        this._dualListLibraries.setTargetModel(dlmTgt);
        this._pnlFiltering.add((Component)this._dualListLibraries, (Object)"Center");
        GridBagConstraints mainConstraints = new GridBagConstraints();
        mainConstraints.fill = 1;
        mainConstraints.gridx = 0;
        mainConstraints.gridy = 0;
        mainConstraints.weightx = 1.0;
        mainConstraints.weighty = 1.0;
        contentsPanel.add((Component)this._pnlFiltering, (Object)mainConstraints);
        this._pnlExternalTable.setLayout((LayoutManager)new GridBagLayout());
        this._pnlExternalTable.setBorder((Border)BorderFactory.createTitledBorder(""));
        GridBagConstraints e = new GridBagConstraints();
        e.fill = 1;
        e.gridx = 0;
        e.gridy = 0;
        e.gridwidth = 1;
        e.gridheight = 1;
        e.weightx = 1.0;
        e.weighty = 0.0;
        e.ipady = 6;
        this._pnlExternalTable.add((Component)this._lblExternalTable, (Object)e);
        int mnemonice = Util.getDisplayedMnemonic((String)RB.getStringResource("UserInputTab.Include.externaltable.txt"));
        this._chkExternalTable.setMnemonic(mnemonice);
        this._chkExternalTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean SelectionState = UserInputTab.this._chkExternalTable.isSelected();
                UserInputTab.this.isSelected = SelectionState;
            }
        });
        e.gridx = 1;
        this._pnlExternalTable.add((Component)this._chkExternalTable, (Object)e);
        mainConstraints.weighty = 0.0;
        mainConstraints.gridy = 1;
        contentsPanel.add((Component)this._pnlExternalTable, (Object)mainConstraints);
        this._pnlGrouping.setLayout((LayoutManager)new GridBagLayout());
        this._pnlGrouping.setBorder((Border)BorderFactory.createTitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.ipady = 6;
        this._pnlGrouping.add((Component)this._lblGrouping, (Object)c);
        c.ipady = 0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this._lblCSC.setText(Util.getLabelWithoutMnemonic((String)RB.getStringResource("UserInputTab.column.search.criteria.txt")));
        int mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("UserInputTab.column.search.criteria.txt"));
        this._lblCSC.setDisplayedMnemonic(mnemonic);
        this._lblCSC.setLabelFor(this._cmbCSC);
        this._pnlGrouping.add((Component)this._lblCSC, (Object)c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        this._cmbCSC.setModel(new DefaultComboBoxModel<String>(new String[]{UserInput.FILTER_GROUPBYNAME, UserInput.FILTER_EQUALSTO, UserInput.FILTER_STARTSWITH, UserInput.FILTER_ENDSWITH, UserInput.FILTER_CONTAINS}));
        this._cmbCSC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UserInput.FILTER_GROUPBYNAME.equals(UserInputTab.this._cmbCSC.getSelectedItem())) {
                    UserInputTab.this._txtCSC.setText("");
                    UserInputTab.this._txtCSC.setEnabled(false);
                } else {
                    UserInputTab.this._txtCSC.setEnabled(true);
                }
            }
        });
        this._pnlGrouping.add((Component)this._cmbCSC, (Object)c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        this._txtCSC.setHorizontalAlignment(2);
        this._txtCSC.setEnabled(false);
        this._pnlGrouping.add((Component)this._txtCSC, (Object)c);
        mainConstraints.weighty = 0.0;
        mainConstraints.gridy = 2;
        contentsPanel.add((Component)this._pnlGrouping, (Object)mainConstraints);
        this._pnlAttributes.setLayout((LayoutManager)new GridBagLayout());
        this._pnlAttributes.setBorder((Border)BorderFactory.createTitledBorder(""));
        c = new GridBagConstraints();
        c.fill = 1;
        c.ipady = 6;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this._pnlAttributes.add((Component)this._lblAttributes, (Object)c);
        c.ipady = 0;
        mnemonic = Util.getDisplayedMnemonic((String)RB.getStringResource("UserInputTab.select.all.txt"));
        this._chkSelectAll.setMnemonic(mnemonic);
        this._chkSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = UserInputTab.this._chkSelectAll.isSelected();
                if (UserInputTab.this._chkAttribs != null) {
                    for (int i = 0; i < UserInputTab.this._chkAttribs.length; ++i) {
                        UserInputTab.this._chkAttribs[i].setSelected(isSelected);
                    }
                    UserInputTab.this.common = isSelected ? 49 : 0;
                }
            }
        });
        boolean flag = false;
        for (int i = 0; i < this._chkAttribs.length; ++i) {
            this._chkAttribs[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeCheckBox temp;
                    if (UserInputTab.this._chkSelectAll.isSelected()) {
                        UserInputTab.this._chkSelectAll.setSelected(false);
                    }
                    if ((temp = (AttributeCheckBox)e.getSource()).isSelected()) {
                        UserInputTab.this.common += temp.getText().length();
                    } else {
                        UserInputTab.this.common -= temp.getText().length();
                    }
                    if (UserInputTab.this.common == 49) {
                        UserInputTab.this._chkSelectAll.setSelected(true);
                    }
                }
            });
        }
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.25;
        c.weighty = 0.0;
        c.anchor = 13;
        this._pnlAttributes.add((Component)this._chkSelectAll, (Object)c);
        if (this._chkAttribs != null) {
            int cnt = 0;
            int yGrid = 1;
            while (cnt < attribs.size()) {
                int xGrid = 1;
                while (xGrid < 4 && cnt < attribs.size()) {
                    this._chkAttribs[cnt].setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                    c.gridx = xGrid++;
                    c.gridy = yGrid;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    c.weighty = 0.0;
                    c.weightx = 0.25;
                    this._pnlAttributes.add((Component)this._chkAttribs[cnt], (Object)c);
                    ++cnt;
                }
                ++yGrid;
                c.insets = new Insets(0, 10, 10, 10);
            }
        }
        mainConstraints.gridy = 3;
        contentsPanel.add((Component)this._pnlAttributes, (Object)mainConstraints);
        this._logger.debug("User Input Tab's initContentPanel() completed.");
    }

    public boolean validateData() {
        this._logger.debug("validating data before starting standardization operation.");
        boolean isValid = false;
        ListModel libModel = this._dualListLibraries.getTargetModel();
        UserInput.m_libCount = libModel.getSize();
        if (!this.isSelected && libModel.getSize() == 0) {
            JOptionPane.showMessageDialog(null, RB.getStringResource("UserInputTab.select.minimum.libs.txt"));
            this._dualListLibraries.requestFocus();
            this._logger.warn(RB.getStringResource("UserInputTab.select.minimum.libs.txt"));
            return false;
        }
        if (this._cmbCSC.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(null, RB.getStringResource("UserInputTab.select.column.search.criteria.txt"));
            this._cmbCSC.requestFocus();
            this._logger.warn(RB.getStringResource("UserInputTab.select.column.search.criteria.txt"));
            return false;
        }
        String text = this._txtCSC.getText();
        if (!(text != null && text.trim().length() != 0 || UserInput.FILTER_GROUPBYNAME.equals(this._cmbCSC.getSelectedItem()))) {
            JOptionPane.showMessageDialog(null, RB.getStringResource("UserInputTab.enter.column.search.criteria.txt"));
            this._txtCSC.requestFocus();
            this._logger.warn(RB.getStringResource("UserInputTab.enter.column.search.criteria.txt"));
            return false;
        }
        for (int i = 0; i < this._chkAttribs.length; ++i) {
            if (!this._chkAttribs[i].isSelected()) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            JOptionPane.showMessageDialog(null, RB.getStringResource("UserInputTab.select.minimum.attribs.txt"));
            this._chkAttribs[0].requestFocus();
            this._logger.warn(RB.getStringResource("UserInputTab.enter.column.search.criteria.txt"));
            return false;
        }
        if (isValid) {
            try {
                UserInput userInput = this.getUIData();
                Validations validations = this._dataProvider.validateUserInput(userInput);
                isValid = false;
                if (validations != null) {
                    List<Validations.ErrorWarning> errorWarnings;
                    boolean bl = isValid = !validations.errorsPresent();
                    if (!isValid) {
                        errorWarnings = validations.getAllErrorMessages();
                        String message = this._dataProvider.getCombinedMessage(errorWarnings);
                        JOptionPane.showMessageDialog((Component)((Object)this), message, RB.getStringResource("UserInputTab.error.txt"), 0);
                        this._logger.warn(RB.getStringResource("UserInputTab.error.txt"));
                    } else {
                        errorWarnings = validations.getAllWarningMessages();
                        if (errorWarnings != null && !errorWarnings.isEmpty()) {
                            String message = this._dataProvider.getCombinedMessage(errorWarnings);
                            message = message + RB.getStringResource("UserInputTab.confirm.continue.txt");
                            int retval = JOptionPane.showConfirmDialog((Component)((Object)this), message, RB.getStringResource("UserInputTab.warning.txt"), 0);
                            this._logger.warn(message);
                            if (retval != 0) {
                                return false;
                            }
                            this._logger.info(RB.getStringResource("UserInputTab.user.ignored.txt"));
                        }
                    }
                }
                if (isValid) {
                    OpRequestUI opRequestUI = new OpRequestUI((Component)((Object)this), RB.getStringResource("Visuals.processing.request.message.txt"), RB.getStringResource("Visuals.progressbar.titel.txt"));
                    opRequestUI.setDelayBeforeProgressCancelDialog(500);
                    opRequestUI.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                UserInputTab.this._dataProvider.processUserInput(UserInputTab.this.getUIData());
                                UserInputTab.this.userinputProcessed = true;
                            }
                            catch (Exception e) {
                                UserInputTab.this.userinputProcessed = false;
                                UserInputTab.this.message = e.getLocalizedMessage();
                                UserInputTab.this._logger.info(RB.getStringResource("UserInputTab.failure.txt") + ":" + UserInputTab.this.message);
                            }
                        }
                    });
                    if (!this.userinputProcessed) {
                        JOptionPane.showMessageDialog((Component)((Object)this), this.message, RB.getStringResource("UserInputTab.warning.txt"), 2);
                        return false;
                    }
                    this._logger.info(Message.format((String)RB.getStringResource("UserinputTab.columns.search.criteria.fmt"), (Object)userInput.getFilterKeyword()));
                    this._logger.info(Message.format((String)RB.getStringResource("UserinputTab.filter.value.selected.fmt"), (Object)userInput.getFilterValue()));
                    this._logger.info(Message.format((String)RB.getStringResource("UserinputTab.includeexternaltable.value.selected.fmt"), (Object)userInput.getIncludeExternalTableFlag()));
                    this._logger.info(Message.format((String)RB.getStringResource("UserinputTab.attributes.selected.fmt"), (Object)userInput.getAttributes().toString()));
                    return true;
                }
            }
            catch (Exception e) {
                if (!(e instanceof IllegalArgumentException)) {
                    e.printStackTrace();
                    this._logger.error(RB.getStringResource("UserInputTab.failure.txt"), (Throwable)e);
                }
                JOptionPane.showMessageDialog((Component)((Object)this), e.getLocalizedMessage(), RB.getStringResource("UserInputTab.failure.txt"), 2);
            }
        }
        return false;
    }

    public void onNext() {
        super.onNext();
        this._logger.info(RB.getStringResource("UserInputTab.message.on.next.txt"));
    }

    public UserInput getUIData() {
        ListModel libsModelTrgt;
        this._logger.debug("User Input Tab getUIData() started.");
        UserInput userInput = new UserInput();
        ListModel libsModelSrc = this._dualListLibraries.getModel();
        if (libsModelSrc != null && libsModelSrc.getSize() > 0 && (libsModelTrgt = this._dualListLibraries.getTargetModel()) != null && libsModelTrgt.getSize() > 0) {
            ArrayList<String> selectedLibraries = new ArrayList<String>();
            for (int i = 0; i < libsModelTrgt.getSize(); ++i) {
                String libPath = (String)libsModelTrgt.getElementAt(i);
                int index = libPath.lastIndexOf("/");
                if (index == -1) {
                    selectedLibraries.add(libPath);
                    continue;
                }
                selectedLibraries.add(libPath.substring(index + 1));
            }
            userInput.setSelectedLibraries(selectedLibraries);
        }
        ArrayList<Attribute> attribs = new ArrayList<Attribute>();
        for (int i = 0; i < this._chkAttribs.length; ++i) {
            if (!this._chkAttribs[i].isSelected()) continue;
            attribs.add(this._chkAttribs[i].getAttribute());
        }
        if (!attribs.isEmpty()) {
            userInput.setAttributes(attribs);
        }
        userInput.setFilterKeyword((String)this._cmbCSC.getSelectedItem());
        userInput.setIncludeExternalTableFlag(this.isSelected);
        userInput.setFilterValue(this._txtCSC.getText());
        this._logger.debug("User Input Tab getUIData() completed.");
        return userInput;
    }

    private class ListDataListenerImpl
    implements ListDataListener {
        private ListDataListenerImpl() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            Object src = e.getSource();
            if (src instanceof DefaultListModel) {
                DefaultListModel model = (DefaultListModel)src;
                int modelSize = model.size();
                Object[] names = new String[modelSize];
                model.copyInto(names);
                Arrays.sort(names);
                model.removeAllElements();
                for (Object name : names) {
                    model.addElement(name);
                }
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private class AttributeCheckBox
    extends JCheckBox {
        private Attribute _attrib;

        public AttributeCheckBox(Attribute attrib) {
            this._attrib = attrib;
            this.setText(attrib.getLabelWithMnemonic());
        }

        public Attribute getAttribute() {
            return this._attrib;
        }
    }
}

