/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.tools.cst.visuals.AbstractSummaryTab;
import com.sas.metadata.tools.cst.visuals.CSTDataProviderInterface;
import com.sas.metadata.tools.cst.visuals.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;

public class IntermediateSummaryTab
extends AbstractSummaryTab {
    private static final int _totalSteps = 4;
    private static final int _currStep = 3;

    public IntermediateSummaryTab(CSTDataProviderInterface dataProvider) {
        super(dataProvider);
        this.setHelpTopic("col_std_summary");
        this._logger.debug("Intermediate Summary Tab initialized successfully.");
    }

    @Override
    protected String getTabHeader() {
        return RB.getStringResource("IntermediateSummaryTab.header.txt");
    }

    @Override
    protected String getTabStatus() {
        return Message.format((String)RB.getStringResource("IntermediateSummaryTab.status.fmt"), (Object)3, (Object)4);
    }

    public boolean validateData() {
        boolean isValid = super.validateData();
        if (isValid) {
            int val = JOptionPane.showConfirmDialog(null, RB.getStringResource("IntermediateSummaryTab.confirm.metadata.change.txt"), RB.getStringResource("IntermediateSummaryTab.confirmation.txt"), 0);
            isValid = val == 0;
        }
        this._logger.debug("intermediate Summary Tab's validateData() method completed successfully after click on Next button,passing control to Final Summary Tab.");
        this._logger.info(RB.getStringResource("IntermediateSummaryTab.onnext.txt"));
        return isValid;
    }

    public void onNext() {
        this._dataProvider.update();
        this._logger.info(RB.getStringResource("IntermediateSummaryTab.metadata.update.done.txt"));
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        boolean retVal = super.doDataExchange(saveToModel);
        if (retVal) {
            try {
                if (!saveToModel) {
                    this.setSummary(this._dataProvider.getIntermediateSummaryInfo());
                }
            }
            catch (Exception e) {
                retVal = false;
            }
        }
        return retVal;
    }
}

