/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.visuals;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTException;
import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.LoggerWrapper;
import com.sas.metadata.tools.cst.StandardizationControllerInterface;
import com.sas.metadata.tools.cst.StandardizationReport;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.metadata.tools.cst.Validations;
import com.sas.metadata.tools.cst.visuals.CSTDataProviderInterface;
import com.sas.metadata.tools.cst.visuals.ComparisonTab;
import com.sas.metadata.tools.cst.visuals.FinalReportTab;
import com.sas.metadata.tools.cst.visuals.IntermediateSummaryTab;
import com.sas.metadata.tools.cst.visuals.RB;
import com.sas.metadata.tools.cst.visuals.UserInputTab;
import com.sas.text.Message;
import com.sas.workspace.WASimpleWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import org.apache.logging.log4j.Logger;

public class CSTWizard
extends WAWizardDialog
implements CSTDataProviderInterface {
    private static final String USER_INPUT_TAB = "UserInputTab";
    private static final String COMPARISON_TAB = "ComparisonTab";
    private static final String SUMMARY_TAB = "SummaryTab";
    private static final String FINISHINFO_TAB = "FinishInfoTab";
    private static final WAdminResource wAdminResource = new WAdminResource(CSTWizard.class, "Resources");
    private UserInput _userInput = null;
    private List<GroupInstancesInterface> _lstAllGroupInstances = null;
    private StandardizationControllerInterface _standardizationController = null;
    private CSTException _updateException = null;
    private ControllerFactory.StandardAttributes _standardAttributes = null;
    private ControllerFactory _controllerFactory = null;
    private Logger _logger = LoggerWrapper.getLoggerInstance();

    public CSTWizard() throws CSTException {
        super((Frame)Workspace.getWorkspace(), true);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(600, 400));
        this.init();
    }

    private void init() throws CSTException {
        this._logger.debug("Column Standardization Tool Wizard started to initialize.");
        this._controllerFactory = ControllerFactory.getFactoryForUIClients();
        CSTWizardModel model = new CSTWizardModel();
        this.setWizardModel((WAWizardModel)model);
        this.addTab(RB.getStringResource("CSTWizard.title.userinputtab.txt"), USER_INPUT_TAB, new UserInputTab(this));
        this.addTab(RB.getStringResource("CSTWizard.title.comparisontab.txt"), COMPARISON_TAB, new ComparisonTab(this));
        this.addTab(RB.getStringResource("CSTWizard.title.summarytab.txt"), SUMMARY_TAB, new IntermediateSummaryTab(this));
        this.addTab(RB.getStringResource("CSTWizard.title.finishinfo.txt"), FINISHINFO_TAB, new FinalReportTab(this), true);
        this._logger.info(RB.getStringResource("CSTWizard.start.CST.wizard.txt"));
        this._logger.debug("Column Standardization Tool Wizard initialized successfully ");
    }

    @Override
    public StandardizationControllerInterface getStandardizationController() {
        return this._standardizationController;
    }

    private String[][] getTransitions() {
        return new String[][]{{USER_INPUT_TAB, "NEXT", COMPARISON_TAB}, {COMPARISON_TAB, "NEXT", SUMMARY_TAB}, {SUMMARY_TAB, "NEXT", FINISHINFO_TAB}};
    }

    @Override
    public UserInput getUserInput() {
        return this._userInput;
    }

    @Override
    public boolean processUserInput(UserInput userInput) throws CSTException {
        this._logger.debug("Column Standardization Tool Wizard's processUserInput() method started.");
        if (!userInput.equals(this._userInput)) {
            Locale locale = Workspace.getWorkspace().getLocale();
            this._standardizationController = this._controllerFactory.getController(userInput, locale);
            this._lstAllGroupInstances = this._standardizationController.getAllGroupInstances();
            this._userInput = userInput;
        }
        this._logger.debug("Column Standardization Tool Wizard's processUserInput() method completed.");
        return true;
    }

    @Override
    public List<GroupInstancesInterface> getAllGroupInstances() {
        return this._lstAllGroupInstances;
    }

    @Override
    public List<GroupInstancesInterface> getSortedGroupInstances(StandardizationControllerInterface.GroupSortCriteria criteria) {
        if (criteria != null) {
            this._lstAllGroupInstances = this._standardizationController.getSortedGroupInstances(criteria);
        }
        return this._lstAllGroupInstances;
    }

    @Override
    public ControllerFactory.StandardAttributes getStandardizableAttributes() {
        this._standardAttributes = ControllerFactory.getAttributesToStandardize();
        return this._standardAttributes;
    }

    @Override
    public List<String> getPossibleValuesFor(Attribute att) {
        if (this._standardAttributes != null) {
            return this._standardAttributes.getPossibleValues(att);
        }
        return null;
    }

    @Override
    public boolean update() {
        try {
            this._standardizationController.update();
            return true;
        }
        catch (CSTException e) {
            this._logger.error(RB.getStringResource("CSTWizard.Exception.update.metadata.txt"), (Throwable)e);
            e.printStackTrace();
            this._updateException = e;
            return false;
        }
    }

    @Override
    public Logger getLogger() {
        return this._logger;
    }

    @Override
    public String getIntermediateSummaryInfo() {
        int allCols = this._standardizationController.getStandardizationSummary().count();
        int stdCols = this._standardizationController.getStandardizationSummary().includedCount();
        int updateCnt = this._standardizationController.getStandardizationSummary().updateCount();
        int groupCnt = this._standardizationController.getStandardizationSummary().getGroupCount();
        int groupStandardizedCnt = this._standardizationController.getStandardizationSummary().getStandardizedGroupCount();
        StandardizationReport report = new StandardizationReport(this._standardizationController);
        String fileName = report.generateReport();
        Object[] objects = new Object[]{groupCnt, allCols, groupStandardizedCnt, stdCols, updateCnt, fileName};
        String message = Message.format((String)RB.getStringResource("CSTWizard.summary.info.fmt"), (Object[])objects);
        this._logger.info(RB.getStringResource("CSTWizard.intermediate.summary.displayed.txt"));
        this._logger.info(Message.format((String)RB.getStringResource("CSTWizard.intermediate.summary.for.log.fmt"), (Object)stdCols, (Object)allCols));
        return message;
    }

    @Override
    public String getFinalReportInfo() {
        if (this._updateException != null) {
            return Message.format((String)RB.getStringResource("CSTWizard.exception.occured.fmt"), (Object)this._updateException.getLocalizedMessage());
        }
        int allCols = this._standardizationController.getStandardizationSummary().count();
        int stdCols = this._standardizationController.getStandardizationSummary().includedCount();
        int updateCnt = this._standardizationController.getStandardizationSummary().updateCount();
        int groupCnt = this._standardizationController.getStandardizationSummary().getGroupCount();
        int groupStandardizedCnt = this._standardizationController.getStandardizationSummary().getStandardizedGroupCount();
        StandardizationReport report = new StandardizationReport(this._standardizationController);
        String UpdatefileName = "";
        UpdatefileName = this._userInput.getFilterKeyword().equalsIgnoreCase(UserInput.FILTER_GROUPBYNAME) ? report.generateGroupByUpdateReport() : report.generateUpdateReport();
        Object[] objects = new Object[]{groupCnt, allCols, groupStandardizedCnt, stdCols, updateCnt, UpdatefileName};
        String message = Message.format((String)RB.getStringResource("CSTWizard.final.report.fmt"), (Object[])objects);
        this._logger.info(RB.getStringResource("CSTWizard.final.summary.displayed.txt"));
        this._logger.info(Message.format((String)RB.getStringResource("CSTWizard.final.summary.for.log.fmt"), (Object)stdCols, (Object)allCols));
        return message;
    }

    @Override
    public String getCombinedMessage(List<Validations.ErrorWarning> errorWarnings) {
        StringBuffer sbMessage = new StringBuffer("");
        int i = 0;
        if (errorWarnings != null) {
            if (errorWarnings.size() > 1) {
                sbMessage.append(RB.getStringResource("CSTWizard.following.issues.found.txt"));
                for (Validations.ErrorWarning ew : errorWarnings) {
                    sbMessage.append(++i + ". " + ew.message().trim());
                    sbMessage.append("\n");
                }
            } else {
                sbMessage.append(errorWarnings.get(0).message());
                sbMessage.append("\n");
            }
        }
        return sbMessage.toString();
    }

    @Override
    public Validations validateUserInput(UserInput userInput) {
        return this._controllerFactory.validateUserInput(userInput);
    }

    @Override
    public List<String> getAvailableLibraries() throws CSTException {
        return this._controllerFactory.getLibrariesPath();
    }

    @Override
    public Icon getIcon(String iconID) {
        return wAdminResource.getImageIcon(iconID);
    }

    private class CSTWizardModel
    extends WASimpleWizardModel {
        public boolean hasPrev() {
            return super.hasPrev() ? super.hasNext() : super.hasPrev();
        }
    }
}

