/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.tools;

import com.sas.metadata.tools.cst.tools.RB;
import com.sas.metadata.tools.cst.tools.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XMLNode {
    List<XMLNode> children;
    List<XMLNode> headers;
    String name;
    Map<String, String> attribs = new LinkedHashMap<String, String>();
    public static String charEncoding;
    boolean hasHeader;

    public void appendChild(XMLNode child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.children.add(child);
    }

    public void addHeader(XMLNode node) throws IllegalStateException {
        if (node.hasChildren()) {
            throw new IllegalStateException(RB.getStringResource("XMLNode.node.has.children.txt"));
        }
        this.headers.add(node);
        this.hasHeader = true;
    }

    public boolean hasChildren() {
        return !Utils.isEmpty(this.children);
    }

    public static XMLNode getXMLNode(String name) {
        return new XMLNode(name);
    }

    public static XMLNode getRootNode(String name, String desiredcharEncoding) {
        charEncoding = desiredcharEncoding;
        return new XMLNode(name, true);
    }

    private XMLNode(String name) {
        this.children = new ArrayList<XMLNode>();
        this.name = name;
    }

    private XMLNode(String name, boolean addHeaders) {
        this.children = new ArrayList<XMLNode>();
        if (addHeaders) {
            this.headers = new ArrayList<XMLNode>();
        }
        this.name = name;
    }

    public void addChild(XMLNode child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.children.add(child);
    }

    public boolean addAttribute(String name, String value) {
        boolean added = false;
        if (name != null) {
            this.attribs.put(name, value);
            added = true;
        }
        return added;
    }

    public boolean hasHeaders() {
        return this.hasHeader;
    }

    public boolean loadAttributes(Map<String, String> attribs) {
        this.attribs = attribs;
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasHeader) {
            for (XMLNode header : this.headers) {
                stringBuilder.append(Utils.nodeString(header, true));
            }
        }
        stringBuilder.append(Utils.nodeString(this, false));
        for (XMLNode node : this.children) {
            stringBuilder.append(node.toString());
        }
        stringBuilder.append(Utils.crateXMLEndString(this.name));
        return stringBuilder.toString();
    }

    String getName() {
        return this.name;
    }

    Map<String, String> getAttributes() {
        return this.attribs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(File outFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            String XMLContent = this.toString();
            byte[] utfstr = XMLContent.getBytes(charEncoding);
            fos.write(utfstr);
            fos.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void flush(OutputStream stream) {
    }
}

