/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.tools;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.metadata.tools.cst.tools.XMLNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class Utils {
    public static boolean standardEquals(ColumnInstance instance, List<Attribute> attributes) {
        boolean equals = true;
        if (instance != null && attributes != null) {
            List<Attribute> attribute = instance.getOriginalAttributes();
            Attribute columnAttrib = null;
            int foundIndex = -1;
            for (Attribute att : attributes) {
                foundIndex = attribute.indexOf(att);
                if (foundIndex == -1 || (columnAttrib = attribute.get(foundIndex)).equalsWithValue(att)) continue;
                equals = false;
                break;
            }
        }
        return equals;
    }

    public static String nodeString(XMLNode node, boolean headerNode) {
        StringBuilder builder = new StringBuilder();
        if (headerNode) {
            builder.append(XmlNotations.HEADERSTART.value());
        } else {
            builder.append(XmlNotations.STARTTAG.value());
        }
        builder.append(node.getName());
        builder.append(XmlNotations.SPACE.value());
        Map<String, String> attribs = node.getAttributes();
        if (attribs != null) {
            Set<Map.Entry<String, String>> set = attribs.entrySet();
            for (Map.Entry<String, String> entry : set) {
                builder.append(entry.getKey());
                builder.append(XmlNotations.EQUALS.value());
                builder.append(XmlNotations.QUOTE.value());
                builder.append(entry.getValue());
                builder.append(XmlNotations.QUOTE.value());
                builder.append(XmlNotations.SPACE.value());
            }
        }
        if (headerNode) {
            builder.append(XmlNotations.HEADEREND.value());
        } else {
            builder.append(XmlNotations.CLOSETAG.value());
        }
        return builder.toString();
    }

    public static String crateXMLEndString(String nodeName) {
        return XmlNotations.ENDTAG.value() + nodeName + XmlNotations.CLOSETAG.value();
    }

    public static String search(List<Attribute> attribs, String attribName) {
        Attribute found = Utils.searchAttribute(attribs, attribName);
        return found != null ? found.getAttributeValue() : null;
    }

    public static Attribute searchAttribute(List<Attribute> attribs, String attribName) {
        Attribute found = null;
        if (attribName != null) {
            found = Utils.searchAttribute(attribs, new Attribute(attribName));
        }
        return found;
    }

    public static Attribute searchAttribute(List<Attribute> attribs, Attribute search) {
        int foundIndex;
        Attribute found = null;
        if (attribs != null && search != null && (foundIndex = attribs.indexOf(search)) != -1) {
            found = attribs.get(foundIndex);
        }
        return found;
    }

    public static XMLNode convertUserInputToNode(UserInput userInput) {
        return null;
    }

    public static UserInput convertNodeToUserInput(Node xmlNode) {
        return null;
    }

    public static ColumnInstance convertNodeToColumnInstance(Node xmlNode) {
        return null;
    }

    public static XMLNode convertColumnInstanceToNode(ColumnInstance instance) {
        XMLNode column = null;
        if (instance != null) {
            column = XMLNode.getXMLNode("column");
            List<Attribute> attribs = instance.getAttributes();
            for (Attribute attrib : attribs) {
                column.addAttribute(attrib.getAttributeName(), attrib.getAttributeValue());
            }
        }
        return column;
    }

    public static boolean isEmpty(Object object) {
        boolean isEmpty = false;
        if (object == null) {
            isEmpty = true;
        } else if (object instanceof String && ((String)object).length() <= 0) {
            isEmpty = true;
        } else if (object instanceof Collection && ((Collection)object).size() <= 0) {
            isEmpty = true;
        } else if (object instanceof Map && ((Map)object).size() <= 0) {
            isEmpty = true;
        } else if (object.getClass().isArray() && ((Object[])object).length <= 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    static enum XmlNotations {
        SPACE(" "),
        STARTTAG("<"),
        CLOSETAG(">"),
        ENDTAG("</"),
        QUOTE("\""),
        EQUALS("="),
        HEADERSTART("<?"),
        HEADEREND("?>");

        private final String value;

        private XmlNotations(String val) {
            this.value = val;
        }

        public String value() {
            return this.value;
        }
    }
}

