/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst.tests;

import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.GroupInstances;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.GroupOperationsInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class GroupInstanceTest
extends TestCase {
    GroupInstancesInterface groupInstances = null;

    public void setUp() {
        HashMap<String, String> column1 = new HashMap<String, String>();
        column1.put("name", "column1");
        column1.put("format", "BEST5");
        column1.put("informat", "BEST5");
        HashMap<String, String> column2 = new HashMap<String, String>();
        column2.put("name", "column2");
        column2.put("format", "BEST5");
        column2.put("informat", "BEST5");
        HashMap column3 = new HashMap();
        column2.put("name", "column3");
        column2.put("format", "BEST5");
        column2.put("informat", "BEST5");
        ArrayList<Map<String, String>> columns = new ArrayList<Map<String, String>>();
        columns.add(column1);
        columns.add(column2);
        columns.add(column3);
        this.groupInstances = new GroupInstances("Allcolumns", columns);
    }

    public void testGroupIdentifier() {
        GroupInstanceTest.assertEquals((String)this.groupInstances.getGroupIdentifier(), (String)"Allcolumns");
    }

    public void testExcludedColumns() {
        GroupOperationsInterface groupOperations = this.groupInstances.getGroupOperator();
        HashMap<String, String> column1 = new HashMap<String, String>();
        column1.put("name", "column1");
        column1.put("format", "BEST5");
        column1.put("informat", "BEST5");
        ColumnInstance columnInstance = ColumnInstance.createColumnInstance(column1);
        groupOperations.setExcluded(columnInstance, true);
        GroupInstanceTest.assertEquals((int)this.groupInstances.excludedCount(), (int)1);
        GroupInstanceTest.assertEquals((int)this.groupInstances.getExcluded().size(), (int)1);
        GroupInstanceTest.assertEquals((int)this.groupInstances.includedCount(), (int)2);
        GroupInstanceTest.assertEquals((int)this.groupInstances.getIncluded().size(), (int)2);
        groupOperations.setExcluded(columnInstance, false);
        GroupInstanceTest.assertEquals((int)this.groupInstances.excludedCount(), (int)0);
        GroupInstanceTest.assertEquals((int)this.groupInstances.includedCount(), (int)3);
        GroupInstanceTest.assertEquals((int)this.groupInstances.getIncluded().size(), (int)3);
    }

    public void testAll() {
        GroupInstanceTest.assertEquals((int)this.groupInstances.getAll().size(), (int)3);
        GroupInstanceTest.assertEquals((int)this.groupInstances.count(), (int)3);
        GroupOperationsInterface groupOperations = this.groupInstances.getGroupOperator();
        HashMap<String, String> column1 = new HashMap<String, String>();
        column1.put("name", "column1");
        column1.put("format", "BEST5");
        column1.put("informat", "BEST5");
        ColumnInstance columnInstance = ColumnInstance.createColumnInstance(column1);
        groupOperations.setExcluded(columnInstance, true);
        GroupInstanceTest.assertEquals((int)this.groupInstances.getAll().size(), (int)3);
        GroupInstanceTest.assertEquals((int)this.groupInstances.count(), (int)3);
        groupOperations.setExcluded(columnInstance, false);
    }
}

