/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.RB;
import java.util.List;

public class UserInput {
    private List<String> m_lstSelectedLibraries = null;
    private String m_strGroupingCriteria;
    private String m_strFilterKeyword;
    private String m_strFilterValue;
    private List<Attribute> m_attributes;
    public boolean INCLUDEEXTERNALTABLE = false;
    public static String FILTER_GROUPBYNAME = RB.getStringResource("UserInput.filter.group.by.name.txt");
    public static String FILTER_EQUALSTO = RB.getStringResource("UserInput.filter.equals.to.txt");
    public static String FILTER_STARTSWITH = RB.getStringResource("UserInput.filter.starts.with.txt");
    public static String FILTER_ENDSWITH = RB.getStringResource("UserInput.filter.ends.with.txt");
    public static String FILTER_CONTAINS = RB.getStringResource("UserInput.filter.contains.txt");
    public static int m_libCount = 0;

    public boolean isGroupByNameCriteria() {
        return this.m_strFilterKeyword != null && this.m_strFilterKeyword.equalsIgnoreCase(FILTER_GROUPBYNAME);
    }

    public String getFilterKeyword() {
        return this.m_strFilterKeyword;
    }

    public String getFilterValue() {
        return this.m_strFilterValue;
    }

    public String getGroupingCriteria() {
        return this.m_strGroupingCriteria;
    }

    public void setSelectedLibraries(List<String> selectedLibraries) {
        this.m_lstSelectedLibraries = selectedLibraries;
    }

    public List<String> getSelectedLibraries() {
        return this.m_lstSelectedLibraries;
    }

    public int getSelectedLibrariesCount() {
        return m_libCount;
    }

    public boolean getIncludeExternalTableFlag() {
        return this.INCLUDEEXTERNALTABLE;
    }

    public void setIncludeExternalTableFlag(boolean Flag) {
        this.INCLUDEEXTERNALTABLE = Flag;
    }

    public void setGroupingCriteria(String groupingCriteria) {
        this.m_strGroupingCriteria = groupingCriteria;
    }

    public void setFilterKeyword(String filterKeyword) {
        this.m_strFilterKeyword = filterKeyword;
    }

    public void setFilterValue(String filterValue) {
        this.m_strFilterValue = filterValue;
    }

    public List<Attribute> getAttributes() {
        return this.m_attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.m_attributes = attributes;
    }

    public boolean equals(Object obj) {
        try {
            List<String> libsOfObj;
            List<Attribute> attribsOfObj;
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            UserInput userInput = (UserInput)obj;
            if (!this.getFilterKeyword().equals(userInput.getFilterKeyword())) {
                return false;
            }
            if (!this.getFilterValue().equals(userInput.getFilterValue())) {
                return false;
            }
            if (!this.getFilterValue().equals(userInput.getFilterValue())) {
                return false;
            }
            List<Attribute> attribsOfThis = this.getAttributes();
            if (!this.equalAttributes(attribsOfThis, attribsOfObj = userInput.getAttributes())) {
                return false;
            }
            List<String> libsOfThis = this.getSelectedLibraries();
            if (!this.equalLibraries(libsOfThis, libsOfObj = userInput.getSelectedLibraries())) {
                return false;
            }
            return this.getIncludeExternalTableFlag() == userInput.getIncludeExternalTableFlag();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean equalLibraries(List<String> libs1, List<String> libs2) {
        if (libs1 == libs2) {
            return true;
        }
        if (libs1 == null || libs2 == null) {
            return false;
        }
        if (libs1.size() != libs2.size()) {
            return false;
        }
        int iMatchedAttribs = 0;
        block0: for (int i = 0; i < libs1.size(); ++i) {
            String lib1 = libs1.get(i);
            for (int j = 0; j < libs2.size(); ++j) {
                String lib2 = libs2.get(j);
                if (!lib1.equals(lib2)) continue;
                ++iMatchedAttribs;
                continue block0;
            }
        }
        return libs1.size() == iMatchedAttribs;
    }

    private boolean equalAttributes(List<Attribute> attribs1, List<Attribute> attribs2) {
        if (attribs1 == attribs2) {
            return true;
        }
        if (attribs1 == null || attribs2 == null) {
            return false;
        }
        if (attribs1.size() != attribs2.size()) {
            return false;
        }
        int iMatchedAttribs = 0;
        block0: for (int i = 0; i < attribs1.size(); ++i) {
            Attribute oneAttrib = attribs1.get(i);
            for (int j = 0; j < attribs2.size(); ++j) {
                Attribute twoAttribute = attribs2.get(j);
                if (!oneAttrib.equals(twoAttribute)) continue;
                ++iMatchedAttribs;
                continue block0;
            }
        }
        return attribs1.size() == iMatchedAttribs;
    }

    public int hashCode() {
        String suffix = "@#$";
        StringBuffer sb = new StringBuffer(suffix);
        sb.append(this.m_strGroupingCriteria != null ? this.m_strGroupingCriteria : "" + suffix);
        sb.append(this.m_strFilterKeyword != null ? this.m_strFilterKeyword : "" + suffix);
        sb.append(this.m_strFilterValue != null ? this.m_strFilterValue : "" + suffix);
        if (this.m_lstSelectedLibraries != null) {
            sb.append(this.m_lstSelectedLibraries.size() + suffix);
            for (String lib : this.m_lstSelectedLibraries) {
                sb.append(lib != null ? lib : "" + suffix);
            }
        }
        return sb.toString().hashCode();
    }
}

