/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTPreferences;
import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.RB;
import com.sas.metadata.tools.cst.StandardizationControllerInterface;
import com.sas.metadata.tools.cst.tools.XMLNode;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.Logger;

public class StandardizationReport {
    private StandardizationControllerInterface controller;
    private File report;
    private File updatereport;
    private File reportHTML;
    private File updatereportHTML;
    private int flag;
    private Logger _logger;

    public StandardizationReport(StandardizationControllerInterface controller, Logger logger) {
        this(controller);
        this._logger = logger;
    }

    public StandardizationReport(StandardizationControllerInterface controller) {
        this.controller = controller;
    }

    public String generateReport() {
        this.createFileForStandardizationReport();
        XMLNode node = this.createRootNode();
        XMLNode xmlHeader = XMLNode.getXMLNode("xml");
        xmlHeader.addAttribute("version", "1.0");
        xmlHeader.addAttribute("encoding", "UTF-8");
        node.addHeader(xmlHeader);
        node.flush(this.report);
        this.transformFile(this.report, this.reportHTML);
        return this.reportHTML.getPath();
    }

    public void transformFile(File xmlFile, File outputHTMLFile) {
        try {
            StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream("/com/sas/metadata/tools/cst/res/cst_report.xsl"));
            StreamSource xmlSource = new StreamSource(xmlFile);
            StreamResult result = new StreamResult(outputHTMLFile);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(xsltSource);
            transformer.setParameter("title", RB.getStringResource("cstReport.title.txt"));
            transformer.setParameter("subtitle", RB.getStringResource("cstReport.subtitle.txt"));
            transformer.setParameter("groupDetails", RB.getStringResource("cstReport.body.groupDetails.txt"));
            transformer.setParameter("groupDetails_parameter", RB.getStringResource("cstReport.body.groupDetails.parameter.txt"));
            transformer.setParameter("groupDetails_value", RB.getStringResource("cstReport.body.groupDetails.value.txt"));
            transformer.setParameter("groupDetails_groupName", RB.getStringResource("cstReport.body.groupDetails.groupName.txt"));
            transformer.setParameter("groupDetails_searchCriteria", RB.getStringResource("cstReport.body.groupDetails.searchCriteria.txt"));
            transformer.setParameter("groupDetails_totalCount", RB.getStringResource("cstReport.body.groupDetails.totalCount.txt"));
            transformer.setParameter("groupDetails_includedColumnCount", RB.getStringResource("cstReport.body.groupDetails.includedColumnCount.txt"));
            transformer.setParameter("groupDetails_updatedColumnCount", RB.getStringResource("cstReport.body.groupDetails.updatedColumnCount.txt"));
            transformer.setParameter("columnDetails", RB.getStringResource("cstReport.body.columnDetails.txt"));
            transformer.setParameter("columnDetails_colId", RB.getStringResource("cstReport.body.columnDetails.colId.txt"));
            transformer.setParameter("columnDetails_tableName", RB.getStringResource("cstReport.body.columnDetails.tableName.txt"));
            transformer.setParameter("columnDetails_libName", RB.getStringResource("cstReport.body.columnDetails.libName.txt"));
            transformer.setParameter("columnDetails_colType", RB.getStringResource("cstReport.body.columnDetails.colType.txt"));
            transformer.setParameter("columnDetails_colLength", RB.getStringResource("cstReport.body.columnDetails.colLength.txt"));
            transformer.setParameter("columnDetails_sasLibName", RB.getStringResource("cstReport.body.columnDetails.sasLibName.txt"));
            transformer.setParameter("columnDetails_colMetadataId", RB.getStringResource("cstReport.body.columnDetails.colMetadataId.txt"));
            transformer.setParameter("columnDetails_sortOrder", RB.getStringResource("cstReport.body.columnDetails.sortOrder.txt"));
            transformer.setParameter("columnDetails_description", RB.getStringResource("cstReport.body.columnDetails.description.txt"));
            transformer.setParameter("columnDetails_objType", RB.getStringResource("cstReport.body.columnDetails.objType.txt"));
            transformer.setParameter("columnDetails_sasFormat", RB.getStringResource("cstReport.body.columnDetails.sasFormat.txt"));
            transformer.setParameter("columnDetails_isNullable", RB.getStringResource("cstReport.body.columnDetails.isNullable.txt"));
            transformer.setParameter("columnDetails_summaryRole", RB.getStringResource("cstReport.body.columnDetails.summaryRole.txt"));
            transformer.setParameter("columnDetails_sasColumnName", RB.getStringResource("cstReport.body.columnDetails.sasColName.txt"));
            transformer.setParameter("columnDetails_sasInformat", RB.getStringResource("cstReport.body.columnDetails.sasInformat.txt"));
            transformer.setParameter("columnDetails_DatabaseSchemaName", RB.getStringResource("cstReport.body.columnDetails.databaseschemaname.txt"));
            transformer.setParameter("columnDetails_ExternalTableName", RB.getStringResource("cstReport.body.columnDetails.externaltablename.txt"));
            transformer.setParameter("Note", RB.getStringResource("StandardizationReport.note.contents.txt"));
            transformer.transform(xmlSource, result);
        }
        catch (TransformerException e) {
            this._logger.debug((Object)e);
            this._logger.error(e.getLocalizedMessage());
        }
    }

    private void createFileForStandardizationReport() {
        String prefDir;
        CSTPreferences CSTpref;
        if (this.controller != null && (CSTpref = this.controller.getPreferences()) != null && (prefDir = CSTpref.getPreferencesDirectory()) != null) {
            this.flag = 1;
            String filename = prefDir + File.separator + "Non-Standard_Columns_Report.xml";
            String htmlFile = prefDir + File.separator + "Non-Standard_Columns_Report.html";
            this.report = this.createReportFile(filename);
            this.reportHTML = this.createReportFile(htmlFile);
        }
    }

    private void createFileforupdate() {
        String prefDir;
        CSTPreferences CSTpref;
        if (this.controller != null && (CSTpref = this.controller.getPreferences()) != null && (prefDir = CSTpref.getPreferencesDirectory()) != null) {
            this.flag = 2;
            String updtfilename = prefDir + File.separator + "UpdateReport.xml";
            String updthtmlfilename = prefDir + File.separator + "UpdateReport.html";
            this.updatereport = this.createReportFile(updtfilename);
            this.updatereportHTML = this.createReportFile(updthtmlfilename);
        }
    }

    private File createReportFile(String filename) {
        File file = new File(filename);
        try {
            if (file.exists() && !file.delete()) {
                this._logger.error(RB.getStringResource("StandardizationReport.cant.delete.old.rpt.file.txt"));
            }
            if (!file.createNewFile()) {
                this._logger.error(RB.getStringResource("StandardizationReport.rptfile.is.not.created.successfully.txt"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public String generateUpdateReport() {
        this.createFileforupdate();
        XMLNode node = this.createUpdateNode();
        XMLNode xmlHeader = XMLNode.getXMLNode("xml");
        xmlHeader.addAttribute("version", "1.0");
        xmlHeader.addAttribute("encoding", "UTF-8");
        node.addHeader(xmlHeader);
        node.flush(this.updatereport);
        this.transformFile(this.updatereport, this.updatereportHTML);
        return this.updatereportHTML.getPath();
    }

    public String generateGroupByUpdateReport() {
        this.createFileforupdate();
        XMLNode node = this.createGroupByNode();
        XMLNode xmlHeader = XMLNode.getXMLNode("xml");
        xmlHeader.addAttribute("version", "1.0");
        xmlHeader.addAttribute("encoding", "UTF-8");
        node.addHeader(xmlHeader);
        node.flush(this.updatereport);
        this.transformFile(this.updatereport, this.updatereportHTML);
        return this.updatereportHTML.getPath();
    }

    private XMLNode createUpdateNode() {
        GroupInstancesInterface groups = this.controller.getSingleGroupInterface();
        XMLNode root = null;
        if (groups != null) {
            XMLNode group = null;
            root = XMLNode.getRootNode("report", "UTF-8");
            group = this.createGroupNode(groups);
            root.appendChild(group);
        }
        return root;
    }

    private XMLNode createGroupByNode() {
        List<GroupInstancesInterface> groups = this.controller.getUpdateGroupInstances();
        XMLNode root = null;
        if (groups != null) {
            XMLNode group = null;
            root = XMLNode.getRootNode("report", "UTF-8");
            for (GroupInstancesInterface groupInstance : groups) {
                group = this.createGroupNode(groupInstance);
                root.appendChild(group);
            }
        }
        return root;
    }

    private XMLNode createRootNode() {
        List<GroupInstancesInterface> groups = this.controller.getAllGroupInstances();
        XMLNode root = null;
        if (groups != null) {
            XMLNode group = null;
            root = XMLNode.getRootNode("report", "UTF-8");
            for (GroupInstancesInterface groupInstance : groups) {
                group = this.createGroupNode(groupInstance);
                root.appendChild(group);
            }
        }
        return root;
    }

    private XMLNode createGroupNode(GroupInstancesInterface instance) {
        XMLNode node = XMLNode.getXMLNode("group");
        node.addAttribute("name", instance.getGroupIdentifier());
        node.addAttribute("count", String.valueOf(instance.count()));
        node.addAttribute("includedcount", String.valueOf(instance.includedCount()));
        node.addAttribute("updatecount", String.valueOf(instance.updateCount()));
        List<ColumnInstance> columns = instance.getAll();
        for (ColumnInstance column : columns) {
            if (this.flag == 2 && column.excluded()) continue;
            node.appendChild(this.createColumnNode(column));
        }
        return node;
    }

    private XMLNode createColumnNode(ColumnInstance instance) {
        XMLNode columnNode = XMLNode.getXMLNode("column");
        if (this.flag == 2) {
            String updateStatus = null;
            updateStatus = instance.isValueChanged() ? RB.getStringResource("StandardizationReport.metadata.updated.txt") : RB.getStringResource("StandardizationReport.metadata.update.ignored.txt");
            columnNode.addAttribute("valuechanged", updateStatus);
        }
        columnNode.addAttribute("table", instance.getTableName());
        columnNode.addAttribute("library", instance.getLibararyName());
        List<Attribute> attribs = instance.getAttributes();
        for (Attribute attrib : attribs) {
            columnNode.addAttribute(attrib.getMetadataAttributeName(), attrib.getDisplayValue());
        }
        return columnNode;
    }
}

