/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTException;
import com.sas.metadata.tools.cst.CSTPreferences;
import com.sas.metadata.tools.cst.ColumnInstance;
import com.sas.metadata.tools.cst.ColumnSearchResult;
import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.GroupInstances;
import com.sas.metadata.tools.cst.GroupInstancesComparator;
import com.sas.metadata.tools.cst.GroupInstancesInterface;
import com.sas.metadata.tools.cst.IColumnMetadataInterface;
import com.sas.metadata.tools.cst.RB;
import com.sas.metadata.tools.cst.StandardizationControllerInterface;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.metadata.tools.cst.tools.Utils;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StandardizationController
implements StandardizationControllerInterface {
    private ColumnSearchResult result;
    private GroupInstancesInterface singleGroup;
    private Locale locale;
    private Map<String, GroupInstancesInterface> multiGroups;
    private StandardizationSummary summary;
    private CSTPreferences cstPreferences;
    private List<GroupInstancesInterface> groupsList;
    private int count;

    public StandardizationController(ColumnSearchResult result) {
        this.init(result);
    }

    public StandardizationController(ColumnSearchResult result, Locale locale) {
        this(result);
        this.locale = locale;
    }

    private void init(ColumnSearchResult result) {
        if (result.multiGroupResult()) {
            Map<String, List<Map<String, String>>> mGroups = result.getColumns();
            if (!Utils.isEmpty(mGroups)) {
                int groupSize = mGroups.size();
                this.multiGroups = new HashMap<String, GroupInstancesInterface>(groupSize);
                Iterator<String> it = mGroups.keySet().iterator();
                String groupName = null;
                GroupInstances groupInstance = null;
                while (it.hasNext()) {
                    groupName = it.next();
                    groupInstance = new GroupInstances(groupName, mGroups.get(groupName));
                    this.count += groupInstance.count();
                    this.multiGroups.put(groupName, groupInstance);
                }
            }
        } else {
            this.singleGroup = new GroupInstances(result.getUserInput().getFilterKeyword(), result.getSingleGroupResults());
            this.count = this.singleGroup.count();
        }
        this.summary = new StandardizationSummary();
    }

    public StandardizationController(List<Map<String, String>> columns) {
        this.singleGroup = new GroupInstances("AllColumns", columns);
    }

    @Override
    public List<GroupInstancesInterface> getAllGroupInstances() {
        if (this.groupsList == null) {
            ArrayList<GroupInstancesInterface> list = null;
            if (this.multiGroups == null) {
                list = new ArrayList<GroupInstancesInterface>(1);
                list.add(this.singleGroup);
            } else {
                list = new ArrayList(this.multiGroups.size());
                list.addAll(this.multiGroups.values());
            }
            this.groupsList = list;
        }
        return this.groupsList;
    }

    @Override
    public List<GroupInstancesInterface> getUpdateGroupInstances() {
        ArrayList<GroupInstancesInterface> list = new ArrayList<GroupInstancesInterface>();
        List<GroupInstancesInterface> instances = this.getAllGroupInstances();
        for (int i = 0; i < instances.size(); ++i) {
            GroupInstancesInterface instance = instances.get(i);
            if (!instance.isStandardized()) continue;
            list.add(instance);
        }
        return list;
    }

    @Override
    public List<String> getGroupIdentifiers() {
        ArrayList<String> groupIds = null;
        if (!Utils.isEmpty(this.multiGroups)) {
            groupIds = new ArrayList<String>(this.multiGroups.size());
            groupIds.addAll(this.multiGroups.keySet());
        }
        return groupIds;
    }

    @Override
    public GroupInstancesInterface getInstance(String groupName) {
        return this.multiGroupsPresent() ? this.multiGroups.get(groupName) : null;
    }

    @Override
    public UserInput getUserInput() {
        return this.result != null ? this.result.getUserInput() : null;
    }

    @Override
    public GroupInstancesInterface getSingleGroupInterface() throws IllegalStateException {
        if (this.multiGroupsPresent()) {
            throw new IllegalStateException();
        }
        return this.singleGroup;
    }

    @Override
    public boolean multiGroupsPresent() {
        return this.multiGroups != null;
    }

    @Override
    public void update() throws CSTException {
        List<String> columnIds = null;
        List<Attribute> standardAttribs = null;
        IColumnMetadataInterface dao = null;
        List<GroupInstancesInterface> instances = this.getAllGroupInstances();
        dao = ControllerFactory.getDAO();
        for (GroupInstancesInterface instance : instances) {
            if (!instance.isStandardized()) continue;
            columnIds = this.getColumnIds(instance);
            standardAttribs = instance.getStandardValues();
            try {
                dao.standardizeColumn(standardAttribs, columnIds);
            }
            catch (RemoteException exception) {
                throw new CSTException(exception, Message.format((String)RB.getStringResource("StandardizationController.unable.to.update.columns.fmt"), (Object)exception.getMessage()));
            }
            catch (MdException exception) {
                throw new CSTException(exception, Message.format((String)RB.getStringResource("StandardizationController.unable.to.update.columns.fmt"), (Object)exception.getMessage()));
            }
        }
    }

    private List<String> getColumnIds(GroupInstancesInterface group) {
        ArrayList<String> columnIds = null;
        List<ColumnInstance> included = group.getIncluded();
        if (!Utils.isEmpty(included)) {
            columnIds = new ArrayList<String>(included.size());
            for (ColumnInstance column : included) {
                columnIds.add(column.getId());
            }
        }
        return columnIds;
    }

    @Override
    public StandardizationSummary getStandardizationSummary() {
        return this.summary;
    }

    @Override
    public CSTPreferences getPreferences() {
        return this.cstPreferences;
    }

    @Override
    public void setPreferences() {
        this.cstPreferences = CSTPreferences.getInstance();
    }

    @Override
    public List<GroupInstancesInterface> getSortedGroupInstances(StandardizationControllerInterface.GroupSortCriteria criteria) {
        GroupInstancesComparator comparator = GroupInstancesComparator.getComparator(criteria);
        if (this.locale != null) {
            comparator.setLocale(this.locale);
        }
        List<GroupInstancesInterface> groups = this.getAllGroupInstances();
        Collections.sort(groups, comparator);
        return groups;
    }

    public class StandardizationSummary {
        public int count() {
            return StandardizationController.this.count;
        }

        public int includedCount() {
            return this.getTotalCount(true);
        }

        public int updateCount() {
            return this.getTotalCount(false);
        }

        public int getGroupCount() {
            return this.getGroupSummary(false);
        }

        public int getStandardizedGroupCount() {
            return this.getGroupSummary(true);
        }

        private int getGroupSummary(boolean involved) {
            List<GroupInstancesInterface> instances = StandardizationController.this.getAllGroupInstances();
            int groupCount = 0;
            for (GroupInstancesInterface instance : instances) {
                groupCount += involved ? (instance.isStandardized() ? 1 : 0) : 1;
            }
            return groupCount;
        }

        private int getTotalCount(boolean included) {
            List<GroupInstancesInterface> instances = StandardizationController.this.getAllGroupInstances();
            int totalCount = 0;
            for (GroupInstancesInterface instance : instances) {
                if (!instance.isStandardized()) continue;
                totalCount += included ? instance.includedCount() : instance.updateCount();
            }
            return totalCount;
        }
    }
}

