/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

public class CstUtils {
    public static final int OS_UNDEFINED = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_HPUX = 4;
    public static final int OS_AIX = 5;
    public static final int OS_OPENVMS = 6;
    public static final int OS_ALX = 7;
    public static final int OS_MVS = 8;
    public static final int OS_MAC = 9;
    public static final int OS_ZOS = 10;
    public static final String OS_SUFFIX_SAX = "sax";
    public static final String OS_SUFFIX_S64 = "s64";
    public static final String OS_SUFFIX_LIX = "lix";
    public static final String OS_SUFFIX_LAX = "lax";
    public static final String OS_SUFFIX_LNX = "lnx";
    public static final String OS_SUFFIX_H6I = "h6i";
    public static final String OS_SUFFIX_H64 = "h64";
    public static final String OS_SUFFIX_R64 = "r64";
    public static final String OS_SUFFIX_ALX = "alx";
    public static final String OS_SUFFIX_W64 = "w64";
    public static final String OS_SUFFIX_WX6 = "wx6";
    public static final String OS_SUFFIX_WIN = "win";
    public static final String OS_SUFFIX_MVS = "mvs";
    public static final String OS_SUFFIX_MAC = "mac";
    public static final String OS_SUFFIX_VMI = "vmi";
    public static final String OS_SUFFIX_ZOS = "zos";
    public static final String OS_FAMILY_UNDEFINED = "Undefined";
    public static final String OS_FAMILY_UNIX = "Unix";
    public static final String OS_FAMILY_WINDOWS = "Windows";
    public static final String OS_FAMILY_MAC = "Macintosh";
    public static final String OS_FAMILY_MVS = "MVS";
    public static final String OS_FAMILY_ZOS = "ZOS";
    public static final String OS_FAMILY_VMS = "VMS";

    public static String getOS_Family() {
        switch (CstUtils.getOS()) {
            case 0: {
                return OS_FAMILY_UNDEFINED;
            }
            case 1: {
                return OS_FAMILY_WINDOWS;
            }
            case 2: {
                return OS_FAMILY_UNIX;
            }
            case 3: {
                return OS_FAMILY_UNIX;
            }
            case 4: {
                return OS_FAMILY_UNIX;
            }
            case 5: {
                return OS_FAMILY_UNIX;
            }
            case 6: {
                return OS_FAMILY_VMS;
            }
            case 7: {
                return OS_FAMILY_UNIX;
            }
            case 8: {
                return OS_FAMILY_MVS;
            }
            case 9: {
                return OS_FAMILY_MAC;
            }
            case 10: {
                return OS_FAMILY_ZOS;
            }
        }
        return OS_FAMILY_UNDEFINED;
    }

    public static int getOS() {
        int rc = 0;
        String osName = System.getProperty("os.name");
        if (osName.startsWith(OS_FAMILY_WINDOWS)) {
            rc = 1;
        } else if (osName.equalsIgnoreCase("Linux")) {
            rc = 2;
        } else if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
            rc = 3;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            rc = 4;
        } else if (osName.equalsIgnoreCase("AIX")) {
            rc = 5;
        } else if (osName.equalsIgnoreCase("OpenVMS")) {
            rc = 6;
        } else if (osName.equalsIgnoreCase("Compaq's Digital UNIX") || osName.equalsIgnoreCase("OSF1")) {
            rc = 7;
        } else if (osName.equalsIgnoreCase(OS_FAMILY_MVS)) {
            rc = 8;
        } else if (osName.equalsIgnoreCase("z/os")) {
            rc = 10;
        } else if (osName.startsWith("Mac")) {
            rc = 9;
        } else if (osName.startsWith("OpenVMS")) {
            rc = 6;
        }
        return rc;
    }
}

