/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.ColumnFilterImpl;
import com.sas.metadata.tools.cst.IColumnMetadataInterface;
import com.sas.metadata.tools.cst.RB;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.metadata.tools.cst.tools.Utils;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringEscapeUtils;

public class ColumnFilter
implements IColumnMetadataInterface {
    List lstHashMap = null;
    static MdFactory _factory;
    static MdOMIUtil m_omiUtil;
    String strReposId = null;

    public ColumnFilter() {
    }

    public static ColumnFilter getByWorkSpace() throws RemoteException, MdException {
        _factory = Workspace.getMdFactory();
        return new ColumnFilter(_factory);
    }

    public static ColumnFilter getByfactory(MdFactory factory) throws RemoteException, MdException {
        _factory = factory;
        return new ColumnFilter(_factory);
    }

    private ColumnFilter(MdFactory factory) throws RemoteException, MdException {
        _factory = factory;
        m_omiUtil = _factory.getOMIUtil();
        this.strReposId = m_omiUtil.getFoundationReposID();
    }

    private String GetLibraryString(List lstLibraries) {
        int i = 0;
        StringBuffer strLibraries = new StringBuffer();
        if (lstLibraries != null) {
            String Temp = "";
            do {
                Temp = (String)lstLibraries.get(i);
                strLibraries.append(" @Name='" + Temp + "' or");
            } while (lstLibraries.size() > ++i);
            strLibraries = new StringBuffer(strLibraries.substring(0, strLibraries.length() - 2));
        }
        return strLibraries.toString();
    }

    @Override
    public List<String> getLibraries() throws RemoteException, MdException {
        int Flag = 4 | 0x80 | 0x100 | 0x2000;
        List MetadataObjectList = m_omiUtil.getMetadataObjectsSubset((MdStore)_factory.createObjectStore(), this.strReposId, "SASLibrary", Flag, "");
        ArrayList<String> libPaths = null;
        String libPath = null;
        if (!Utils.isEmpty(MetadataObjectList)) {
            libPaths = new ArrayList<String>(MetadataObjectList.size());
            for (SASLibrary sasLib : MetadataObjectList) {
                libPath = this.constructPathToParent(sasLib);
                libPaths.add(libPath);
            }
        }
        return libPaths;
    }

    private String constructPathToParent(SASLibrary sasLib) throws RemoteException, MdException {
        Object parent = null;
        Tree currentNode = null;
        StringBuilder path = null;
        if (sasLib != null) {
            path = new StringBuilder(sasLib.getName());
            AssociationList trees = sasLib.getTrees();
            if (!Utils.isEmpty(trees)) {
                for (currentNode = (Tree)trees.get(0); currentNode != null; currentNode = currentNode.getParentTree()) {
                    path.insert(0, "/");
                    path.insert(0, currentNode.getName());
                }
            }
            return path.toString();
        }
        return null;
    }

    @Override
    public void standardizeColumn(List<Attribute> Attributes, List<String> objectId) throws RemoteException, MdException {
        String initStr = "<UpdateMetadata><Metadata>";
        String endStr = "</Metadata><NS>SAS</NS><Flags>268435456</Flags><Options/></UpdateMetadata>";
        String updateStr = this.generateUpdateString(Attributes, objectId);
        String inXML = initStr + updateStr + endStr;
        m_omiUtil.DoRequest(inXML);
    }

    public String generateUpdateString(List<Attribute> attributes, List<String> objectId) {
        StringBuffer updateString = new StringBuffer();
        for (int i = 0; i < objectId.size(); ++i) {
            String strColumn = "<Column Id =\"" + objectId.get(i).toString() + "\"";
            String strAttr = "";
            for (int j = 0; j < attributes.size(); ++j) {
                String strTemp = " " + attributes.get(j).getMetadataAttributeName() + " =\"" + attributes.get(j).getAttributeValue() + "\"";
                strAttr = strAttr + strTemp;
                if (attributes.get(j).getMetadataAttributeName().equalsIgnoreCase("SASColumnLength")) {
                    strAttr = strAttr + " ColumnLength =\"" + attributes.get(j).getAttributeValue() + "\" ";
                }
                if (!attributes.get(j).getMetadataAttributeName().equalsIgnoreCase("SASColumnName")) continue;
                strAttr = strAttr + " ColumnName =\"" + attributes.get(j).getAttributeValue() + "\" Name =\"" + attributes.get(j).getAttributeValue() + "\" ";
            }
            String tempUpdateString = strColumn + strAttr;
            updateString.append(tempUpdateString + "/>");
        }
        return updateString.toString();
    }

    @Override
    public List<Map<String, String>> getColumn(UserInput Ip) throws RemoteException, MdException {
        String strLibraries;
        String XMLSelectForSL = "";
        String XMLSelectForNSL = "";
        String XMLSelectForET = "";
        ArrayList<CMetadata> MetadataObjectList = new ArrayList<CMetadata>();
        List<String> lstLibraries = Ip.getSelectedLibraries();
        this.lstHashMap = null;
        if (lstLibraries == null && Ip.getSelectedLibrariesCount() > 0) {
            XMLSelectForSL = "<XMLSelect search=\"Column[@Name contains '" + StringEscapeUtils.escapeXml((String)Ip.getFilterValue()) + "'][Table/PhysicalTable[@PublicType='Table']]\"/>";
        } else if (lstLibraries != null && (strLibraries = this.GetLibraryString(lstLibraries)) != null) {
            XMLSelectForSL = "<XMLSelect search=\"Column[@Name contains'" + StringEscapeUtils.escapeXml((String)Ip.getFilterValue()) + "'][Table/PhysicalTable/TablePackage/SASLibrary[" + strLibraries + "]]\"/>";
            XMLSelectForNSL = "<XMLSelect search=\"Column[@Name contains'" + StringEscapeUtils.escapeXml((String)Ip.getFilterValue()) + "'][Table/PhysicalTable/TablePackage/DatabaseSchema[" + strLibraries + "]]\"/>";
        }
        if (Ip.INCLUDEEXTERNALTABLE) {
            XMLSelectForET = "<XMLSelect search=\"Column[@Name contains '" + StringEscapeUtils.escapeXml((String)Ip.getFilterValue()) + "'][Table/ExternalTable[@PublicType='ExternalFile']]\"/>";
        }
        List<CMetadata> MetadataObjectListForSL = this.getRequestedColumn(XMLSelectForSL);
        List<CMetadata> MetadataObjectListForNSL = this.getRequestedColumn(XMLSelectForNSL);
        List<CMetadata> MetadataObjectListForET = this.getRequestedColumn(XMLSelectForET);
        if (MetadataObjectListForSL != null && !MetadataObjectListForSL.isEmpty()) {
            MetadataObjectList.addAll(MetadataObjectListForSL);
        }
        if (MetadataObjectListForNSL != null && !MetadataObjectListForNSL.isEmpty()) {
            MetadataObjectList.addAll(MetadataObjectListForNSL);
        }
        if (MetadataObjectListForET != null && !MetadataObjectListForET.isEmpty()) {
            MetadataObjectList.addAll(MetadataObjectListForET);
        }
        if (MetadataObjectList.size() > 0) {
            ColumnFilterImpl colImpl = new ColumnFilterImpl(MetadataObjectList.size(), m_omiUtil);
            if (Ip.getFilterKeyword().equalsIgnoreCase(UserInput.FILTER_CONTAINS)) {
                this.lstHashMap = colImpl.GetContainingColumnMap(MetadataObjectList);
            } else if (Ip.getFilterKeyword().equalsIgnoreCase(UserInput.FILTER_STARTSWITH)) {
                this.lstHashMap = colImpl.GetStartswithColumnMap(Ip.getFilterValue(), MetadataObjectList);
            } else if (Ip.getFilterKeyword().equalsIgnoreCase(UserInput.FILTER_ENDSWITH)) {
                this.lstHashMap = colImpl.GetEndsswithColumnMap(Ip.getFilterValue(), MetadataObjectList);
            } else if (Ip.getFilterKeyword().equalsIgnoreCase(UserInput.FILTER_EQUALSTO)) {
                this.lstHashMap = colImpl.GetEqualwithColumnMap(Ip.getFilterValue(), MetadataObjectList);
            } else {
                JOptionPane.showInputDialog(RB.getStringResource("ColumnFilter.invalid.input.txt"));
            }
        }
        return this.lstHashMap;
    }

    @Override
    public Map<String, List<Map<String, String>>> getGroupbyColumn(UserInput Ip) throws RemoteException, MdException {
        String strLibraries;
        String XMLSelectForSL = "";
        String XMLSelectForNSL = "";
        String XMLSelectForET = "";
        ArrayList<CMetadata> MetadataObjectList = new ArrayList<CMetadata>();
        Map<String, List<Map<String, String>>> hmmColumnGroupMap = new HashMap<String, List<Map<String, String>>>();
        List<String> lstLibraries = Ip.getSelectedLibraries();
        if (lstLibraries == null && Ip.getSelectedLibrariesCount() > 0) {
            XMLSelectForSL = "<XMLSelect search=\"Column[@Name contains '" + Ip.getFilterValue() + "'][Table/PhysicalTable[@PublicType='Table']]\"/>";
        } else if (lstLibraries != null && (strLibraries = this.GetLibraryString(lstLibraries)) != null && strLibraries != "") {
            XMLSelectForSL = "<XMLSelect search=\"Column[@Name contains'" + Ip.getFilterValue() + "'][Table/PhysicalTable/TablePackage/SASLibrary[" + strLibraries + "]]\"/>";
            XMLSelectForNSL = "<XMLSelect search=\"Column[@Name contains'" + Ip.getFilterValue() + "'][Table/PhysicalTable/TablePackage/DatabaseSchema[" + strLibraries + "]]\"/>";
        }
        if (Ip.INCLUDEEXTERNALTABLE) {
            XMLSelectForET = "<XMLSelect search=\"Column[@Name contains '" + StringEscapeUtils.escapeXml((String)Ip.getFilterValue()) + "'][Table/ExternalTable[@PublicType='ExternalFile']]\"/>";
        }
        List<CMetadata> MetadataObjectListForSL = this.getRequestedColumn(XMLSelectForSL);
        List<CMetadata> MetadataObjectListForNSL = this.getRequestedColumn(XMLSelectForNSL);
        List<CMetadata> MetadataObjectListForET = this.getRequestedColumn(XMLSelectForET);
        if (MetadataObjectListForSL != null && !MetadataObjectListForSL.isEmpty()) {
            MetadataObjectList.addAll(MetadataObjectListForSL);
        }
        if (MetadataObjectListForNSL != null && !MetadataObjectListForNSL.isEmpty()) {
            MetadataObjectList.addAll(MetadataObjectListForNSL);
        }
        if (MetadataObjectListForET != null && !MetadataObjectListForET.isEmpty()) {
            MetadataObjectList.addAll(MetadataObjectListForET);
        }
        if (MetadataObjectList.size() > 0) {
            ColumnFilterImpl colImpl = new ColumnFilterImpl(MetadataObjectList.size(), m_omiUtil);
            if (Ip.getFilterKeyword().equalsIgnoreCase(UserInput.FILTER_GROUPBYNAME)) {
                hmmColumnGroupMap = colImpl.GetGroupbyColumnMap(MetadataObjectList);
            }
        }
        return hmmColumnGroupMap;
    }

    private List<CMetadata> getRequestedColumn(String XmlSelect) throws RemoteException, MdException {
        List<Object> MetadataObjectList = new ArrayList<CMetadata>();
        int Flag = 4 | 0x80 | 0x100 | 0x2000;
        if (XmlSelect != null && !XmlSelect.equals("")) {
            MetadataObjectList = m_omiUtil.getMetadataObjectsSubset((MdStore)_factory.createObjectStore(), this.strReposId, "Column", Flag, XmlSelect);
        }
        return MetadataObjectList;
    }

    @Override
    public Column getMetadataColumn(String ColumnId) throws RemoteException, MdException {
        String XMLSelect = "<XMLSelect search=\"Column[@Id = '" + ColumnId + "']]\"/>";
        Column column1 = null;
        List lstColumn = _factory.getOMIUtil().getMetadataObjectsSubset((MdStore)_factory.createObjectStore(), this.strReposId, "Column", 4 | 0x80 | 0x100, XMLSelect);
        if (lstColumn.size() > 0) {
            Column column = (Column)lstColumn.get(0);
            column1 = (Column)_factory.createComplexMetadataObject(_factory.createObjectStore(), (CMetadata)column);
            return column1;
        }
        return column1;
    }

    static {
        m_omiUtil = null;
    }
}

