/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.cst;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.tools.cst.Attribute;
import com.sas.metadata.tools.cst.CSTClientOptions;
import com.sas.metadata.tools.cst.CSTException;
import com.sas.metadata.tools.cst.ControllerFactory;
import com.sas.metadata.tools.cst.LoggerWrapper;
import com.sas.metadata.tools.cst.RB;
import com.sas.metadata.tools.cst.StandardizationControllerInterface;
import com.sas.metadata.tools.cst.StandardizationReport;
import com.sas.metadata.tools.cst.UserInput;
import com.sas.services.ServiceException;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class BatchCst
extends BatchDriver2 {
    static String m_strHost = null;
    static String m_strPort = null;
    static String m_strUser = null;
    static String m_strPassword = null;
    static String m_strDomain = null;
    static String m_strRepository = null;
    static String m_strRepositoryId = null;
    static String m_strSearchkeyword = null;
    static String m_strSearchvalue = null;
    static boolean includeExternalTable = false;
    static String m_strLibrary = null;
    static String m_strAttributes = null;
    static String m_strpath = null;
    public static MdFactory mdFact;
    boolean AttrFlag = false;
    private UserInput _userInput = null;

    public BatchCst() {
        if (this._logger == null) {
            this._logger = LoggerWrapper.getLoggerInstance();
        }
    }

    protected void parse(String[] args) throws MissingOptionException, ParseException {
        this._options = new CSTClientOptions();
        if (args == null || args.length == 0) {
            this._help = true;
            return;
        }
        super.parse(args);
        mdFact = this._factory;
        if (this._help) {
            return;
        }
        Option[] arrOptions = this._commandLine.getOptions();
        this._userInput = new UserInput();
        for (int iOpt = 0; iOpt < arrOptions.length; ++iOpt) {
            Option objOption = arrOptions[iOpt];
            if ("domain".equalsIgnoreCase(objOption.getOpt())) {
                m_strDomain = objOption.getValue();
                continue;
            }
            if ("repository".equalsIgnoreCase(objOption.getOpt())) {
                m_strRepository = objOption.getValue();
                continue;
            }
            if ("searchkeyword".equalsIgnoreCase(objOption.getOpt())) {
                m_strSearchkeyword = objOption.getValue();
                this._userInput.setFilterKeyword(m_strSearchkeyword);
                continue;
            }
            if ("searchvalue".equalsIgnoreCase(objOption.getOpt())) {
                m_strSearchvalue = objOption.getValue();
                this._userInput.setFilterValue(m_strSearchvalue);
                continue;
            }
            if ("includeExternaltable".equalsIgnoreCase(objOption.getOpt())) {
                String value = objOption.getValue();
                if (value.equalsIgnoreCase("true")) {
                    includeExternalTable = true;
                }
                this._userInput.setIncludeExternalTableFlag(includeExternalTable);
                continue;
            }
            if ("library".equalsIgnoreCase(objOption.getOpt())) {
                m_strLibrary = objOption.getValue();
                if (m_strLibrary == null || m_strLibrary.equalsIgnoreCase("ALL")) {
                    this._userInput.setSelectedLibraries(null);
                    continue;
                }
                List<String> selectedLibraries = this.CreateListFromString(m_strLibrary);
                this._userInput.setSelectedLibraries(selectedLibraries);
                continue;
            }
            if (!"attributes".equalsIgnoreCase(objOption.getOpt())) continue;
            m_strAttributes = objOption.getValue();
            if (m_strAttributes == null || m_strAttributes.equalsIgnoreCase("ALL")) {
                this.AttrFlag = true;
                continue;
            }
            List<String> selectedAttributes = this.CreateListFromString(m_strAttributes);
            ArrayList<Attribute> lstAttr = new ArrayList<Attribute>(selectedAttributes.size());
            for (int i = 0; i < selectedAttributes.size(); ++i) {
                Attribute attr = new Attribute(selectedAttributes.get(i));
                lstAttr.add(attr);
            }
            this._userInput.setAttributes(lstAttr);
        }
    }

    private List<String> CreateListFromString(String library) {
        ArrayList<String> lstObject = null;
        if (library.length() > 0) {
            lstObject = new ArrayList<String>();
            this.parseString(library, lstObject);
        }
        return lstObject;
    }

    private void parseString(String library, List<String> lstObject) {
        int iPos = library.indexOf(",");
        if (iPos != -1) {
            String strLibrary = library.substring(0, iPos);
            lstObject.add(strLibrary);
            library = library.substring(iPos + 1, library.length());
            this.parseString(library, lstObject);
        } else {
            lstObject.add(library);
        }
    }

    public void invokeCST() throws CSTException {
        try {
            this.initialize();
            mdFact = this._factory;
            MdOMRConnection omrConnection = mdFact.getConnection();
            MdOMIUtil omiUtil = mdFact.getOMIUtil();
            List lstRepos = omiUtil.getRepositories();
            if (lstRepos == null || lstRepos.size() == 0) {
                this._logger.error(RB.getStringResource("BatchCst.repos.not.found.txt"));
            } else {
                Object[] objectArray = new Object[]{lstRepos.size()};
            }
            for (int iRepos = 0; iRepos < lstRepos.size(); ++iRepos) {
                CMetadata cm = (CMetadata)lstRepos.get(iRepos);
                String strReposId = cm.getId();
                String strReposName = cm.getName();
                if (!strReposName.equalsIgnoreCase(m_strRepository)) continue;
                m_strRepositoryId = strReposId;
            }
            ControllerFactory batchfactory = ControllerFactory.getFactoryForBatch(mdFact);
            if (this.AttrFlag) {
                ControllerFactory.StandardAttributes attr = batchfactory.getAttributesToStandardize();
                this._userInput.setAttributes(attr.getAttributes());
            }
            StandardizationControllerInterface _std = batchfactory.getController(this._userInput);
            if (this._userInput.getFilterKeyword().equalsIgnoreCase(UserInput.FILTER_GROUPBYNAME)) {
                this._logger.error(Message.format((String)RB.getStringResource("BatchCst.option.not.supported.fmt"), (Object)UserInput.FILTER_GROUPBYNAME));
            } else {
                boolean flag = true;
                StandardizationReport _rpt = new StandardizationReport(_std, this._logger);
                this._logger.info(RB.getStringResource("BatchCst.finding.inconsistent.cols.txt"));
                _std.setPreferences();
                String reportPath = _rpt.generateReport();
                this._logger.info(Message.format((String)RB.getStringResource("BatchCst.report.generated.at.fmt"), (Object)reportPath));
                this._logger.info(RB.getStringResource("BatchCst.report.generated.txt"));
            }
            omiUtil.dispose();
        }
        catch (RemoteException e) {
            throw new CSTException(e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            throw new CSTException(e.getLocalizedMessage());
        }
        catch (LogicalTypeException e) {
            throw new CSTException(e.getLocalizedMessage());
        }
        catch (MdException e) {
            throw new CSTException(e.getLocalizedMessage());
        }
    }

    private static String getUsage(HelpFormatter help) {
        String NEW_LINE = help.getNewLine();
        StringBuffer usage = new StringBuffer();
        String sUsage = "CST -repository repositoryname -searchkeyword searchkeyword -searchvalue searchvalue [options...]";
        usage.append(sUsage);
        usage.append(NEW_LINE).append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchCst.help.Example1.txt"));
        usage.append(NEW_LINE).append(NEW_LINE).append("CST -repository foundation -searchcriteria contains -searchvalue a ").append(NEW_LINE);
        usage.append(NEW_LINE).append(NEW_LINE).append(NEW_LINE);
        usage.append(RB.getStringResource("BatchCst.help.Example2.txt"));
        usage.append(NEW_LINE).append(NEW_LINE).append("CST -repository foundation -searchcriteria equals -searchvalue address -library MySASLibrary -attributes length,format,informat").append(NEW_LINE);
        return usage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BatchCst cl = new BatchCst();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        try {
            cl.parse(args);
            if (cl._help) {
                HelpFormatter help = new HelpFormatter();
                Options helpOptions = BatchCst.getHelpOptions((Options)cl._options, null);
                help.printHelp(80, BatchCst.getUsage(help), RB.getStringResource("BatchCst.batchcst.options.txt"), helpOptions, null);
                return;
            }
            cl._logger.info(RB.getStringResource("BatchCst.processing.req.txt"));
            cl.invokeCST();
            cl._logger.info(RB.getStringResource("BatchCst.exiting.txt"));
        }
        catch (MissingOptionException e) {
            cl._logger.debug(RB.getStringResource("BatchCst.missing.options.fmt"), (Throwable)e);
            cl._logger.error(e.getLocalizedMessage());
            System.exit(8);
        }
        catch (ParseException e) {
            cl._logger.debug(RB.getStringResource("BatchCst.invalid.options.fmt"), (Throwable)e);
            cl._logger.error(e.getLocalizedMessage());
            System.exit(8);
        }
        catch (CSTException e) {
            cl._logger.debug(RB.getStringResource("BatchCst.failed.with.exection.txt"), (Throwable)e);
            cl._logger.error(e.getLocalizedMessage());
            System.exit(8);
        }
        catch (Exception e) {
            cl._logger.debug(RB.getStringResource("BatchCst.failed.with.exection.txt"), (Throwable)e);
            cl._logger.error(e.getLocalizedMessage());
            System.exit(8);
        }
        finally {
            System.exit(0);
        }
    }
}

