/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.repository;

import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdResponsibilitiesUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ServiceDeploymentDeleter;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.secureddata.SecuredDataFolderUtil;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.repository.RB;
import com.sas.svcs.metadata.mgmt.impl.repository.RepositoryHelper;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

final class OneOffUpgradeHelper {
    private final Logger logger = LogManager.getLogger(OneOffUpgradeHelper.class);
    private RequestContext ctx;
    private MetadataRepositoryService repositoryService;
    public static final String TABLE_SERVER_DELETE_TEMPLATE = "<Template TemplateName=\"TSDeleteServer\" Type=\"TSServer\"><LogicalServer><UsingComponents/><Properties/><Keywords/><Extensions/><Notes/><Documents><Document TemplateExpand=\"connect\" AutoMap=\"Y\" /></Documents><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls><ServiceTypes /></LogicalServer><ServerComponent><PropertySets/><Properties/><Keywords/><Extensions/><Notes/><Documents><Document TemplateExpand=\"connect\" AutoMap=\"Y\" /></Documents><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls><InitProcesses><Transformation Match=\"@TransformRole='Initialization'\" TemplateExpand=\"yes\" /></InitProcesses><ServiceTypes /><Groups><Group Match=\"@name='TS Administrators'\" TemplateExpand=\"yes\" /></Groups><SoftwareTrees><Tree Match=\"@TreeType='TS Config'\" TemplateExpand=\"yes\" /><Tree Match=\"@TreeType='SSO Tree'\" TemplateExpand=\"yes\" /></SoftwareTrees><SourceConnections /><DataPackages/><UsingComponents><ServerComponent TemplateExpand=\"connect\" AutoMap=\"Y\" /><ServiceComponent TemplateExpand=\"yes\" /></UsingComponents></ServerComponent><ServiceComponent><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls><PropertySets/><Properties/><ServiceTypes/><DataPackages/></ServiceComponent><Tree><SubTrees/><Members><Identity TemplateExpand=\"connect\" ConnectionAction=\"W\" /><Group TemplateExpand=\"yes\" /><Directory/><File/><ConfiguredComponent/></Members><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls></Tree><Group><Members><Identity TemplateExpand=\"connect\" AutoMap=\"Y\" ConnectionAction=\"W\" /><Login TemplateExpand=\"connect\" AutoMap=\"Y\" ConnectionAction=\"W\" /></Members></Group><Directory><AccessControls><AccessControlTemplate TemplateExpand=\"connect\" /><AccessControlEntry /></AccessControls><SubDirectories /></Directory><AccessControlEntry><AssociatedCondition /><Permissions><Permission TemplateExpand=\"connect\" /></Permissions><Identities><Identity TemplateExpand=\"connect\" /></Identities></AccessControlEntry><PropertySet><SetProperties/></PropertySet><Property><OwningType><PropertyType TemplateExpand=\"yes\" /></OwningType></Property><PropertyType><StoredConfiguration /><Properties /></PropertyType><TCPIPConnection><Properties /></TCPIPConnection><COMConnection><Properties/></COMConnection><SASClientConnection><Properties/></SASClientConnection></Template>";

    OneOffUpgradeHelper(RequestContext ctx, MetadataRepositoryService repositoryService) {
        this.ctx = ctx;
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeNetezzaServersAndLibraries(Repository repository) {
        String strSelect = "<XMLSelect search=\"*[@ClassIdentifier='Netezza']\"/>";
        String strTemplate = "<Templates><ServerComponent><SourceConnections/></ServerComponent> <SASClientConnection><Properties/><Libraries/></SASClientConnection><SASLibrary><Properties/></SASLibrary><Property><OwningType/></Property></Templates>";
        String strOptions = strSelect + strTemplate;
        int flags = 396;
        MdFactory factory = this.ctx.getFactory();
        MdObjectStore store = null;
        this.logger.info(RB.getStringResource("OneOffUpgradeHelper.UpdateNetezzaDefinitions.txt"));
        try {
            store = factory.createObjectStore();
            List serverComponents = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "ServerComponent", flags, strOptions, false);
            for (ServerComponent netServer : serverComponents) {
                AssociationList connections = netServer.getSourceConnections();
                for (CMetadata connection : connections) {
                    if (!(connection instanceof SASClientConnection)) continue;
                    SASClientConnection scc = (SASClientConnection)connection;
                    ArrayList<Property> propsToMoveList = new ArrayList<Property>();
                    for (Property prop : scc.getProperties()) {
                        if (!prop.getPropertyName().equalsIgnoreCase("DATABASE")) continue;
                        propsToMoveList.add(prop);
                    }
                    if (propsToMoveList.size() == 0) continue;
                    for (SASLibrary library : scc.getLibraries()) {
                        if (!library.getEngine().equalsIgnoreCase("NETEZZA")) continue;
                        AssociationList existingLibraryProperties = library.getProperties();
                        for (Property movingProperty : propsToMoveList) {
                            boolean foundProp = false;
                            for (Property existingProperty : existingLibraryProperties) {
                                if (!movingProperty.getName().equalsIgnoreCase(existingProperty.getName())) continue;
                                foundProp = true;
                                break;
                            }
                            if (foundProp) continue;
                            Property newProp = (Property)factory.createComplexMetadataObject(store, movingProperty.getName(), "Property", repository.getShortId());
                            newProp.setDefaultValue(movingProperty.getDefaultValue());
                            newProp.setDelimiter(movingProperty.getDelimiter());
                            newProp.setDesc(movingProperty.getDesc());
                            newProp.setPropertyName(movingProperty.getPropertyName());
                            newProp.setSQLType(movingProperty.getSQLType());
                            newProp.getOwningTypes().add((Object)movingProperty.getOwningType());
                            library.getProperties().add((Object)newProp);
                        }
                    }
                    for (Property property : propsToMoveList) {
                        property.delete();
                    }
                }
            }
            store.updatedMetadataAll();
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.UpdateNetezzaDefinitions.Error.txt", (Object)e.getLocalizedMessage()));
            this.ctx.setError(true);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException remoteException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSystemFolderForCustomRepositories(Repository repository) {
        Tree systemFolder = null;
        MdFactory factory = this.ctx.getFactory();
        MdObjectStore store = null;
        try {
            store = factory.createObjectStore();
            if (repository.isFoundation()) {
                SoftwareComponent sc = this.getBIPTreeObject(store, repository);
                if (sc == null) {
                    throw new MdException(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.NoRootFolder.fmt.txt", (Object)repository.getName()));
                }
                systemFolder = this.getTopLevelFolder(sc, "System");
                if (systemFolder == null) {
                    String reposID = repository.getShortId();
                    systemFolder = (Tree)factory.createComplexMetadataObject(store, null, "System", "Tree", reposID);
                    systemFolder.setTreeType("System");
                    systemFolder.setPublicType("Folder");
                    systemFolder.setUsageVersion("1000000.0");
                    systemFolder.setDesc(factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SystemFolder.Description.txt")));
                    systemFolder.getSoftwareComponents().add((Object)sc);
                    systemFolder.updateMetadataAll();
                }
            } else if (repository.isCustom()) {
                String BILINEAGE_REPOS_NAME = "BILineage";
                if ("BILineage".equalsIgnoreCase(repository.getName()) && "BILineage".equalsIgnoreCase(repository.getDescription())) {
                    return;
                }
                SoftwareComponent sc = this.getBIPTreeObject(store, repository);
                if (sc == null) {
                    throw new MdException(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.NoRootFolder.fmt.txt", (Object)repository.getName()));
                }
                String reposFolderName = Names.mapNameToOMRObjectName((String)repository.getName());
                Tree reposFolder = this.getTopLevelFolder(sc, reposFolderName);
                if (reposFolder == null) {
                    throw new MdException(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.NoRootFolder.fmt.txt", (Object)repository.getName()));
                }
                AssociationList folderList = reposFolder.getSubTrees();
                for (Tree tree : folderList) {
                    if (!"System".equals(tree.getName()) || !"Folder".equals(tree.getPublicType())) continue;
                    systemFolder = tree;
                }
                if (systemFolder == null) {
                    String reposID = repository.getShortId();
                    systemFolder = (Tree)factory.createComplexMetadataObject(store, null, "System", "Tree", reposID);
                    systemFolder.setTreeType("System");
                    systemFolder.setPublicType("Folder");
                    systemFolder.setUsageVersion("1000000.0");
                    systemFolder.setDesc(factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SystemFolder.Description.txt")));
                    systemFolder.getParentTrees().add((Object)reposFolder);
                    systemFolder.updateMetadataAll();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.CreateSystemFolder.Error.txt", (Object)repository.getName(), (Object)e.getLocalizedMessage()));
            this.ctx.setError(true);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException remoteException) {}
        }
    }

    SoftwareComponent getBIPTreeObject(MdObjectStore store, Repository repository) throws Exception {
        String strOptions = "<XMLSELECT search=\"@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06'\"/>";
        int flags = 0x10000180;
        List components = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "SoftwareComponent", flags, strOptions, false);
        if (components != null && components.size() > 0) {
            return (SoftwareComponent)components.get(0);
        }
        return null;
    }

    private Tree getTopLevelFolder(SoftwareComponent rootFolder, String folderName) throws MdException, RemoteException {
        AssociationList folders = rootFolder.getSoftwareTrees();
        for (Tree tree : folders) {
            if (!folderName.equals(tree.getName()) || !"Folder".equals(tree.getPublicType())) continue;
            return tree;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeContentMappingDocuments(Repository repository) {
        MdObjectStore store = null;
        this.logger.info(RB.getStringResource("OneOffUpgradeHelper.UpgradeContentMappingDocuments.txt"));
        try {
            store = this.ctx.getFactory().createObjectStore();
            String strOptions = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/><Templates><SoftwareComponent Name=\"\"><SoftwareTrees/><Documents/></SoftwareComponent><Tree><Documents/></Tree></Templates>";
            List comps = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "SoftwareComponent", 396, strOptions, false);
            if (comps.size() != 1) {
                return;
            }
            SoftwareComponent sc = (SoftwareComponent)comps.get(0);
            this.updateContentMappingDocument((Root)sc);
            for (Tree tree : sc.getSoftwareTrees()) {
                this.updateContentMappingDocument((Root)tree);
            }
            store.updatedMetadataAll();
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.UpgradeContentMappingDocuments.Error.txt", (Object)e.getLocalizedMessage()));
            this.ctx.setError(true);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException remoteException) {}
        }
    }

    private void updateContentMappingDocument(Root folder) throws RemoteException, MdException {
        String uriField;
        Document rrcmRole = null;
        Document rrcmName = null;
        Document fldrName = null;
        for (Document doc : folder.getDocuments()) {
            if ("ReportRepositoryContentMapping".equals(doc.getTextRole())) {
                rrcmRole = doc;
                continue;
            }
            if ("Report Repository Content Mapping".equals(doc.getName())) {
                rrcmName = doc;
                continue;
            }
            if (!(folder instanceof Tree) || !folder.getName().equals(doc.getName())) continue;
            fldrName = doc;
        }
        Document rrcmDocument = null;
        if (rrcmRole != null) {
            rrcmDocument = rrcmRole;
            if (rrcmName != null) {
                this.deleteExtraContentMappingDocument(rrcmName);
            }
            if (fldrName != null) {
                this.deleteExtraContentMappingDocument(fldrName);
            }
        } else if (fldrName != null) {
            rrcmDocument = fldrName;
            if (rrcmName != null) {
                this.deleteExtraContentMappingDocument(rrcmName);
            }
        } else if (rrcmName != null) {
            rrcmDocument = rrcmName;
        }
        if (rrcmDocument == null) {
            return;
        }
        if (folder instanceof SoftwareComponent) {
            if (!"Report Repository Content Mapping".equals(rrcmDocument.getName())) {
                rrcmDocument.setName("Report Repository Content Mapping");
            }
        } else if (!folder.getName().equals(rrcmDocument.getName())) {
            rrcmDocument.setName(folder.getName());
        }
        if (!rrcmDocument.getPublicType().equals("")) {
            rrcmDocument.setPublicType("");
        }
        if (rrcmDocument.getUsageVersion() != 0.0) {
            rrcmDocument.setUsageVersion(0.0);
        }
        if (!"ReportRepositoryContentMapping".equals(rrcmDocument.getTextRole())) {
            rrcmDocument.setTextRole("ReportRepositoryContentMapping");
        }
        if ((uriField = rrcmDocument.getURI()).startsWith("http:") || uriField.startsWith("https:")) {
            if (!"DAV".equals(rrcmDocument.getURIType())) {
                rrcmDocument.setURIType("DAV");
            }
        } else if (!"File".equals(rrcmDocument.getURIType())) {
            rrcmDocument.setURIType("File");
        }
        rrcmDocument.getTrees().clear();
    }

    private void deleteExtraContentMappingDocument(Document doc) throws RemoteException {
        this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.DeleteExtraContentMappingDocument.txt", (Object)doc.getId()));
        doc.delete();
    }

    void removeFrameworkDataServerMetadata() {
        int count = 0;
        this.logger.info(RB.getStringResource("OneOffUpgradeHelper.RemoveFrameworkDataServerMetadata.txt"));
        count += this.deleteObjects(null, "LogicalServer", "*[@PublicType='LogicalServer.Framework']");
        if ((count += this.deleteObjects(null, "TypeDefinition", "*[@TypeName='LogicalServer.Framework' OR @TypeName='Server.Framework']")) > 0) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.RemoveFrameworkDataServerMetadata.Total.fmt.txt", (Object)count));
        }
    }

    void removeTableServerMetadata() {
        int count = 0;
        this.logger.info(RB.getStringResource("OneOffUpgradeHelper.RemoveTableServerMetadata.txt"));
        count += this.deleteObjects(null, "LogicalServer", "*[@PublicType ='LogicalServer.TableServer']", TABLE_SERVER_DELETE_TEMPLATE);
        count += this.deleteObjects(null, "DataSourceName", "*[@PublicType ='DataSourceName']");
        count += this.deleteObjects(null, "Tree", "*[@PublicType='TSSourceTree']");
        count += this.deleteObjects(null, "TSNamespace", "*[@PublicType='TSNameSpace']");
        count += this.deleteObjects(null, "TSNameObject", "*[@PublicType='TSName']");
        count += this.deleteObjects(null, "Tree", "*[@TreeType='TS Config' OR @TreeType='SSO Tree']");
        count += this.deleteObjects(null, "AccessControlTemplate", "*[@Name=:'TS Data Source Administrator ACT' OR @Name='TableServerACT']");
        count += this.deleteObjects(null, "IdentityGroup", "*[@Name ='TS Administrators']");
        count += this.deleteObjects(null, "TypeDefinition", "*[@TypeName ='LogicalServer.TableServer']");
        count += this.deleteObjects(null, "TypeDefinition", "*[@TypeName ='DataSourceName']");
        count += this.deleteObjects(null, "TypeDefinition", "*[@TypeName ='TSName']");
        count += this.deleteObjects(null, "TypeDefinition", "*[@TypeName ='TSSourceTree']");
        if ((count += this.deleteObjects(null, "TypeDefinition", "*[@TypeName =:'TSNamespace']")) > 0) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.RemoveTableServerMetadata.Total.txt", (Object)Integer.toString(count)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnalyticsPlatformMetadata() {
        int flags = 10632;
        String reposId = this.repositoryService.getFoundationRepository().getId();
        MdFactory factory = this.ctx.getFactory();
        MdObjectStore store = null;
        this.logger.info(RB.getStringResource("OneOffUpgradeHelper.RemoveAnalyticsPlatformMetadata.txt"));
        try {
            store = factory.createObjectStore();
            String strSelect = "<XMLSELECT search=\"*[@PublicType ='Application' AND @ClassIdentifier='apcore']\"/>";
            String strTemplate = "<Templates><SoftwareComponent><Notes/><Trees/></SoftwareComponent></Templates>";
            String strOptions = strSelect + strTemplate;
            String metadataType = "SoftwareComponent";
            List components = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposId, metadataType, 10632, strOptions, false);
            for (SoftwareComponent component : components) {
                String SASFSscName = this.getSASFoundationServicesDeploymentSoftwareComponentName(component);
                if (SASFSscName != null) {
                    strOptions = "<XMLSELECT search=\"*[@Name ='" + SASFSscName + "']\"/>";
                    metadataType = "SoftwareComponent";
                    List serviceDeployments = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposId, metadataType, 10632, strOptions, false);
                    for (SoftwareComponent serviceDeployment : serviceDeployments) {
                        ServiceDeploymentDeleter sdd = new ServiceDeploymentDeleter(serviceDeployment);
                        sdd.delete();
                    }
                }
                AssociationList componentTrees = component.getTrees();
                component.delete();
                for (Tree tree : componentTrees) {
                    try {
                        this.deleteAnalyticsTrees(tree);
                    }
                    catch (MdException mdException) {}
                }
                store.updatedMetadataAll();
            }
        }
        catch (Exception e) {
            this.logger.error(RB.getStringResource("OneOffUpgradeHelper.RemoveAnalyticsPlatformMetadata.Error.txt"));
            this.ctx.setError(true);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException remoteException) {}
        }
    }

    void removeEventSubscribersTree(Repository repository) {
        MdObjectStore store = null;
        Tree eventSubsFolder = null;
        this.logger.info(RB.getStringResource("OneOffUpgradeHelper.RemoveEventSubscribersTree.txt"));
        try {
            store = this.ctx.getFactory().createObjectStore();
            int flags = 2432;
            String strOptions = "<XMLSELECT search=\"*[@Name='Event Subscribers'][ParentTree/*[@Name='Subscribers']/ParentTree/*[@Name='Publishing']/ParentTree/*[@Name='System']/SoftwareComponents/*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']]\" />";
            List trees = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Tree", 2432, strOptions, false);
            if (trees == null || trees.size() <= 0) {
                return;
            }
            eventSubsFolder = (Tree)trees.get(0);
            if (eventSubsFolder != null && eventSubsFolder.getMembers().size() == 0 && eventSubsFolder.getSubTrees().size() == 0) {
                eventSubsFolder.delete();
                eventSubsFolder.updateMetadataAll();
            }
            store.dispose();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
    }

    private String getSASFoundationServicesDeploymentSoftwareComponentName(SoftwareComponent scomp) throws RemoteException, MdException {
        HashMap publicProperties = new HashMap();
        ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)scomp, publicProperties, null);
        return (String)publicProperties.get("server.apcore.services.deployment.name");
    }

    private void deleteAnalyticsTrees(Tree tree) throws RemoteException, MdException {
        String ANALYTICS_PARENT_TREE = "SAS Analytics Platform";
        if ("SAS Analytics Platform".equalsIgnoreCase(tree.getName())) {
            if (tree.getMembers().isEmpty() && tree.getSubTrees().isEmpty()) {
                tree.delete();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePublicTypeInformation(Repository repository) {
        Node firstNode;
        this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.AddTypeVersion.txt", (Object)"UsageVersion", (Object)"PublicType"));
        org.w3c.dom.Document doc = null;
        InputStream is = null;
        try {
            is = OneOffUpgradeHelper.class.getResourceAsStream("/com/sas/svcs/metadata/mgmt/impl/repository/data/PublicObjectRules.xml");
            if (is == null) {
                throw new IllegalStateException("InputStream for PublicObjectRules file is null");
            }
            doc = XMLUtil.convertInputSourceToDocument((InputSource)new InputSource(is));
        }
        catch (Exception e) {
            this.ctx.setError(true);
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.ParseRulesDefinitionError.fmt.txt", (Object)e.getLocalizedMessage()));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        if (doc != null && (firstNode = doc.getFirstChild()) != null) {
            NodeList rulesList = firstNode.getChildNodes();
            int length = rulesList.getLength();
            for (int index = 0; index < length; ++index) {
                Node childNode = rulesList.item(index);
                if (!"Rule".equalsIgnoreCase(childNode.getNodeName())) continue;
                NamedNodeMap attrs = childNode.getAttributes();
                String publicType = attrs.getNamedItem("PublicType").getNodeValue();
                String metadataType = attrs.getNamedItem("MetadataType").getNodeValue();
                String usageVersion = attrs.getNamedItem("UsageVersion").getNodeValue();
                String matchCriteria = attrs.getNamedItem("Match").getNodeValue();
                this.updatePublicTypeAttributes(repository, publicType, metadataType, matchCriteria, usageVersion);
            }
        }
    }

    private void updatePublicTypeAttributes(Repository repository, String publicType, String metadataType, String match, String usageVersion) {
        String SELECT = "<XMLSELECT search=\"" + StringEscapeUtils.escapeXml((String)match) + "\"/>";
        int FLAGS = 384;
        if (repository == null) {
            FLAGS |= 0x2000;
            repository = this.repositoryService.getFoundationRepository();
        }
        try {
            MdOMIUtil omiUtil = this.ctx.getFactory().getOMIUtil();
            List objects = omiUtil.getFastMetadataObjects(metadataType, repository.getId(), SELECT, FLAGS);
            StringBuffer updateXmlBuffer = new StringBuffer(1000);
            for (FastMetadata object : objects) {
                updateXmlBuffer.append("<");
                updateXmlBuffer.append(object.getAttribute("MetadataObjectType"));
                updateXmlBuffer.append(" Id='");
                updateXmlBuffer.append(object.getAttribute("Id"));
                updateXmlBuffer.append("' PublicType='");
                updateXmlBuffer.append(publicType);
                if (usageVersion != null) {
                    updateXmlBuffer.append("' UsageVersion='");
                    updateXmlBuffer.append(usageVersion);
                }
                updateXmlBuffer.append("' />");
                if (updateXmlBuffer.length() <= 50000) continue;
                omiUtil.updateMetadata(updateXmlBuffer.toString());
                updateXmlBuffer.setLength(0);
            }
            if (updateXmlBuffer.length() > 0) {
                omiUtil.updateMetadata(updateXmlBuffer.toString());
            }
            if (!objects.isEmpty()) {
                TypeDescriptorInterface tdi = this.ctx.getServer().getTypeDescriptor(publicType);
                String label = tdi == null ? publicType : tdi.getType();
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.ObjectCount.fmt.txt", (Object)new Integer(objects.size()), (Object)label));
            }
        }
        catch (RemoteException e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.ApplyingPublicObjectTypeUsageRules.Error.txt", (Object)publicType, (Object)e.getLocalizedMessage()));
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.ApplyingPublicObjectTypeUsageRules.Error.txt", (Object)publicType, (Object)e.getLocalizedMessage()));
            this.ctx.setError(true);
        }
    }

    void createPublicObjects(Repository repository) {
        if (repository.isFoundation() || repository.isCustom()) {
            String BILINEAGE_REPOS_NAME = "BILineage";
            if (repository.isCustom() && "BILineage".equalsIgnoreCase(repository.getName()) && "BILineage".equalsIgnoreCase(repository.getDescription())) {
                return;
            }
            this.logger.info(RB.getStringResource("OneOffUpgradeHelper.CreatingPublicObjects.txt"));
            UserContextInterface userContext = this.ctx.getUser();
            try {
                RepositoryInterface ri;
                ServerInterface server;
                InformationServiceInterface infoService = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
                if (userContext != null && infoService != null && (server = userContext.getAuthServer()) != null && (ri = server.getRepository(repository.getName())) instanceof OMIRepositoryInterface) {
                    SecuredDataFolderUtil.makeSecuredLibrariesFolder((InformationServiceInterface)infoService, (OMIRepositoryInterface)((OMIRepositoryInterface)ri));
                }
            }
            catch (ServiceException e) {
                this.ctx.setError(true);
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.AddSecuredLibrariesFolder.Error.fmt.txt", (Object)e.getLocalizedMessage()));
            }
            catch (RemoteException e) {
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.AddSecuredLibrariesFolder.Error.fmt.txt", (Object)e.getLocalizedMessage()));
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertAuthorResponsibilities(Repository repository) {
        this.logger.info(RB.getStringResource("OneOffUpgradeHelper.ConvertAuthorInformation.txt"));
        MdObjectStore store = null;
        try {
            MdFactory factory = this.ctx.getFactory();
            store = factory.createObjectStore(null, "UpgradeStore:convertAuthors");
            int flags = 404;
            String search = "<XMLSelect search=\"*[@Name='Author' and @Role='owner']\"/>";
            String template = "<Templates><ResponsibleParty Name=\"\" Role=\"\"><Persons/><Objects/></ResponsibleParty><Person Name=\"\"/><PrimaryType Name=\"\" PublicType=\"\"/></Templates>";
            List authors = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "ResponsibleParty", 404, "<XMLSelect search=\"*[@Name='Author' and @Role='owner']\"/><Templates><ResponsibleParty Name=\"\" Role=\"\"><Persons/><Objects/></ResponsibleParty><Person Name=\"\"/><PrimaryType Name=\"\" PublicType=\"\"/></Templates>");
            if (authors != null && !authors.isEmpty()) {
                List<String> attributes = Arrays.asList("Name", "PublicType");
                List<String> associations = Arrays.asList("ResponsibleParties");
                int objectFlags = 260;
                String objectTemplate = "<Templates><ResponsibleParty Name=\"\" Role=\"\"><Persons/></ResponsibleParty><Person Name=\"\"/></Templates>";
                for (ResponsibleParty author : authors) {
                    Root[] objectArray;
                    AssociationList objects;
                    AssociationList identities = author.getPersons();
                    if (identities.isEmpty() || (objects = author.getObjects()).isEmpty()) continue;
                    Identity identity = (Identity)identities.get(0);
                    String identityName = identity.getName();
                    int count = 0;
                    for (Root object : objectArray = objects.toArray(new Root[objects.size()])) {
                        if (!(object instanceof PrimaryType)) continue;
                        object = (PrimaryType)factory.getOMIUtil().getMetadataAllDepths((CMetadata)object, attributes, associations, "<Templates><ResponsibleParty Name=\"\" Role=\"\"><Persons/></ResponsibleParty><Person Name=\"\"/></Templates>", 260);
                        String createdBy = MdResponsibilitiesUtil.getCreatedByValue((PrimaryType)((PrimaryType)object));
                        if (createdBy == null || createdBy.isEmpty()) {
                            MdResponsibilitiesUtil.setCreatedByValue((CMetadata)object, (String)identityName);
                        }
                        object.getResponsibleParties().remove((Object)author);
                        if (++count < 20) continue;
                        store.updatedMetadataAll();
                        count = 0;
                    }
                    if (count <= 0) continue;
                    store.updatedMetadataAll();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.ConvertAuthorInformation.Error.fmt.txt", (Object)e.getLocalizedMessage()));
            this.ctx.setError(true);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException remoteException) {}
        }
    }

    int deleteObjects(Repository repository, String metadataType, String match) {
        return this.deleteObjects(repository, metadataType, match, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int deleteObjects(Repository repository, String metadataType, String match, String deleteTemplate) {
        String SELECT = "<XMLSELECT search=\"" + StringEscapeUtils.escapeXml((String)match) + "\"/>";
        int FLAGS = 384;
        if (repository == null) {
            FLAGS |= 0x2000;
            repository = this.repositoryService.getFoundationRepository();
        }
        try {
            MdOMIUtil omiUtil = this.ctx.getFactory().getOMIUtil();
            List objects = omiUtil.getFastMetadataObjects(metadataType, repository.getId(), SELECT, FLAGS);
            if (!objects.isEmpty()) {
                HashMap<String, String> objectMap = new HashMap<String, String>();
                for (FastMetadata object : objects) {
                    if (deleteTemplate != null && !deleteTemplate.isEmpty()) {
                        MdObjectStore store = this.ctx.getFactory().createObjectStore();
                        try {
                            CMetadata obj = this.ctx.getFactory().createComplexMetadataObject(store, object.getAttribute("Name"), object.getAttribute("MetadataObjectType"), object.getAttribute("Id"));
                            this.ctx.getFactory().deletePublicObject(obj, deleteTemplate);
                            continue;
                        }
                        finally {
                            store.dispose();
                            continue;
                        }
                    }
                    objectMap.put(object.getAttribute("Id"), object.getAttribute("MetadataObjectType"));
                }
                if (!objectMap.isEmpty()) {
                    omiUtil.deleteMetadataObjects(objectMap);
                }
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.DeleteObject.Info.txt", (Object)Integer.toString(objects.size()), (Object)metadataType));
            }
            return objects.size();
        }
        catch (MdException e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.DeleteObject.Error.txt", (Object)metadataType));
            this.ctx.setError(true);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    void upgradeSecurityDisplayNamesAndDescriptions(Repository repository, RepositoryHelper repositoryHelper) {
        try {
            this.upgradeACTDescriptions(repository, repositoryHelper);
            if (repository.isFoundation()) {
                this.upgradeRoleAttributes(repository);
                this.upgradeGroupDescriptions(repository);
            }
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.UpgradeSecurityDisplayNamesAndDescriptions.Exception.txt", (Object)e.getMessage()));
            this.ctx.setError(true);
        }
    }

    private void upgradeACTDescriptions(Repository repository, RepositoryHelper repositoryHelper) throws Exception {
        String defaultACTname = RB.getStringResource("RepositoryHelper.DefaultACT.Name.txt");
        String defaultACTdesc = RB.getStringResource("RepositoryHelper.DefaultACT.Desc.fmt.txt");
        String[][] DefaultACTAttributes = new String[][]{{"DESC", defaultACTdesc}};
        String privateUFACTname = RB.getStringResource("RepositoryHelper.privatefolderACT.Name.notrans");
        String privateUFACTdesc = RB.getStringResource("RepositoryHelper.privatefolderACT.Desc.fmt.txt");
        String[][] privateACTAttributes = new String[][]{{"DESC", privateUFACTdesc}};
        String sasAdminSettingsACTname = RB.getStringResource("RepositoryHelper.SASAdminACT.Name.notrans");
        String sasAdminSettingsACTdesc = RB.getStringResource("RepositoryHelper.SASAdminACT.Desc.fmt.txt");
        String[][] sasAdminSettingsACTAttributes = new String[][]{{"DESC", sasAdminSettingsACTdesc}};
        ISecurityAdmin iSecAdmin = this.ctx.getFactory().getConnection().MakeISecurityAdminConnection(this.ctx.getFactory().getConnection().getCMRHandle());
        if (iSecAdmin == null) {
            throw new MdException(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error3.txt"));
        }
        String defaultActId = repositoryHelper.getActId(iSecAdmin, defaultACTname, repository.getShortId());
        String privateActId = "";
        String sasAdminActId = "";
        if (repository.isFoundation()) {
            privateActId = repositoryHelper.getActId(iSecAdmin, privateUFACTname, repository.getShortId());
            sasAdminActId = repositoryHelper.getActId(iSecAdmin, sasAdminSettingsACTname, repository.getShortId());
        }
        try {
            if (defaultActId.length() > 0) {
                this.updateACTAttributes(iSecAdmin, defaultActId, DefaultACTAttributes);
            }
            if (repository.isFoundation()) {
                if (privateActId.length() > 0) {
                    this.updateACTAttributes(iSecAdmin, privateActId, privateACTAttributes);
                }
                if (sasAdminActId.length() > 0) {
                    this.updateACTAttributes(iSecAdmin, sasAdminActId, sasAdminSettingsACTAttributes);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.UpdateACTattributes.Exception.txt", (Object)e.getMessage()));
        }
    }

    private void updateACTAttributes(ISecurityAdmin iSecAdmin, String actId, String[][] attributes) throws Exception {
        String strACTObj = "OMSOBJ:AccessControlTemplate/" + actId;
        iSecAdmin.SetAccessControlTemplateAttribs("", strACTObj, attributes);
    }

    private void upgradeRoleAttributes(Repository repository) throws RemoteException, MdException {
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        int flags = 0x10000188;
        String options = "<XMLSELECT search=\"@Name = 'META: Unrestricted Users Role' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' \"/>";
        List identityRoles = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "IdentityGroup", flags, options, false);
        for (int i = 0; i < identityRoles.size(); ++i) {
            IdentityGroup role = (IdentityGroup)identityRoles.get(i);
            if (role.getName().equals("META: Unrestricted Users Role")) {
                role.setDisplayName(RB.getStringResource("RepositoryHelper.UnrestrictedUsersRole.DisplayName.txt"));
                role.setDesc(RB.getStringResource("RepositoryHelper.UnrestrictedUsersRole.Description.txt"));
                continue;
            }
            if (role.getName().equals("META: User and Group Administrators Role")) {
                role.setDisplayName(RB.getStringResource("RepositoryHelper.UserAdministratorsRole.DisplayName.txt"));
                role.setDesc(RB.getStringResource("RepositoryHelper.UserAdministratorsRole.Description.txt"));
                continue;
            }
            if (!role.getName().equals("META: Operators Role")) continue;
            role.setDisplayName(RB.getStringResource("RepositoryHelper.OperatorsRole.DisplayName.txt"));
            role.setDesc(RB.getStringResource("RepositoryHelper.OperatorsRole.Description.txt"));
        }
        store.updatedMetadataAll();
        store.dispose();
    }

    private void upgradeGroupDescriptions(Repository repository) throws RemoteException, MdException {
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        int flags = 0x10000188;
        String options = "<XMLSELECT search=\"@Name = 'SASUSERS' OR @Name = 'PUBLIC' OR @Name = 'SASAdministrators' OR @Name = 'SAS System Services' \"/>";
        List identityGroups = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "IdentityGroup", flags, options, false);
        for (int i = 0; i < identityGroups.size(); ++i) {
            IdentityGroup group = (IdentityGroup)identityGroups.get(i);
            if (group.getName().equals("SASUSERS")) {
                group.setDesc(RB.getStringResource("RepositoryHelper.SASUSERS.Description.txt"));
                continue;
            }
            if (group.getName().equals("PUBLIC")) {
                group.setDesc(RB.getStringResource("RepositoryHelper.PUBLIC.Description.txt"));
                continue;
            }
            if (group.getName().equals("SASAdministrators")) {
                group.setDisplayName(RB.getStringResource("RepositoryHelper.SASAdministrators.DisplayName.txt"));
                group.setDesc(RB.getStringResource("RepositoryHelper.SASAdministrators.Description.txt"));
                continue;
            }
            if (!group.getName().equals("SAS System Services")) continue;
            group.setDisplayName(RB.getStringResource("RepositoryHelper.SASSystemServices.DisplayName.txt"));
            group.setDesc(RB.getStringResource("RepositoryHelper.SASSystemServices.Description.txt"));
        }
        store.updatedMetadataAll();
        store.dispose();
    }

    void upgradePermissionsOnUserHomeFolders(Repository repository) {
        block23: {
            MdObjectStore store = null;
            List<FastMetadata> persons = null;
            this.logger.info(RB.getStringResource("OneOffUpgradeHelper.UpgradePermissionsOnUserHomeFolders.txt"));
            try {
                store = this.ctx.getFactory().createObjectStore();
                MdOMIUtil omiUtil = this.ctx.getFactory().getOMIUtil();
                try {
                    persons = this.getPersonObjects(repository);
                }
                catch (MdException me) {
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.QueryPersons.Error.txt", (Object)me.getMessage()));
                    this.ctx.setError(true);
                }
                if (persons == null) break block23;
                ISecurityAdmin iSecAdmin = null;
                try {
                    iSecAdmin = this.ctx.getFactory().getConnection().MakeISecurityAdminConnection(this.ctx.getFactory().getConnection().getCMRHandle());
                }
                catch (MdException e) {
                    iSecAdmin = null;
                }
                if (iSecAdmin == null) {
                    this.logger.error(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error9.txt"));
                    this.ctx.setError(true);
                    return;
                }
                for (FastMetadata person : persons) {
                    String personName = person.getAttribute("Name");
                    try {
                        Tree myFolder = omiUtil.getUserHomeFolder(store, personName, "My Folder", "", 0, false);
                        this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.GrantPermissionsOnFolder.DebugInfo.txt", (Object)myFolder.getName(), (Object)personName));
                        this.addGrantPermissionsonFolder(myFolder, personName, iSecAdmin);
                    }
                    catch (MdException myFolder) {
                        // empty catch block
                    }
                    try {
                        Tree appData = omiUtil.getUserHomeFolder(store, personName, "Application Data", "", 0, false);
                        this.logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.GrantPermissionsOnFolder.DebugInfo.txt", (Object)appData.getName(), (Object)personName));
                        this.addGrantPermissionsonFolder(appData, personName, iSecAdmin);
                    }
                    catch (MdException mdException) {}
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException remoteException) {}
            }
        }
    }

    private List<FastMetadata> getPersonObjects(Repository repository) throws MdException {
        int FLAGS = 264;
        String OPTIONS = "<Templates><Person Name=\"\"/></Templates>";
        List persons = null;
        try {
            persons = this.ctx.getFactory().getOMIUtil().getFastMetadataObjects("Person", repository.getId(), "<Templates><Person Name=\"\"/></Templates>", 264);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return persons;
    }

    private void addGrantPermissionsonFolder(Tree folder, String personName, ISecurityAdmin iSecAdmin) {
        String folderName = "";
        try {
            folderName = folder.getName();
            String strResourceId = "OMSOBJ:Tree/" + folder.getFQID();
            StringHolder shTransContext = new StringHolder();
            iSecAdmin.BeginTransactionContext(strResourceId, 0, shTransContext);
            String[][] CreatorAuths = new String[][]{{"Person", personName, "G", "Administer", ""}, {"Person", personName, "G", "Create", ""}, {"Person", personName, "G", "Delete", ""}, {"Person", personName, "G", "Execute", ""}, {"Person", personName, "G", "Update", ""}, {"Person", personName, "G", "Write", ""}};
            iSecAdmin.SetAuthorizationsOnObj(shTransContext.value, "", 0, CreatorAuths);
            iSecAdmin.EndTransactionContext(shTransContext.value, strResourceId, 1);
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"OneOffUpgradeHelper.GrantPermissionsOnFolder.Error.txt", (Object)folderName, (Object)personName, (Object)e.getMessage()));
            this.ctx.setError(true);
        }
    }
}

