/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.repository;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

class LocalizedResourceUtility {
    private static final String PREFIX_XML = ".xml";
    private static final int MAX_FILE_SEARCHED = 3;

    LocalizedResourceUtility() {
    }

    public static URL urlFromFile(String file) throws IOException {
        return LocalizedResourceUtility.urlFromFile(file, Locale.getDefault());
    }

    public static URL urlFromFile(String file, ClassLoader classLoader) throws IOException {
        return LocalizedResourceUtility.urlFromFile(file, Locale.getDefault(), classLoader);
    }

    public static URL urlFromFile(String file, Locale locale) throws IOException {
        return LocalizedResourceUtility.urlFromFile(file, locale, null);
    }

    public static URL urlFromFile(String file, Locale locale, ClassLoader classLoader) throws IOException {
        URL url = null;
        String strTemp = LocalizedResourceUtility.FindLocalizedXMLResource(file, locale, classLoader);
        if (strTemp != null) {
            file = strTemp;
        }
        if ((url = classLoader == null ? ClassLoader.getSystemResource(file) : classLoader.getResource(file)) == null) {
            url = new URL("file:///" + file);
        }
        return url;
    }

    public static URL urlFromSpec(String spec) throws IOException {
        URL url = null;
        url = new URL(spec);
        return url;
    }

    private static String FindLocalizedXMLResource(String file, Locale locale, ClassLoader classLoader) {
        String fileName = null;
        int lastXMLPrefix = file.lastIndexOf(PREFIX_XML);
        if (lastXMLPrefix <= 0) {
            return null;
        }
        if (lastXMLPrefix == file.length() - 4) {
            file = file.substring(0, lastXMLPrefix);
        }
        List<String> langList = LocalizedResourceUtility.calculateFileName(file, locale);
        for (String lang : langList) {
            String locFile = lang + PREFIX_XML;
            URL langFileUrl = null;
            langFileUrl = classLoader == null ? ClassLoader.getSystemResource(locFile) : classLoader.getResource(locFile);
            if (langFileUrl == null) continue;
            fileName = locFile;
        }
        return fileName;
    }

    private static List<String> calculateFileName(String file, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(file);
        temp.append('_');
        temp.append(language);
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }
}

