/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.backup;

import com.sas.framework.annotation.services.Publishable;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.client.Backup;
import com.sas.svcs.metadata.mgmt.client.BackupConfiguration;
import com.sas.svcs.metadata.mgmt.client.BackupDetails;
import com.sas.svcs.metadata.mgmt.client.BackupOptions;
import com.sas.svcs.metadata.mgmt.client.BackupSchedule;
import com.sas.svcs.metadata.mgmt.client.CustomRepository;
import com.sas.svcs.metadata.mgmt.client.FoundationRepository;
import com.sas.svcs.metadata.mgmt.client.MetadataBackupService;
import com.sas.svcs.metadata.mgmt.client.MetadataMgmtException;
import com.sas.svcs.metadata.mgmt.client.MetadataServerService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.ProjectRepository;
import com.sas.svcs.metadata.mgmt.client.Recovery;
import com.sas.svcs.metadata.mgmt.client.RecoveryDetails;
import com.sas.svcs.metadata.mgmt.client.RecoveryOptions;
import com.sas.svcs.metadata.mgmt.client.RepositoryMgr;
import com.sas.svcs.metadata.mgmt.client.ServerState;
import com.sas.svcs.metadata.mgmt.impl.AbstractMetadataManagementServiceImpl;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.backup.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service(value="MetadataBackupService")
@Publishable
public final class MetadataBackupServiceImpl
extends AbstractMetadataManagementServiceImpl
implements MetadataBackupService {
    private static final long BACKUP_START_TIMEOUT = 600000L;
    private static final long BACKUP_ACTIVE_TIMEOUT = 600000L;
    private static final long RECOVERY_START_TIMEOUT = 600000L;
    private static final long RECOVERY_ACTIVE_TIMEOUT = 600000L;
    private static final long POLL_DELAY = 500L;
    private final Logger logger = LogManager.getLogger(MetadataBackupService.class);
    @Autowired
    private MetadataServerService serverService;
    private final String BACKUP_STATUS = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/>";
    private final SimpleDateFormat iso8601format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final SimpleDateFormat rollForwardFormat = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.ENGLISH);

    public MetadataBackupServiceImpl() {
        this.rollForwardFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public Backup backup(BackupOptions backupOptions) {
        this.logger.debug("backup: begin");
        RequestContext ctx = this.getRequestContext();
        Backup previousBackup = this.getMostRecentBackup();
        StringBuffer request = new StringBuffer();
        request.append("<Backup");
        if (backupOptions.getComment() != null) {
            request.append(" Comment='");
            request.append(StringEscapeUtils.escapeXml((String)backupOptions.getComment()));
            request.append("'");
        }
        if (backupOptions.getRegressionTestingDateTimeSeed() != null) {
            request.append(" RegressionTestingDateTime='");
            request.append(StringEscapeUtils.escapeXml((String)backupOptions.getRegressionTestingDateTimeSeed()));
            request.append("'");
        }
        if (backupOptions.isReorganizeRepositories()) {
            request.append(" Reorg='Yes'");
        }
        request.append("/>");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("backup: " + request.toString());
        }
        try {
            ctx.getIServer().Refresh(request.toString());
        }
        catch (GenericError e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Backup backup = this.waitForNewBackup(previousBackup);
        if (!backupOptions.isAsynchronous()) {
            backup = this.waitForBackupCompletion(backup);
        }
        if (backup.getStatus() == Operation.Status.ACTIVE) {
            this.logger.info(RB.getStringResource("MetadataBackupService.BackupStarted.log"));
        } else if (backup.getStatus() == Operation.Status.SUCCESS) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataBackupService.BackupCompleted.fmt.log", (Object)backup.getName()));
        } else {
            this.logger.info(RB.getStringResource("MetadataBackupService.BackupFailed.log"));
        }
        return backup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Recovery recover(Backup backup, RecoveryOptions recoveryOptions) {
        if (backup == null) {
            throw new IllegalArgumentException(RB.getStringResource("MetadataBackupService.Recovery.NoBackupSpecified.txt"));
        }
        if (backup.getName() == null && backup.getDirectory() == null) {
            throw new IllegalArgumentException(RB.getStringResource("MetadataBackupService.Recovery.BackupSpecifiedInvalid.txt"));
        }
        this.logger.debug("recover: begin recovery of backup " + backup.getName());
        RequestContext ctx = this.getRequestContext();
        if (backup.getName() != null && backup.getName() != "") {
            this.validateBackup(backup);
            if (backup.isOffline()) {
                throw new RuntimeException(RB.getStringResource("MetadataBackupService.UnableToRecoverOfflineBackup.log"));
            }
            if (!backup.isAvailable() && recoveryOptions.isVerify()) {
                throw new RuntimeException(RB.getStringResource("MetadataBackupService.UnableToRecoverInvalidBackup.log"));
            }
        }
        Backup previousBackup = this.getMostRecentBackup();
        Recovery previousRecovery = this.getMostRecentRecovery();
        StringBuffer request = new StringBuffer();
        request.append("<Recover BackupPath='");
        request.append(StringEscapeUtils.escapeXml((String)backup.getDirectory()));
        request.append("'");
        if (recoveryOptions.getComment() != null) {
            request.append(" Comment='");
            request.append(StringEscapeUtils.escapeXml((String)recoveryOptions.getComment()));
            request.append("'");
        }
        if (recoveryOptions.isIncludeConfig()) {
            try {
                if (this.serverService.isClusterConfigured()) {
                    throw new IllegalArgumentException(RB.getStringResource("MetadataBackupService.Recovery.Cluster.IllegalConfigOption.txt"));
                }
            }
            catch (MetadataMgmtException e) {
                throw new RuntimeException(e.getMessage());
            }
            request.append(" IncludeAllConfigFiles='Y'");
        }
        if (recoveryOptions.getPauseComment() != null) {
            request.append(" PauseComment='");
            request.append(StringEscapeUtils.escapeXml((String)recoveryOptions.getPauseComment()));
            request.append("'");
        }
        if (recoveryOptions.isReorganizeRepositories()) {
            request.append(" Reorg='Yes'");
        }
        if (recoveryOptions.getRollForward() != null) {
            String rollForward;
            request.append(" RollForward='");
            SimpleDateFormat simpleDateFormat = this.rollForwardFormat;
            synchronized (simpleDateFormat) {
                rollForward = this.rollForwardFormat.format(recoveryOptions.getRollForward());
            }
            request.append(StringEscapeUtils.escapeXml((String)rollForward));
            request.append("'");
        }
        if (!recoveryOptions.isVerify()) {
            request.append(" IgnoreVerify='Y'");
        }
        request.append("/>");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("recover: " + request.toString());
        }
        try {
            ctx.getIServer().Refresh(request.toString());
        }
        catch (GenericError e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Recovery recovery = this.waitForNewRecovery(previousRecovery);
        if (!recoveryOptions.isAsynchronous()) {
            recovery = this.waitForRecoveryCompletion(recovery);
            Backup recoveryBackup = this.waitForNewBackup(previousBackup);
            recoveryBackup = this.waitForBackupCompletion(recoveryBackup);
        }
        if (recovery != null) {
            if (recovery.getStatus() == Operation.Status.ACTIVE) {
                this.logger.info(RB.getStringResource("MetadataBackupService.RecoveryStarted.log"));
            } else if (recovery.getStatus() == Operation.Status.SUCCESS) {
                this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataBackupService.RecoveryCompleted.fmt.log", (Object)recovery.getName()));
            } else {
                this.logger.warn(RB.getStringResource("MetadataBackupService.RecoveryFailed.log"));
            }
        } else {
            this.logger.warn(RB.getStringResource("MetadataBackupService.RecoveryNotFound.log"));
        }
        return recovery;
    }

    public BackupConfiguration getBackupConfiguration() {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<BackupConfiguration BackupLocation='' RunScheduledBackups='' DaysToRetainBackups=''/>";
        String SCHEDULEREQUEST = "<Schedule Event='Backup' Weekday1='' Weekday2='' Weekday3='' Weekday4='' Weekday5='' Weekday6='' Weekday7=''/>";
        Document response = this.getServerStatus(ctx, "<BackupConfiguration BackupLocation='' RunScheduledBackups='' DaysToRetainBackups=''/>", "");
        BackupConfiguration config = new BackupConfiguration();
        NodeList nodes = response.getElementsByTagName("BackupConfiguration");
        if (nodes.getLength() != 1) {
            throw new RuntimeException(RB.getStringResource("MetadataBackupService.BackupConfiguration.ParseError.txt"));
        }
        Element configElement = (Element)nodes.item(0);
        try {
            config.setBackupPath(configElement.getAttribute("BackupLocation"));
            String runBackups = configElement.getAttribute("RunScheduledBackups");
            if (runBackups.equalsIgnoreCase("Y") || runBackups.isEmpty()) {
                config.setScheduleEnabled(true);
            }
            config.setDaysToRetain(Integer.parseInt(configElement.getAttribute("DaysToRetainBackups")));
            Document response2 = null;
            try {
                response2 = this.getServerStatus(ctx, "<Schedule Event='Backup' Weekday1='' Weekday2='' Weekday3='' Weekday4='' Weekday5='' Weekday6='' Weekday7=''/>", "");
            }
            catch (RuntimeException e) {
                this.logger.debug("Could not retrieve backup schedule" + e.getLocalizedMessage());
            }
            ArrayList<BackupSchedule> schedule = new ArrayList<BackupSchedule>();
            if (response2 != null) {
                nodes = response2.getElementsByTagName("Schedule");
                if (nodes.getLength() != 1) {
                    throw new RuntimeException(RB.getStringResource("MetadataBackupService.BackupConfiguration.Schedule.ParseError.txt"));
                }
                Element scheduleElement = (Element)nodes.item(0);
                int weekday = 1;
                for (BackupSchedule.DayOfWeek dayOfWeek : BackupSchedule.DayOfWeek.values()) {
                    String attr = scheduleElement.getAttribute("Weekday" + Integer.toString(weekday));
                    if (attr.length() > 0) {
                        for (String eventString : attr.split(";")) {
                            BackupSchedule event = new BackupSchedule();
                            event.setDayOfWeek(dayOfWeek);
                            event.setHour(Integer.parseInt(eventString.substring(0, 2)));
                            event.setMinute(Integer.parseInt(eventString.substring(2, 4)));
                            if (eventString.length() > 4 && eventString.charAt(4) == 'R') {
                                event.setReorganizeRepositories(true);
                            }
                            schedule.add(event);
                        }
                    }
                    ++weekday;
                }
            }
            Collections.sort(schedule, new ScheduleComparator());
            config.setScheduledBackups(schedule.toArray(new BackupSchedule[schedule.size()]));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(RB.getStringResource("MetadataBackupService.BackupConfiguration.ParseError.txt"));
        }
        return config;
    }

    public BackupConfiguration setBackupConfiguration(BackupConfiguration backupConfiguration) {
        RequestContext ctx = this.getRequestContext();
        StringBuffer request = new StringBuffer();
        request.append("<BackupConfiguration BackupLocation='");
        request.append(StringEscapeUtils.escapeXml((String)backupConfiguration.getBackupPath()));
        request.append("' RunScheduledBackups='");
        if (backupConfiguration.isScheduleEnabled()) {
            request.append("Y");
        } else {
            request.append("N");
        }
        request.append("' DaysToRetainBackups='");
        request.append(Integer.toString(backupConfiguration.getDaysToRetain()));
        request.append("'/>");
        try {
            ctx.getIServer().Refresh(request.toString());
        }
        catch (GenericError e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        StringBuffer request2 = new StringBuffer();
        String[] schedule = new String[7];
        if (backupConfiguration.getScheduledBackups() != null) {
            for (BackupSchedule event : backupConfiguration.getScheduledBackups()) {
                int day = event.getDayOfweek().ordinal();
                StringBuffer value = new StringBuffer();
                if (schedule[day] != null) {
                    value.append(schedule[day]);
                    value.append(";");
                }
                if (event.getHour() < 10) {
                    value.append("0");
                }
                value.append(Integer.toString(event.getHour()));
                if (event.getMinute() < 10) {
                    value.append("0");
                }
                value.append(Integer.toString(event.getMinute()));
                if (event.isReorganizeRepositories()) {
                    value.append("R");
                }
                schedule[day] = value.toString();
            }
        }
        request2.append("<Schedule Event='Backup");
        for (int day = 0; day < 7; ++day) {
            request2.append("' Weekday");
            request2.append(Integer.toString(day + 1));
            request2.append("='");
            if (schedule[day] == null) continue;
            request2.append(schedule[day]);
        }
        request2.append("'/>");
        try {
            ctx.getIServer().Refresh(request2.toString());
        }
        catch (GenericError e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.getBackupConfiguration();
    }

    public List<Backup> getAvailableBackups() {
        ArrayList<Backup> backups = new ArrayList<Backup>();
        for (Operation result : this.getHistory()) {
            Backup backup;
            if (!(result instanceof Backup) || !(backup = (Backup)result).isAvailable() || backup.isOffline()) continue;
            backups.add(backup);
        }
        return backups;
    }

    public Backup getMostRecentBackup() {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Backup[POSITION()=LAST()]\"/>";
        Document response = null;
        try {
            response = this.getServerStatus(ctx, "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Backup[POSITION()=LAST()]\"/>", "");
        }
        catch (RuntimeException e) {
            this.logger.debug("Could not retrieve latest backup" + e.getLocalizedMessage());
            return null;
        }
        if (response == null) {
            this.logger.debug("Could not retrieve latest backup");
            return null;
        }
        NodeList nodes = response.getElementsByTagName("Backup");
        if (nodes.getLength() <= 1) {
            return null;
        }
        return this.parseBackup((Element)nodes.item(1), (Element)nodes.item(0));
    }

    public Backup getBackupByName(String name) {
        Backup backup = new Backup();
        backup.setName(name);
        return this.refreshBackup(backup);
    }

    public Backup getBackupByDirectory(String directory) {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupManifest BackupPath=\"" + StringEscapeUtils.escapeXml((String)directory) + "\"/>";
        Document response = null;
        try {
            response = this.getServerStatus(ctx, REQUEST, "");
        }
        catch (RuntimeException e) {
            this.logger.debug("Could not retrieve backup by directory" + e.getLocalizedMessage());
            return null;
        }
        if (response == null) {
            this.logger.debug("Could not retrieve backup by directory");
            return null;
        }
        NodeList nodes = response.getElementsByTagName("Backup");
        if (nodes.getLength() <= 1) {
            return null;
        }
        Backup backup = this.parseBackup((Element)nodes.item(1), (Element)nodes.item(0));
        backup.setDirectory(directory);
        this.validateBackup(backup);
        return backup;
    }

    public BackupDetails getBackupDetailsByName(String name) {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupManifest BackupName=\"" + StringEscapeUtils.escapeXml((String)name) + "\"/>";
        return this.parseBackupDetails(this.getServerStatus(ctx, REQUEST, ""));
    }

    public BackupDetails getBackupDetailsByDirectory(String directory) {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupManifest BackupPath=\"" + StringEscapeUtils.escapeXml((String)directory) + "\"/>";
        return this.parseBackupDetails(this.getServerStatus(ctx, REQUEST, ""));
    }

    public Backup refreshBackup(Backup originalBackup) {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Backup[@Name='" + originalBackup.getName() + "']\"/>\n";
        Document response = null;
        try {
            response = this.getServerStatus(ctx, REQUEST, "");
        }
        catch (RuntimeException e) {
            this.logger.debug("Could not retrieve backup" + e.getLocalizedMessage());
            return null;
        }
        if (response == null) {
            this.logger.debug("Could not retrieve backup");
            return null;
        }
        NodeList nodes = response.getElementsByTagName("Backup");
        if (nodes.getLength() <= 1) {
            return null;
        }
        Backup backup = this.parseBackup((Element)nodes.item(1), (Element)nodes.item(0));
        if (originalBackup.getDirectory() != null) {
            backup.setDirectory(originalBackup.getDirectory());
        }
        return backup;
    }

    public Recovery getMostRecentRecovery() {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Recovery[POSITION()=LAST()]\"/>";
        Document response = null;
        try {
            response = this.getServerStatus(ctx, "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Recovery[POSITION()=LAST()]\"/>", "");
        }
        catch (RuntimeException e) {
            this.logger.debug("Could not retrieve latest recovery" + e.getLocalizedMessage());
            return null;
        }
        if (response == null) {
            this.logger.debug("Could not retrieve latest recovery");
            return null;
        }
        Element running = (Element)response.getElementsByTagName("Backup").item(0);
        NodeList nodes = response.getElementsByTagName("Recovery");
        if (nodes.getLength() == 0) {
            return null;
        }
        return this.parseRecovery((Element)nodes.item(0), running);
    }

    public RecoveryDetails getRecoveryDetailsByName(String name) {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerRecoveryManifest RecoveryName=\"" + StringEscapeUtils.escapeXml((String)name) + "\"/>";
        return this.parseRecoveryDetails(this.getServerStatus(ctx, REQUEST, ""));
    }

    public RecoveryDetails getRecoveryDetailsByDirectory(String directory) {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerRecoveryManifest RecoveryPath=\"" + StringEscapeUtils.escapeXml((String)directory) + "\"/>";
        return this.parseRecoveryDetails(this.getServerStatus(ctx, REQUEST, ""));
    }

    public Recovery getRecoveryByName(String name) {
        Recovery recovery = new Recovery();
        recovery.setName(name);
        return this.refreshRecovery(recovery);
    }

    public Recovery refreshRecovery(Recovery originalRecovery) {
        String REQUEST;
        RequestContext ctx = this.getRequestContext();
        Document response = this.getServerStatus(ctx, REQUEST = "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/><MetadataServerBackupHistory XPath=\"MetadataServerBackupManifest/Backups/Recovery[@Name='" + originalRecovery.getName() + "']\"/>", "");
        if (response == null) {
            this.logger.debug("Could not refresh recovery");
            return null;
        }
        Element running = (Element)response.getElementsByTagName("Backup").item(0);
        NodeList nodes = response.getElementsByTagName("Recovery");
        if (nodes.getLength() == 0) {
            return null;
        }
        return this.parseRecovery((Element)nodes.item(0), running);
    }

    public List<Operation> getHistory() {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<MetadataServerBackupHistory/>";
        Document response = this.getServerStatus(ctx, "<MetadataServerBackupHistory/>", "");
        ArrayList<Operation> history = new ArrayList<Operation>();
        NodeList nodes = response.getElementsByTagName("Backups");
        if (nodes.getLength() != 1) {
            throw new RuntimeException(RB.getStringResource("MetadataBackupService.Backups.ParseError.txt"));
        }
        Node historyNode = nodes.item(0).getFirstChild();
        while (historyNode != null) {
            if (historyNode.getNodeType() != 1) continue;
            Element element = (Element)historyNode;
            if (element.getNodeName().equalsIgnoreCase("Backup")) {
                history.add((Operation)this.parseBackup(element, null));
            } else if (element.getNodeName().equalsIgnoreCase("Recovery")) {
                history.add((Operation)this.parseRecovery(element, null));
            }
            historyNode = historyNode.getNextSibling();
        }
        return history;
    }

    public void addToHistory(Backup backup) {
        RequestContext ctx = this.getRequestContext();
        String name = "Unregistered";
        String REGISTER_BACKUP = " <Status>\n   <Metadata>\n    <MetadataServerBackupHistory \n     BackupPath=\"" + backup.getDirectory() + "\"/>\n   </Metadata>\n   <Options>\n    <VerifyBackups/>\n   </Options>\n  </Status>";
        String REGISTER_BACKUP_OFFLINE = "    <MetadataServerBackupHistory \n     BackupPath=\"" + backup.getDirectory() + "\"/>\n";
        Document doc = null;
        ServerState state = this.serverService.getServerState();
        try {
            doc = state.getAccess() == ServerState.Access.OFFLINE ? this.getServerStatus(ctx, REGISTER_BACKUP_OFFLINE, "<VerifyBackups/>") : ctx.getFactory().getOMIUtil().DoRequest("<EXCLUSIVE_LOCK>" + REGISTER_BACKUP + "</EXCLUSIVE_LOCK>");
        }
        catch (RemoteException e) {
            throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataBackupService.AddToHistory.Failure.fmt.txt", (Object)e));
        }
        catch (MdException e) {
            throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataBackupService.AddToHistory.Failure.fmt.txt", (Object)((Object)e)));
        }
        if (doc != null) {
            Element verifyElement = doc.getDocumentElement();
            NodeList backupElementList = verifyElement.getElementsByTagName("Backup");
            Element thisBackupElement = null;
            int maxIndex = backupElementList.getLength();
            for (int index = 0; index < maxIndex; ++index) {
                Node aNode = backupElementList.item(index);
                short nodeType = aNode.getNodeType();
                String nodeName = new String(aNode.getNodeName());
                if (nodeType != 1 || !nodeName.equals("Backup") || !name.equalsIgnoreCase("Unregistered") && !this.getAttribute("Name", (Element)aNode).equals(name)) continue;
                thisBackupElement = (Element)aNode;
                name = this.getAttribute("Name", thisBackupElement);
                String isValidString = this.getAttribute("Verify", thisBackupElement);
                backup.setAvailable(isValidString.equalsIgnoreCase("Successful"));
                backup.setOffline(isValidString.equalsIgnoreCase("Offline"));
                backup.setVerified(true);
                break;
            }
        } else {
            throw new RuntimeException(RB.getStringResource("MetadataBackupService.AddToHistory.Failure.txt"));
        }
    }

    public void cancelBackup() {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Cancel Backup=\"\"/>";
        try {
            ctx.getIServer().Refresh("<Cancel Backup=\"\"/>");
            Backup backup = this.getMostRecentBackup();
            this.waitForBackupCompletion(backup);
        }
        catch (GenericError e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void cancelRecovery() {
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<Cancel Backup=\"\"/>";
        try {
            ctx.getIServer().Refresh("<Cancel Backup=\"\"/>");
            Recovery recovery = this.getMostRecentRecovery();
            this.waitForRecoveryCompletion(recovery);
        }
        catch (GenericError e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isBackupGuidValid(String backupGUID) {
        Element serverElement;
        String serverGUID = null;
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<MetadataServerBackupManifest/>";
        Document response = this.getServerStatus(ctx, "<MetadataServerBackupManifest/>", "");
        NodeList serverElementsList = response.getElementsByTagName("MetadataServer");
        Element element = serverElement = serverElementsList.getLength() <= 0 ? null : (Element)serverElementsList.item(0);
        if (serverElement == null) {
            return false;
        }
        serverGUID = this.getAttribute("GUID", serverElement);
        return serverGUID != null && backupGUID != null && serverGUID.equals(backupGUID);
    }

    public boolean isBackupClusterGuidValid(String backupClusterGUID) {
        String clusterGUID = this.getBackupManifestClusterGuid();
        return clusterGUID != null && backupClusterGUID != null && clusterGUID.equals(backupClusterGUID);
    }

    private String getBackupManifestClusterGuid() {
        Element serverElement;
        String clusterGUID = null;
        RequestContext ctx = this.getRequestContext();
        String REQUEST = "<MetadataServerBackupManifest/>";
        Document response = this.getServerStatus(ctx, "<MetadataServerBackupManifest/>", "");
        NodeList serverElementsList = response.getElementsByTagName("MetadataServer");
        Element element = serverElement = serverElementsList.getLength() <= 0 ? null : (Element)serverElementsList.item(0);
        if (serverElement != null) {
            clusterGUID = this.getAttribute("ClusterGUID", serverElement);
        }
        return clusterGUID;
    }

    public boolean isMostRecentRecovery(Recovery recovery) {
        Recovery latestRecovery;
        return recovery != null && (latestRecovery = this.getMostRecentRecovery()) != null && recovery.getName().equals(latestRecovery.getName());
    }

    public void validateBackup(Backup backup) {
        if (backup.getStatus() == Operation.Status.ACTIVE) {
            backup.setAvailable(false);
            return;
        }
        if (backup.getDirectory() == null && backup.getName() == null) {
            backup.setAvailable(false);
            return;
        }
        Document doc = this.verifyBackupOnServer(backup);
        if (doc != null) {
            this.processVerification(doc, backup);
        } else {
            backup.setAvailable(false);
        }
    }

    public String getAbsoluteBackupDirectory(Backup backup) {
        if (backup.isOffline()) {
            return "";
        }
        String directory = backup.getDirectory();
        if (directory == null) {
            return "";
        }
        String serverPath = this.serverService.getServerState().getServerPath();
        if (serverPath != null) {
            directory = FilenameUtils.concat((String)serverPath, (String)directory);
            String windowsSeparator = "\\";
            String unixSeparator = "/";
            directory = serverPath.indexOf(unixSeparator) < 0 && serverPath.indexOf(windowsSeparator) > 0 ? FilenameUtils.separatorsToWindows((String)directory) : FilenameUtils.separatorsToUnix((String)directory);
        }
        return directory;
    }

    private Document verifyBackupOnServer(Backup backup) {
        String VERIFY_BACKUP_IN_HISTORY_BY_DIRECTORY = null;
        String VERIFY_BACKUP_IN_HISTORY_BY_NAME = null;
        String VERIFY_BACKUP_BY_MANIFEST = null;
        RequestContext ctx = this.getRequestContext();
        if (backup.getDirectory() == null && backup.getName() == null) {
            return null;
        }
        if (backup.getDirectory() != null) {
            VERIFY_BACKUP_IN_HISTORY_BY_DIRECTORY = "    <MetadataServerBackupHistory \n         XPath=\"MetadataServerBackupManifest/Backups/Backup[@Directory='" + backup.getDirectory() + "']\"/>\n";
            VERIFY_BACKUP_BY_MANIFEST = "    <MetadataServerBackupManifest\n     BackupPath=\"" + backup.getDirectory() + "\"/>\n";
        }
        if (backup.getName() != null) {
            VERIFY_BACKUP_IN_HISTORY_BY_NAME = "    <MetadataServerBackupHistory \n         XPath=\"MetadataServerBackupManifest/Backups/Backup[@Name='" + backup.getName() + "']\"/>\n";
        }
        Document backupDocument = null;
        try {
            if (VERIFY_BACKUP_IN_HISTORY_BY_DIRECTORY != null) {
                backupDocument = this.getServerStatus(ctx, VERIFY_BACKUP_IN_HISTORY_BY_DIRECTORY, "<VerifyBackups/>");
            }
        }
        catch (RuntimeException e) {
            backupDocument = null;
        }
        if (backupDocument == null && backup.getStatus() != Operation.Status.ACTIVE) {
            try {
                if (VERIFY_BACKUP_IN_HISTORY_BY_NAME != null) {
                    backupDocument = this.getServerStatus(ctx, VERIFY_BACKUP_IN_HISTORY_BY_NAME, "<VerifyBackups/>");
                }
            }
            catch (RuntimeException e) {
                backupDocument = null;
            }
            if (backupDocument == null && backup.getStatus() != Operation.Status.ACTIVE && VERIFY_BACKUP_BY_MANIFEST != null) {
                backupDocument = this.getServerStatus(ctx, VERIFY_BACKUP_BY_MANIFEST, "<VerifyBackups/>");
            }
        }
        return backupDocument;
    }

    private Document getServerStatus(RequestContext ctx, String request, String options) {
        try {
            String output = this.serverService.getServerStatus(request, options);
            if (output != null) {
                String xml = "<Metadata>" + output + "</Metadata>";
                return ctx.getFactory().getOMIUtil().parseXML(xml);
            }
            return null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Backup waitForNewBackup(Backup previousBackup) {
        Backup backup;
        block4: {
            String previousBackupName = "None";
            if (previousBackup != null) {
                previousBackupName = previousBackup.getName();
            }
            long totalWait = 0L;
            do {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                totalWait += 500L;
                backup = this.getMostRecentBackup();
                if (backup != null && (!backup.getName().equals(previousBackupName) || backup.getStatus() == Operation.Status.ERROR)) break block4;
            } while (totalWait <= 600000L);
            throw new RuntimeException(RB.getStringResource("MetadataBackupService.BackupStartTimeout.log"));
        }
        return backup;
    }

    private Recovery waitForNewRecovery(Recovery previousRecovery) {
        Recovery recovery;
        String previousRecoveryName = "None";
        if (previousRecovery != null) {
            previousRecoveryName = previousRecovery.getName();
        }
        long totalWait = 0L;
        do {
            if (totalWait > 600000L) {
                throw new RuntimeException(RB.getStringResource("MetadataBackupService.RecoveryStartTimeout.log"));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            totalWait += 500L;
        } while ((recovery = this.getMostRecentRecovery()) == null || recovery.getName().equals(previousRecoveryName) && recovery.getStatus() != Operation.Status.ERROR);
        return recovery;
    }

    private Backup waitForBackupCompletion(Backup backup) {
        long totalWait = 0L;
        while (backup.getStatus() == Operation.Status.ACTIVE) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((totalWait += 500L) > 600000L) {
                throw new RuntimeException(RB.getStringResource("MetadataBackupService.BackupFinishTimeout.log"));
            }
            this.logger.debug("waiting for backup to complete - " + Float.toString(backup.getPercentComplete()) + "%");
            backup = this.getMostRecentBackup();
        }
        this.waitForBackupThreadCompletion();
        return backup;
    }

    private Recovery waitForRecoveryCompletion(Recovery recovery) {
        long totalWait = 0L;
        if (recovery != null) {
            while (recovery.getStatus() == Operation.Status.ACTIVE) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((totalWait += 500L) > 600000L) {
                    throw new RuntimeException(RB.getStringResource("MetadataBackupService.RecoveryFinishTimeout.log"));
                }
                this.logger.debug("waiting for recovery to complete - " + Float.toString(recovery.getPercentComplete()) + "%");
                recovery = this.getMostRecentRecovery();
            }
        }
        return recovery;
    }

    private void waitForBackupThreadCompletion() {
        RequestContext ctx = this.getRequestContext();
        long totalWait = 0L;
        do {
            Document response;
            NodeList nodes;
            if ((nodes = (response = this.getServerStatus(ctx, "<Backup BytesToCopy='' BytesCopied='' IsRunning=''/>", "")).getElementsByTagName("Backup")).getLength() != 1) {
                throw new RuntimeException(RB.getStringResource("MetadataBackupService.Backups.ParseError.txt"));
            }
            if (((Element)nodes.item(0)).getAttribute("IsRunning").startsWith("N")) {
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((totalWait += 500L) <= 600000L);
        throw new RuntimeException(RB.getStringResource("MetadataBackupService.BackupFinishTimeout.log"));
    }

    private Backup parseBackup(Element element, Element running) {
        Backup backup = new Backup();
        this.parseBackup(backup, element, running);
        return backup;
    }

    private void parseBackup(Backup backup, Element element, Element running) {
        try {
            String isRunning;
            backup.setComment(element.getAttribute("Comment"));
            backup.setDirectory(element.getAttribute("Directory"));
            backup.setExpiredDate(this.parseISO8601DateTime(element.getAttribute("Expired")));
            backup.setVerifiedDate(this.parseISO8601DateTime(element.getAttribute("LastVerifyDateTime")));
            String verifiedStatus = element.getAttribute("LastVerifyStatus");
            if (verifiedStatus != "") {
                if (verifiedStatus.equalsIgnoreCase("Successful")) {
                    backup.setOffline(false);
                    backup.setAvailable(true);
                } else if (verifiedStatus.equalsIgnoreCase("Offline")) {
                    backup.setOffline(true);
                    backup.setAvailable(false);
                } else {
                    backup.setOffline(false);
                    backup.setAvailable(false);
                }
                backup.setVerified(true);
            } else {
                backup.setOffline(false);
                backup.setAvailable(true);
                backup.setVerified(false);
            }
            backup.setName(element.getAttribute("Name"));
            backup.setPercentComplete(100.0f);
            backup.setReorganizeRepositories(element.getAttribute("Reorg").equalsIgnoreCase("Y"));
            String size = element.getAttribute("Size");
            if (size.length() > 0) {
                backup.setSize((double)Long.parseLong(size));
            }
            backup.setStartedDate(this.parseISO8601DateTime(element.getAttribute("StartDateTime")));
            backup.setTimeZoneOffset(this.getISO8601DateTimeTimezoneOffset(element.getAttribute("StartDateTime")));
            backup.setUser(element.getAttribute("StartingUserID"));
            Operation.Status status = this.parseStatus(element.getAttribute("Status"));
            backup.setStatus(status);
            backup.setCompletedDate(null);
            if (status == Operation.Status.ERROR || status == Operation.Status.CANCELLED) {
                backup.setAvailable(false);
            }
            if (status == Operation.Status.ACTIVE && running != null && (isRunning = running.getAttribute("IsRunning")).equals("Y")) {
                backup.setPercentComplete(0.0f);
                try {
                    long totalBytes = Long.parseLong(running.getAttribute("BytesToCopy"));
                    long bytesCopied = Long.parseLong(running.getAttribute("BytesCopied"));
                    if (totalBytes > 0L) {
                        backup.setPercentComplete((float)bytesCopied * 100.0f / (float)totalBytes);
                    }
                    backup.setSize((double)totalBytes);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataBackupService.Backups.ParseError.fmt.txt", (Object)e));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataBackupService.Backups.ParseError.fmt.txt", (Object)e));
        }
    }

    private BackupDetails parseBackupDetails(Document response) {
        Element thisBackupElement = null;
        Element manifestElement = null;
        BackupDetails backupDetails = new BackupDetails();
        manifestElement = response.getDocumentElement();
        NodeList backupsElementsList = manifestElement.getElementsByTagName("Backups");
        Element backupsElement = (Element)backupsElementsList.item(0);
        NodeList backupElementList = backupsElement.getChildNodes();
        int maxIndex = backupElementList.getLength();
        for (int index = 0; index < maxIndex; ++index) {
            int ix;
            Node aNode = backupElementList.item(index);
            short nodeType = aNode.getNodeType();
            String nodeName = new String(aNode.getNodeName());
            if (nodeType != 1) continue;
            String testName = this.getAttribute("Name", (Element)aNode);
            String testDirectory = this.getAttribute("Directory", (Element)aNode);
            if (backupDetails.getName() == null && testName != null) {
                backupDetails.setName(testName);
            }
            if (backupDetails.getDirectory() == null && testDirectory != null) {
                backupDetails.setDirectory(testDirectory);
            }
            if (backupDetails.getName() == null && maxIndex == 1 && testDirectory != null && (ix = testDirectory.lastIndexOf(47)) > 0 && testDirectory.length() > ix) {
                backupDetails.setName(testDirectory.substring(ix + 1));
            }
            if (!nodeName.equals("Backup")) continue;
            thisBackupElement = (Element)aNode;
        }
        if (thisBackupElement == null) {
            return null;
        }
        if (manifestElement != null) {
            Element serverElement;
            NodeList serverElementsList = manifestElement.getElementsByTagName("MetadataServer");
            Element element = serverElement = serverElementsList.getLength() <= 0 ? null : (Element)serverElementsList.item(0);
            if (serverElement != null) {
                backupDetails.setGuid(this.getAttribute("GUID", serverElement));
                backupDetails.setClusterGuid(this.getAttribute("ClusterGUID", serverElement));
            }
            NodeList serverRepositoryElementList = serverElement == null ? null : serverElement.getElementsByTagName("Repository");
            NodeList backupRepositoryElementList = thisBackupElement == null ? null : thisBackupElement.getElementsByTagName("Repository");
            ArrayList<FoundationRepository> allRepositories = new ArrayList<FoundationRepository>();
            int maxIndexInServer = serverRepositoryElementList == null ? 0 : serverRepositoryElementList.getLength();
            int maxIndexInBackup = backupRepositoryElementList == null ? 0 : backupRepositoryElementList.getLength();
            maxIndex = Math.max(maxIndexInServer, maxIndexInBackup);
            for (int serverIndex = 0; serverIndex < maxIndexInServer; ++serverIndex) {
                String reposType;
                Object newRepository = null;
                Element serverRepository = null;
                Element backupRepository = null;
                Element testRepository = null;
                serverRepository = (Element)serverRepositoryElementList.item(serverIndex);
                String serverRepositoryName = this.getAttribute("Name", serverRepository);
                for (int reposIndex = 0; reposIndex < maxIndexInBackup; ++reposIndex) {
                    testRepository = (Element)backupRepositoryElementList.item(reposIndex);
                    if (testRepository == null || !this.getAttribute("Name", testRepository).equals(serverRepositoryName)) continue;
                    backupRepository = testRepository;
                    break;
                }
                newRepository = (reposType = this.getAttribute("RepositoryType", serverRepository)).equals("FOUNDATION") ? new FoundationRepository() : (reposType.equals("CUSTOM") ? new CustomRepository() : (reposType.equals("PROJECT") ? new ProjectRepository() : new RepositoryMgr()));
                String reposId = serverRepositoryName;
                String reposName = this.getAttribute("RepositoryName", serverRepository);
                String reposDesc = this.getAttribute("RepositoryDesc", serverRepository);
                String reposPath = this.getAttribute("Path", serverRepository);
                newRepository.setId(reposId);
                newRepository.setName(reposName);
                newRepository.setDescription(reposDesc);
                newRepository.setPath(reposPath);
                allRepositories.add((FoundationRepository)newRepository);
                if (backupRepository != null) {
                    String reposSize = this.getAttribute("Size", backupRepository);
                    double repositorySize = Double.parseDouble(reposSize);
                    backupDetails.setRepositoryFileSize(reposName, repositorySize);
                    continue;
                }
                backupDetails.setRepositoryFileSize(reposName, 0.0);
            }
            backupDetails.setRepositories(allRepositories);
        }
        return backupDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Recovery parseRecovery(Element element, Element running) {
        Recovery recovery = new Recovery();
        try {
            String isRunning;
            recovery.setDirectory(element.getAttribute("BackupPath"));
            recovery.setComment(element.getAttribute("Comment"));
            recovery.setIncludeConfig(element.getAttribute("IncludeAllConfigFiles").equalsIgnoreCase("Y"));
            recovery.setName(element.getAttribute("Name"));
            recovery.setPauseComment(element.getAttribute("PauseComment"));
            recovery.setPercentComplete(100.0f);
            recovery.setReorganizeRepositories(element.getAttribute("Reorg").equalsIgnoreCase("Y"));
            String rollForward = element.getAttribute("RollForward");
            if (rollForward.equalsIgnoreCase("_ALL_")) {
                recovery.setRollForward(new Date());
            } else if (rollForward.length() > 0) {
                Date rollForwardDate;
                SimpleDateFormat simpleDateFormat = this.rollForwardFormat;
                synchronized (simpleDateFormat) {
                    rollForwardDate = this.rollForwardFormat.parse(rollForward);
                }
                recovery.setRollForward(rollForwardDate);
            }
            String size = element.getAttribute("Size");
            if (size.length() > 0) {
                recovery.setSize((double)Long.parseLong(size));
            }
            recovery.setStartedDate(this.parseISO8601DateTime(element.getAttribute("StartDateTime")));
            recovery.setTimeZoneOffset(this.getISO8601DateTimeTimezoneOffset(element.getAttribute("StartDateTime")));
            recovery.setUser(element.getAttribute("StartingUserID"));
            Operation.Status status = this.parseStatus(element.getAttribute("Status"));
            recovery.setStatus(status);
            if (status == Operation.Status.ACTIVE && running != null && (isRunning = running.getAttribute("IsRunning")).equals("Y")) {
                recovery.setPercentComplete(0.0f);
                try {
                    long totalBytes = Long.parseLong(running.getAttribute("BytesToCopy"));
                    long bytesCopied = Long.parseLong(running.getAttribute("BytesCopied"));
                    if (totalBytes > 0L) {
                        recovery.setPercentComplete((float)bytesCopied * 100.0f / (float)totalBytes);
                    }
                    recovery.setSize((double)totalBytes);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataBackupService.Recovery.ParseError.fmt.txt", (Object)e));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataBackupService.Recovery.ParseError.fmt.txt", (Object)e));
        }
        return recovery;
    }

    private RecoveryDetails parseRecoveryDetails(Document response) {
        Element thisRecoveryElement = null;
        Element manifestElement = null;
        RecoveryDetails recoveryDetails = null;
        manifestElement = response.getDocumentElement();
        NodeList backupsElementsList = manifestElement.getElementsByTagName("Backups");
        Element backupsElement = (Element)backupsElementsList.item(0);
        NodeList backupElementList = backupsElement.getChildNodes();
        int maxIndex = backupElementList.getLength();
        for (int index = 0; index < maxIndex; ++index) {
            Node aNode = backupElementList.item(index);
            short nodeType = aNode.getNodeType();
            String nodeName = new String(aNode.getNodeName());
            if (nodeType != 1 || !nodeName.equals("Recovery")) continue;
            thisRecoveryElement = (Element)aNode;
        }
        if (thisRecoveryElement == null) {
            return null;
        }
        if (manifestElement != null) {
            recoveryDetails = new RecoveryDetails();
            NodeList serverElementsList = manifestElement.getElementsByTagName("MetadataServer");
            Element serverElement = serverElementsList.getLength() <= 0 ? null : (Element)serverElementsList.item(0);
            NodeList serverRepositoryElementList = serverElement == null ? null : serverElement.getElementsByTagName("Repository");
            NodeList restoreRepositoryElementList = thisRecoveryElement == null ? null : thisRecoveryElement.getElementsByTagName("Repository");
            ArrayList<FoundationRepository> allRepositories = new ArrayList<FoundationRepository>();
            int maxIndexInServer = serverRepositoryElementList == null ? 0 : serverRepositoryElementList.getLength();
            int maxIndexInRestore = restoreRepositoryElementList == null ? 0 : restoreRepositoryElementList.getLength();
            maxIndex = Math.max(maxIndexInServer, maxIndexInRestore);
            for (int serverIndex = 0; serverIndex < maxIndexInServer; ++serverIndex) {
                String reposType;
                Object newRepository = null;
                Element serverRepository = null;
                Element restoreRepository = null;
                Element testRepository = null;
                serverRepository = (Element)serverRepositoryElementList.item(serverIndex);
                String serverRepositoryName = this.getAttribute("Name", serverRepository);
                for (int reposIndex = 0; reposIndex < maxIndexInRestore; ++reposIndex) {
                    testRepository = (Element)restoreRepositoryElementList.item(reposIndex);
                    if (testRepository == null || !this.getAttribute("Name", testRepository).equals(serverRepositoryName)) continue;
                    restoreRepository = testRepository;
                    break;
                }
                newRepository = (reposType = this.getAttribute("RepositoryType", serverRepository)).equals("FOUNDATION") ? new FoundationRepository() : (reposType.equals("CUSTOM") ? new CustomRepository() : (reposType.equals("PROJECT") ? new ProjectRepository() : new RepositoryMgr()));
                String reposId = serverRepositoryName;
                String reposName = this.getAttribute("RepositoryName", serverRepository);
                String reposDesc = this.getAttribute("RepositoryDesc", serverRepository);
                String reposPath = this.getAttribute("Path", serverRepository);
                newRepository.setId(reposId);
                newRepository.setName(reposName);
                newRepository.setDescription(reposDesc);
                newRepository.setPath(reposPath);
                allRepositories.add((FoundationRepository)newRepository);
                if (restoreRepository != null) {
                    String reposSize = this.getAttribute("Size", restoreRepository);
                    double repositorySize = Double.parseDouble(reposSize);
                    recoveryDetails.setRepositoryFileSize(reposName, repositorySize);
                    continue;
                }
                recoveryDetails.setRepositoryFileSize(reposName, 0.0);
            }
            recoveryDetails.setRepositories(allRepositories);
        }
        return recoveryDetails;
    }

    private Operation.Status parseStatus(String status) {
        if (status.equalsIgnoreCase("Started")) {
            return Operation.Status.ACTIVE;
        }
        if (status.equalsIgnoreCase("Successful")) {
            return Operation.Status.SUCCESS;
        }
        if (status.equalsIgnoreCase("Failed")) {
            return Operation.Status.ERROR;
        }
        if (status.equalsIgnoreCase("Cancelled")) {
            return Operation.Status.CANCELLED;
        }
        return Operation.Status.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseISO8601DateTime(String iso8601) throws ParseException {
        int len = iso8601.length();
        if (len <= 0) {
            return null;
        }
        if (len > 22 && iso8601.charAt(len - 3) == ':') {
            iso8601 = iso8601.substring(0, len - 3) + iso8601.substring(len - 2);
        }
        SimpleDateFormat simpleDateFormat = this.iso8601format;
        synchronized (simpleDateFormat) {
            return this.iso8601format.parse(iso8601);
        }
    }

    private double getISO8601DateTimeTimezoneOffset(String iso8601) {
        Double offsetMinutes = null;
        String offsetString = null;
        if (iso8601 != null) {
            StringBuffer sb;
            int len = iso8601.length();
            if (len > 22 && (sb = new StringBuffer(iso8601)).charAt(len - 3) == ':') {
                sb.deleteCharAt(len - 3);
                iso8601 = sb.toString();
            }
            offsetString = iso8601.substring(iso8601.length() - 5);
            String hoursString = offsetString.substring(1, 3);
            double hours = Integer.parseInt(hoursString);
            String minutesString = offsetString.substring(3);
            double minutes = Integer.parseInt(minutesString);
            offsetMinutes = hours * 60.0 + minutes;
            if (offsetString.charAt(0) == '-') {
                offsetMinutes = offsetMinutes * -1.0;
            }
        }
        return offsetMinutes * 60.0 * 1000.0;
    }

    private String getAttribute(String attributeName, Element someElement) {
        String valueString = null;
        Attr theAttr = someElement.getAttributeNode(attributeName);
        if (theAttr != null) {
            valueString = theAttr.getValue();
        }
        if (valueString != null) {
            return new String(valueString);
        }
        return null;
    }

    private void processVerification(Document doc, Backup backup) {
        Element thisBackupElement = null;
        if (doc != null) {
            Element verifyElement = doc.getDocumentElement();
            NodeList backupElementList = verifyElement.getElementsByTagName("Backup");
            int maxIndex = backupElementList.getLength();
            for (int index = 0; index < maxIndex; ++index) {
                Node aNode = backupElementList.item(index);
                short nodeType = aNode.getNodeType();
                String nodeName = new String(aNode.getNodeName());
                if (nodeType != 1 || !nodeName.equals("Backup")) continue;
                String name = backup.getName();
                if (!this.getAttribute("Name", (Element)aNode).equals(name)) continue;
                thisBackupElement = (Element)aNode;
                String isValidString = this.getAttribute("Verify", thisBackupElement);
                backup.setAvailable(isValidString.equalsIgnoreCase("Successful"));
                backup.setOffline(isValidString.equalsIgnoreCase("Offline"));
                backup.setVerified(true);
                break;
            }
        } else {
            backup.setOffline(true);
            backup.setAvailable(false);
        }
        if (thisBackupElement == null) {
            backup.setOffline(true);
            backup.setAvailable(false);
        }
    }

    class ScheduleComparator
    implements Comparator<Object> {
        ScheduleComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return this.runCompare(obj1, obj2);
        }

        private int runCompare(Object obj1, Object obj2) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar.set(1970, 0, 1, 0, 0, 0);
            BackupSchedule schedule1 = null;
            Date schedule1Date = null;
            BackupSchedule schedule2 = null;
            Date schedule2Date = null;
            if (!(obj1 instanceof BackupSchedule)) {
                return -1;
            }
            schedule1 = (BackupSchedule)obj1;
            calendar.set(11, schedule1.getHour());
            calendar.set(12, schedule1.getMinute());
            schedule1Date = calendar.getTime();
            if (!(obj2 instanceof BackupSchedule)) {
                return 1;
            }
            schedule2 = (BackupSchedule)obj2;
            calendar.set(11, schedule2.getHour());
            calendar.set(12, schedule2.getMinute());
            schedule2Date = calendar.getTime();
            if (schedule1Date.compareTo(schedule2Date) == 0) {
                if (schedule1.isReorganizeRepositories() && schedule2.isReorganizeRepositories()) {
                    return -1;
                }
                if (schedule1.isReorganizeRepositories()) {
                    return -1;
                }
                if (schedule2.isReorganizeRepositories()) {
                    return 1;
                }
                return -1;
            }
            if (schedule1Date.compareTo(schedule2Date) < 0) {
                return -1;
            }
            if (schedule1Date.compareTo(schedule2Date) > 0) {
                return 1;
            }
            return -1;
        }
    }
}

