/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.Permission;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

public class VerifyPermissions
extends AbstractToolImpl {
    static final String NAME = RB.getStringResource("VerifyPermissions.tool.name.txt");
    static final String DESCRIPTION = RB.getStringResource("VerifyPermissions.tool.desc.txt");
    static final String ID = "Permissions";
    private static AnalysisTool _factoryInstance;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new VerifyPermissions();
        }
        return _factoryInstance;
    }

    private VerifyPermissions() {
    }

    private VerifyPermissions(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        VerifyPermissions newObject = new VerifyPermissions(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void analyzeImpl() {
        try {
            if (this._repository.getRepositoryType().equals("FOUNDATION")) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyPermissions.Analyze.Foundation.fmt", (Object)this._repository.getDefaultRepositoryName()));
                this._result.setStatus(Operation.Status.SUCCESS);
                return;
            }
            this.createObjectStore();
            List<Permission> permissionsList = this.getPermissionsListInRepository(this._repository.getDefaultRepositoryId());
            if (permissionsList.size() == 0) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyPermissions.Analyze.NotFound.fmt", (Object)this._repository.getDefaultRepositoryName()));
            } else {
                Map<String, GrantDenyPair> permissionsMap = VerifyPermissions.buildPermissionsMap(permissionsList);
                for (GrantDenyPair permPair : permissionsMap.values()) {
                    Permission grant = permPair.getGrantPerm();
                    Permission deny = permPair.getDenyPerm();
                    int numAces = grant.getAccessControlEntries().size() + deny.getAccessControlEntries().size();
                    this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyPermissions.Analyze.PermissionFoundInNonFoundation.fmt", (Object)permPair.getGrantPerm().getName(), (Object)this._repository.getDefaultRepositoryName(), (Object)new Integer(numAces)));
                }
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyPermissions.Analyze.permissionsFoundInNonFoundation.fmt", (Object)new Integer(permissionsMap.size()), (Object)this._repository.getDefaultRepositoryName()));
                this._result.setWarningDetected(true);
                this._result.setRepairNeeded(true);
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void repairImpl() {
        try {
            Map<String, GrantDenyPair> permissionsInFoundationTable = VerifyPermissions.buildPermissionsMap(this.getPermissionsListInRepository(this._OMIUtil.getFoundationReposID()));
            if (this._repository.getRepositoryType() == null || !this._repository.getRepositoryType().equalsIgnoreCase("Foundation")) {
                List<Permission> permissionsList = this.getPermissionsListInRepository(this._repository.getDefaultRepositoryId());
                int numberOfMoved = 0;
                int numberOfDeleted = 0;
                for (GrantDenyPair grantDenyPair : VerifyPermissions.buildPermissionsMap(permissionsList).values()) {
                    Permission grant = grantDenyPair.getGrantPerm();
                    Permission deny = grantDenyPair.getDenyPerm();
                    String permName = grant.getName();
                    if (grant.getAccessControlEntries().size() == 0 && deny.getAccessControlEntries().size() == 0) {
                        this._OMIUtil.deleteMetadataObject("Permission", grant.getId());
                        this._OMIUtil.deleteMetadataObject("Permission", deny.getId());
                        ++numberOfDeleted;
                        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyPermissions.Repair.Permission.Deleted.fmt", (Object)permName, (Object)this._repository.getDefaultRepositoryName()));
                        continue;
                    }
                    if (permissionsInFoundationTable.containsKey(grant.getName())) {
                        GrantDenyPair foundationPair = permissionsInFoundationTable.get(grant.getName());
                        Permission foundationGrant = foundationPair.getGrantPerm();
                        Permission foundationDeny = foundationPair.getDenyPerm();
                        foundationGrant.getAccessControlEntries().addAll((Collection)grant.getAccessControlEntries());
                        foundationDeny.getAccessControlEntries().addAll((Collection)deny.getAccessControlEntries());
                        this._OMIUtil.deleteMetadataObject("Permission", grant.getId());
                        this._OMIUtil.deleteMetadataObject("Permission", deny.getId());
                        this._store.updatedMetadataAll();
                        ++numberOfDeleted;
                        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyPermissions.Repair.Permission.MovedAndDeleted.fmt", (Object)permName, (Object)this._repository.getDefaultRepositoryName()));
                        continue;
                    }
                    String foundationRepositoryID = this._OMIUtil.getFoundationReposID();
                    this.createPermission(grant, foundationRepositoryID);
                    this.createPermission(deny, foundationRepositoryID);
                    this._OMIUtil.deleteMetadataObject("Permission", grant.getId());
                    this._OMIUtil.deleteMetadataObject("Permission", deny.getId());
                    this._store.updatedMetadataAll();
                    ++numberOfMoved;
                    this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyPermissions.Repair.Permission.MovedAndDeleted1.fmt", (Object)permName, (Object)this._repository.getDefaultRepositoryName()));
                }
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyPermissions.Repair.Results_NonFoundation.fmt", (Object)new Integer(numberOfMoved), (Object)new Integer(numberOfDeleted), (Object)this._repository.getDefaultRepositoryName()));
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }

    private Permission createPermission(Permission permission, String reposID) throws RemoteException, MdException {
        Permission newPermission = (Permission)this._factory.createComplexMetadataObject(this._store, null, permission.getName(), "Permission", reposID.substring(9));
        newPermission.setType(permission.getType());
        newPermission.setDesc(permission.getDesc());
        newPermission.getAccessControlEntries().addAll((Collection)permission.getAccessControlEntries());
        return newPermission;
    }

    public static Map<String, GrantDenyPair> buildPermissionsMap(List<Permission> permissions) {
        HashMap<String, GrantDenyPair> gdp_tbl = new HashMap<String, GrantDenyPair>(permissions.size() / 2);
        for (Permission perm : permissions) {
            try {
                GrantDenyPair gdp;
                if (!gdp_tbl.containsKey(perm.getName())) {
                    gdp = new GrantDenyPair();
                    if (perm.getType().toUpperCase().compareTo("GRANT") == 0) {
                        gdp.setGrantPerm(perm);
                    } else {
                        gdp.setDenyPerm(perm);
                    }
                    gdp_tbl.put(perm.getName(), gdp);
                    continue;
                }
                gdp = (GrantDenyPair)gdp_tbl.get(perm.getName());
                MdStore gdpStore = gdp.getDenyPerm() != null ? gdp.getDenyPerm().getObjectStore() : gdp.getGrantPerm().getObjectStore();
                MdStoreUtil.refreshMetaObject((MdStore)perm.getObjectStore(), (MdStore)gdpStore, (String)perm.getFQID());
                Permission scndPairObj = (Permission)gdpStore.getObject(perm.getFQID());
                if (scndPairObj != null && scndPairObj.getType().toUpperCase().compareTo("GRANT") == 0) {
                    gdp.setGrantPerm(scndPairObj);
                    continue;
                }
                gdp.setDenyPerm(scndPairObj);
            }
            catch (RemoteException gdp) {}
        }
        HashMap<String, GrantDenyPair> returnTable = new HashMap<String, GrantDenyPair>(gdp_tbl.size());
        for (GrantDenyPair gdPair : gdp_tbl.values()) {
            if (gdPair.getDenyPerm() == null || gdPair.getGrantPerm() == null) continue;
            try {
                returnTable.put(gdPair.getDenyPerm().getName(), gdPair);
            }
            catch (RemoteException remoteException) {}
        }
        return returnTable;
    }

    private List<Permission> getPermissionsListInRepository(String reposID) throws RemoteException, MdException {
        String strTemplate = "<TEMPLATES><Permission Name=\"\" Type=\"\"><AcccessControlEntries/></Permission></TEMPLATES>";
        return this.retrieve((MdStore)this._store, "Permission", "<TEMPLATES><Permission Name=\"\" Type=\"\"><AcccessControlEntries/></Permission></TEMPLATES>", "", reposID, false, false);
    }

    private List<? extends CMetadata> retrieve(MdStore mdStore, String strMetaType, String strTemplate, String strSelect, String strReposid, boolean bIncSubtypes, boolean bParentRepos) {
        boolean bMultipeOptions = false;
        if (strTemplate != null && strTemplate.length() > 0 && strSelect != null && strSelect.length() > 0) {
            bMultipeOptions = true;
        }
        String strOptions = "";
        int flags = 256;
        if (strTemplate != null && strTemplate.length() > 0) {
            strOptions = strOptions + strTemplate;
            flags |= 4;
        }
        if (strSelect != null && strSelect.length() > 0) {
            strOptions = strOptions + strSelect;
            flags |= 0x80;
        }
        if (bIncSubtypes) {
            flags |= 0x10;
        }
        if (bParentRepos) {
            flags |= 0x4000;
        }
        if (bMultipeOptions) {
            strOptions = "<Options>" + strOptions + "</Options>";
        }
        ArrayList<CMetadata> retList = new ArrayList<CMetadata>();
        try {
            List metaList = this._store.getFactory().getOMIUtil().getMetadataObjectsSubset(mdStore, strReposid, strMetaType, flags, strOptions);
            for (CMetadata rtrvdObj : metaList) {
                if (mdStore.getObject(rtrvdObj.getFQID()) == null) {
                    MdStoreUtil.refreshMetaObject((MdStore)rtrvdObj.getObjectStore(), (MdStore)mdStore, (String)rtrvdObj.getFQID());
                }
                retList.add(mdStore.getObject(rtrvdObj.getFQID()));
            }
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retList;
    }

    static class GrantDenyPair {
        protected Permission m_gp = null;
        protected Permission m_dp = null;

        public GrantDenyPair() {
        }

        public GrantDenyPair(Permission grant, Permission deny) {
            this.setDenyPerm(deny);
            this.setGrantPerm(grant);
        }

        public boolean setGrantPerm(Permission grant) {
            try {
                if (grant.getType().compareTo("GRANT") != 0) {
                    return false;
                }
                if (this.m_dp != null) {
                    if (this.m_dp.getName().compareTo(grant.getName()) != 0) {
                        return false;
                    }
                    if (this.m_dp.getObjectStore() != grant.getObjectStore()) {
                        return false;
                    }
                }
                this.m_gp = grant;
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }

        public boolean setDenyPerm(Permission deny) {
            try {
                if (deny.getType().compareTo("DENY") != 0) {
                    return false;
                }
                if (this.m_gp != null) {
                    if (this.m_gp.getName().compareTo(deny.getName()) != 0) {
                        return false;
                    }
                    if (this.m_gp.getObjectStore() != deny.getObjectStore()) {
                        return false;
                    }
                }
                this.m_dp = deny;
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }

        public Permission getGrantPerm() {
            return this.m_gp;
        }

        public Permission getDenyPerm() {
            return this.m_dp;
        }
    }
}

