/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanObjectComponentInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import java.rmi.RemoteException;
import java.util.List;

public class OrphanedQueryTableComponent
implements OrphanObjectComponentInterface {
    private static final String TOOLNAME = RB.getStringResource("OrphanedQueryTables.tool.label.txt");
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><QueryTable Name=\"\" PublicType=\"\"><SpecSourceTransformations/><SourceTransformations/><SourceClassifierMaps/><TargetClassifierMaps/></QueryTable></TEMPLATES>";
    private static final String TABLE_REPAIR_TEMPLATE = "<Template TemplateName=\"QueryTableCleanup\"><QueryTable><Columns /><CustomAssociations /><Properties /><PropertySets /><Roles /></QueryTable><CustomAssociation> <AssociatedObjects> <Column TemplateExpand=\"connect\" AutoMap=\"Y\" /> <Index TemplateExpand=\"connect\" AutoMap=\"Y\" /> <SASLibrary TemplateExpand=\"connect\" /> <MiningResult TemplateExpand=\"connect\" /> <JFJob TemplateExpand=\"connect\" AutoMap=\"Y\" /> <WorkTable /> <QueryTable /> <DataTable TemplateExpand=\"connect\" /> <Classifier TemplateExpand=\"connect\" AutoMap=\"Y\"/><Property /><PropertySet /></AssociatedObjects><Properties /><PropertySets /></CustomAssociation><Column><Keys/><Properties/><PropertySets/><Notes/><Extensions/></Column><Property><ExternalIdentities/><CustomAssociations/><Keywords/><PrimaryPropertyGroup/><Properties/><SpecTargetTransformations/><StoredConfiguration/><TargetTransformations/></Property><WorkTable><Extensions/><Notes/><Properties/><Columns/><Indexes/><PropertySets/><Roles/></WorkTable><Index><Notes/><Extensions/><Properties/></Index></Template>";
    protected AnalysisTool _parentAnalyzeTool;

    public OrphanedQueryTableComponent(AnalysisTool parentAnalyzeTool) {
        this._parentAnalyzeTool = parentAnalyzeTool;
    }

    @Override
    public AnalysisTool getParentAnalyzeTool() {
        return this._parentAnalyzeTool;
    }

    @Override
    public String getXMLSelectString() {
        return null;
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "QueryTable";
    }

    @Override
    public String getRepairTemplate() {
        return TABLE_REPAIR_TEMPLATE;
    }

    @Override
    public String getComponentLabel() {
        return TOOLNAME;
    }

    @Override
    public boolean isOrphan(FastMetadata objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        String publicType = (String)objectMap.get((Object)"PublicType");
        if (publicType != null && publicType.length() > 0) {
            return false;
        }
        List sourceClassifiers = objectMap.getAssociation("SourceClassifierMaps");
        if (sourceClassifiers != null && sourceClassifiers.size() > 0) {
            return false;
        }
        List targetClassifiers = objectMap.getAssociation("TargetClassifierMaps");
        if (targetClassifiers != null && targetClassifiers.size() > 0) {
            return false;
        }
        List spec = objectMap.getAssociation("SpecSourceTransformations");
        if (spec != null && spec.size() > 0) {
            return false;
        }
        List sourceTransformations = objectMap.getAssociation("SourceTransformations");
        return sourceTransformations == null || sourceTransformations.size() <= 0;
    }
}

