/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractPropertyObjectComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedProperties;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;

public class OrphanedPropertyTypeComponent
extends AbstractPropertyObjectComponent {
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><PropertyType Name=\"\"><Customizers/><Editors/><Validators/><Implementors/><Groups/><TypedProperties/><TypedAttProperties/><ElementType/><ArrayTypes/><StoredConfiguration/></PropertyType></TEMPLATES>";

    public OrphanedPropertyTypeComponent(AnalysisTool parentAnalyzeTool) {
        super(parentAnalyzeTool);
    }

    @Override
    public String getComponentLabel() {
        return RB.getStringResource("OrphanedPropertyTypeComponent.tool.label.txt");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "PropertyType";
    }

    @Override
    public boolean isOrphan(FastMetadata objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        if (this.containsCommonAssociations(objectMap)) {
            return false;
        }
        List groupsList = objectMap.getAssociation("Groups");
        if (groupsList != null && groupsList.size() > 0) {
            return false;
        }
        List typedPropsList = objectMap.getAssociation("TypedProperties");
        if (typedPropsList != null && typedPropsList.size() > 0) {
            return false;
        }
        List typedAttPropsList = objectMap.getAssociation("TypedAttProperties");
        if (typedAttPropsList != null && typedAttPropsList.size() > 0) {
            return false;
        }
        List arrayTypesList = objectMap.getAssociation("ArrayTypes");
        if (arrayTypesList != null && arrayTypesList.size() > 0) {
            return false;
        }
        List elementTypesList = objectMap.getAssociation("ElementType");
        return elementTypesList == null || elementTypesList.size() <= 0;
    }

    @Override
    protected void analysisSetup() {
        OrphanedProperties parent = (OrphanedProperties)this.getParentAnalyzeTool();
        Set<String> entityTypes = parent.getEntityPropertyTypes();
        if (entityTypes != null && !entityTypes.isEmpty()) {
            parent.addExclusions(this, entityTypes);
        }
    }
}

