/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertyType;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractOrphanObjectTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractPropertyObjectComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanObjectComponentInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedPropertyComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedPropertyGroupComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedPropertySetComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedPropertyTypeComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class OrphanedProperties
extends AbstractOrphanObjectTool {
    private static final String NAME = RB.getStringResource("OrphanedProperties.tool.name.txt");
    private static final String DESCRIPTION = RB.getStringResource("OrphanedProperties.tool.desc.txt");
    private static final String ID = "OrphProp";
    private static AnalysisTool _factoryInstance;
    private Set<String> _entityPropertyTypes = new HashSet<String>(10);

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedProperties();
        }
        return _factoryInstance;
    }

    private OrphanedProperties() {
    }

    private OrphanedProperties(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
        this.addOrphanComponent(new OrphanedPropertyGroupComponent(this));
        this.addOrphanComponent(new OrphanedPropertySetComponent(this));
        this.addOrphanComponent(new OrphanedPropertyComponent(this));
        this.addOrphanComponent(new OrphanedPropertyTypeComponent(this));
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedProperties newObject = new OrphanedProperties(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void analysisSetup() {
        this.loadEntityTypes();
        for (OrphanObjectComponentInterface comp : this.getOrphanComponents()) {
            if (!(comp instanceof AbstractPropertyObjectComponent)) continue;
            ((AbstractPropertyObjectComponent)comp).analysisSetup();
        }
    }

    protected Set<String> getEntityPropertyTypes() {
        return this._entityPropertyTypes;
    }

    private void loadEntityTypes() {
        try {
            if (!"FOUNDATION".equalsIgnoreCase(this._repository.getRepositoryType())) {
                return;
            }
            String xmlSelect = "<XMLSelect search=\"Group[@Name='Entity Property Types']\"/>";
            String template = "<Templates><Group><Members/></Group><PropertyType Name=\"\"/></Templates>";
            String options = xmlSelect + template;
            int flags = 388;
            List groups = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "Group", flags, options);
            if (groups != null && groups.size() > 0) {
                Group entityPropertyTypeGroup = (Group)groups.get(0);
                AssociationList propertyTypes = entityPropertyTypeGroup.getMembers();
                for (PropertyType pType : propertyTypes) {
                    this._entityPropertyTypes.add(pType.getId());
                }
            }
        }
        catch (Exception e) {
            this._log.debug("Unable to retrieve entity property types from repository", (Throwable)e);
        }
    }
}

