/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractOrphanObjectTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanObjectComponentInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

public class OrphanedAces
extends AbstractOrphanObjectTool
implements OrphanObjectComponentInterface {
    private static final String NAME = RB.getStringResource("OrphanedAces.tool.name.txt");
    private static final String DESCRIPTION = RB.getStringResource("OrphanedAces.tool.desc.txt");
    private static final String ID = "OrphAce";
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><AccessControlEntry Name=\"\"><Objects/><AccessControlTemplates/><Permissions/><Identities/></AccessControlEntry></TEMPLATES>";
    private static AnalysisTool _factoryInstance;
    private int _objectandactCount = 0;
    private int _permissionsCount = 0;
    private int _identitiesCount = 0;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedAces();
        }
        return _factoryInstance;
    }

    private OrphanedAces() {
    }

    private OrphanedAces(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedAces newObject = new OrphanedAces(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getComponentLabel() {
        return RB.getStringResource("OrphanedAces.tool.label.txt");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getXMLSelectString() {
        return null;
    }

    @Override
    public String getMetadataType() {
        return "AccessControlEntry";
    }

    @Override
    public String getRepairTemplate() {
        return null;
    }

    @Override
    public boolean isOrphan(FastMetadata objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        boolean orphan = false;
        List objectsAssocList = objectMap.getAssociation("Objects");
        List actsAssocList = objectMap.getAssociation("AccessControlTemplates");
        if (!(objectsAssocList != null && objectsAssocList.size() != 0 || actsAssocList != null && actsAssocList.size() != 0)) {
            if (this.isFinalSearch()) {
                ++this._objectandactCount;
            }
            orphan = true;
        } else {
            List permissionsAssocList = objectMap.getAssociation("Permissions");
            List identitiesAssocList = objectMap.getAssociation("Identities");
            if (permissionsAssocList == null || permissionsAssocList.size() == 0 || identitiesAssocList == null || identitiesAssocList.size() == 0) {
                if (this.isFinalSearch()) {
                    if (permissionsAssocList != null && permissionsAssocList.size() == 0) {
                        ++this._permissionsCount;
                    } else {
                        ++this._identitiesCount;
                    }
                }
                orphan = true;
            }
        }
        return orphan;
    }

    @Override
    public AnalysisTool getParentAnalyzeTool() {
        return this;
    }

    @Override
    public void analysisSetup() {
        this._objectandactCount = 0;
        this._permissionsCount = 0;
        this._identitiesCount = 0;
    }

    @Override
    public void analysisTearDown() {
        if (this._objectandactCount > 0) {
            this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedAces.Analyze.OrphanObjCount.fmt", (Object)this._objectandactCount));
        }
        if (this._permissionsCount > 0) {
            this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedAces.Analyze.OrphanPermissionCount.fmt", (Object)this._permissionsCount));
        }
        if (this._identitiesCount > 0) {
            this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedAces.Analyze.OrphanIdentitiesCount.fmt", (Object)this._identitiesCount));
        }
    }
}

