/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.svcs.metadata.mgmt.client.AnalysisResult;
import com.sas.svcs.metadata.mgmt.client.AnalysisToolDescriptor;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.LogCapture;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

public abstract class AbstractToolImpl
implements AnalysisTool {
    protected OMIRepositoryInterface _repository;
    protected Logger _log;
    protected MdFactory _factory;
    protected MdOMIUtil _OMIUtil;
    protected MdObjectStore _store;
    protected AnalysisResult _result;

    AbstractToolImpl() {
    }

    AbstractToolImpl(OMIRepositoryInterface repository, Logger log) {
        this._repository = repository;
        this._log = log;
        this._result = new AnalysisResult();
        this._result.setName(this.getName());
        this._result.setToolId(this.getId());
        if (this._repository == null) {
            return;
        }
        try {
            this._result.setRepositoryName(repository.getDefaultRepositoryName());
            this._factory = ((OMIServer)this._repository.getServer()).getMdFactory();
            this._OMIUtil = this._factory.getOMIUtil();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AnalysisToolDescriptor getAnalysisToolDescriptor() {
        AnalysisToolDescriptor descriptor = new AnalysisToolDescriptor();
        descriptor.setName(this.getName());
        descriptor.setId(this.getId());
        descriptor.setDescription(this.getDescription());
        return descriptor;
    }

    @Override
    public OMIRepositoryInterface getRepository() {
        return this._repository;
    }

    protected abstract void analyzeImpl();

    protected abstract void repairImpl();

    @Override
    public final AnalysisResult analyze() {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        LogCapture logCapture = new LogCapture(this._log);
        try {
            this._result.setStatus(Operation.Status.ACTIVE);
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractToolImpl.Analysis.Start.fmt.txt", (Object)this.getName(), (Object)this._repository.getDefaultRepositoryName()));
            this.analyzeImpl();
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (OutOfMemoryError e) {
            this._log.error(RB.getStringResource("AbstractToolImpl.Analysis.OutOfMemory.txt"));
            this._result.setStatus(Operation.Status.ERROR);
        }
        catch (Exception e) {
            this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractToolImpl.Analysis.Failed.fmt.txt", (Object)e.getLocalizedMessage()));
            this._result.setStatus(Operation.Status.ERROR);
        }
        finally {
            this._result.setLog(logCapture.endLogging());
        }
        return this._result;
    }

    @Override
    public final AnalysisResult repair() {
        if (this._repository == null) {
            throw new IllegalStateException("This method cannot be called on a factory instance.");
        }
        LogCapture logCapture = new LogCapture(this._log);
        try {
            if (this._result.getStatus() == Operation.Status.NOT_STARTED) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractToolImpl.Analysis.Start.fmt.txt", (Object)this.getName(), (Object)this._repository.getDefaultRepositoryName()));
                this._result.setStatus(Operation.Status.ACTIVE);
                this.analyzeImpl();
            }
            if (!this._result.isRepairNeeded()) {
                this._log.info(RB.getStringResource("AbstractToolImpl.NoRepairRequired.txt"));
                AnalysisResult analysisResult = this._result;
                return analysisResult;
            }
            this._result.setStatus(Operation.Status.ACTIVE);
            this._result.setWarningDetected(false);
            this.repairImpl();
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (OutOfMemoryError e) {
            this._log.error(RB.getStringResource("AbstractToolImpl.Repair.OutOfMemory.txt"));
            this._result.setStatus(Operation.Status.ERROR);
        }
        catch (Exception e) {
            this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractToolImpl.Repair.Failed.fmt.txt", (Object)e.getLocalizedMessage()));
            this._result.setStatus(Operation.Status.ERROR);
        }
        finally {
            this._result.setLog(logCapture.endLogging());
        }
        return this._result;
    }

    protected void fail() {
        if (this._result != null) {
            this._result.setStatus(Operation.Status.ERROR);
        }
    }

    protected void release() {
        this.releaseObjectStore();
    }

    protected void createObjectStore() throws ServiceException, RemoteException {
        if (this._store == null) {
            this._store = this._factory.createObjectStore(null, "AnalyzeRepairStore: " + this.getName());
        }
    }

    protected void releaseObjectStore() {
        try {
            if (this._store != null) {
                this._store.dispose();
                this._store = null;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

