/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanObjectComponentInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public abstract class AbstractOrphanObjectTool
extends AbstractToolImpl {
    protected int _processCount = 10000;
    private boolean _isSecondarySearchNeeded = false;
    private boolean _isSecondarySearch = false;
    private Map<OrphanObjectComponentInterface, List<String>> _componentMap = new LinkedHashMap<OrphanObjectComponentInterface, List<String>>(3);
    protected Map<OrphanObjectComponentInterface, Set<String>> _exclusionMap;

    protected AbstractOrphanObjectTool() {
        if (this instanceof OrphanObjectComponentInterface) {
            this.addOrphanComponent((OrphanObjectComponentInterface)((Object)this));
        }
    }

    protected AbstractOrphanObjectTool(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
        if (this instanceof OrphanObjectComponentInterface) {
            this.addOrphanComponent((OrphanObjectComponentInterface)((Object)this));
        }
    }

    protected void addOrphanComponent(OrphanObjectComponentInterface comp) {
        this._componentMap.put(comp, null);
    }

    protected Set<OrphanObjectComponentInterface> getOrphanComponents() {
        return this._componentMap.keySet();
    }

    public void setProcessCount(int count) {
        this._processCount = count;
    }

    public void analysisSetup() {
    }

    public void analysisTearDown() {
    }

    protected void addExclusions(OrphanObjectComponentInterface comp, Set<String> exclusionSet) {
        if (this._exclusionMap == null) {
            this._exclusionMap = new HashMap<OrphanObjectComponentInterface, Set<String>>();
        }
        if (this._exclusionMap.containsKey(comp)) {
            Set<String> ids = this._exclusionMap.get(comp);
            ids.addAll(exclusionSet);
        } else {
            this._exclusionMap.put(comp, exclusionSet);
        }
    }

    private boolean canAnalyzeObject(OrphanObjectComponentInterface comp, String objectID) {
        if (this._exclusionMap == null) {
            return true;
        }
        Set<String> exclusionSet = this._exclusionMap.get(comp);
        return exclusionSet == null ? true : !exclusionSet.contains(objectID);
    }

    @Override
    public void analyzeImpl() {
        try {
            this.createObjectStore();
            this.analysisSetup();
            this.setSearchDetails();
            for (OrphanObjectComponentInterface comp : this._componentMap.keySet()) {
                this.analyzeOrphanComponent(comp);
            }
            this.analysisTearDown();
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }

    private void analyzeOrphanComponent(OrphanObjectComponentInterface comp) throws MdException, RemoteException {
        long t0 = 0L;
        long t1 = 0L;
        if (this._log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Analyze.Objects.fmt.txt", (Object)comp.getComponentLabel()));
        int flags = 0;
        String options = comp.getXMLSelectString();
        if (options == null) {
            options = "";
        } else {
            flags |= 0x80;
        }
        List objectList = this._factory.getOMIUtil().getFastMetadataObjects(comp.getMetadataType(), this._repository.getDefaultRepositoryId(), options, flags);
        if (objectList == null || objectList.size() == 0) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Analyze.NotFound.fmt.txt", (Object)comp.getComponentLabel());
            this._log.info(msg);
            return;
        }
        int objectCount = objectList.size();
        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Analyze.TotalFound.fmt.txt", (Object)new Integer(objectCount), (Object)comp.getComponentLabel()));
        if (this._log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
            this._log.debug("Time to get all objects from server: " + (double)(t1 - t0) / 1000.0 + " seconds");
        }
        LinkedHashMap<String, String> fetchList = new LinkedHashMap<String, String>(Math.min(objectCount, this._processCount) + 1, 1.0f);
        int counter = 0;
        for (int index = 0; index < objectCount; ++index) {
            FastMetadata map = (FastMetadata)objectList.get(index);
            String objectID = (String)map.get((Object)"Id");
            if (!this.canAnalyzeObject(comp, objectID)) continue;
            fetchList.put(objectID, map.getAttribute("MetadataObjectType"));
            if (++counter != this._processCount) continue;
            List<String> objects = this.analyzeObjects(comp, fetchList);
            this.addOrphanObjects(comp, objects);
            counter = 0;
            fetchList.clear();
        }
        if (fetchList.size() > 0) {
            List<String> objects = this.analyzeObjects(comp, fetchList);
            this.addOrphanObjects(comp, objects);
        }
        if (this.hasOrphans(comp)) {
            Integer total = this.getOrphanCount(comp);
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Analyze.OrphansFound.fmt.txt", (Object)total, (Object)comp.getComponentLabel(), (Object)this._repository.getDefaultRepositoryName());
            this._log.warn(msg);
            this._result.setWarningDetected(true);
            this._result.setRepairNeeded(true);
        } else {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Analyze.NoOrphans.fmt.txt", (Object)comp.getComponentLabel(), (Object)this._repository.getDefaultRepositoryName());
            this._log.info(msg);
        }
        fetchList.clear();
        objectList.clear();
        if (this._log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            this._log.debug("Total analysis time: " + (double)(end - t0) / 1000.0 + " seconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> analyzeObjects(OrphanObjectComponentInterface comp, Map<String, String> objectMap) throws MdException, RemoteException {
        List<String> orphans;
        long t0 = 0L;
        long t1 = 0L;
        if (this._log.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if ((orphans = this.searchForOrphans(comp, objectMap, false)).size() > 0 && this.isSecondarySearchNeeded()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Running secondary search to find orphans");
            }
            try {
                this._isSecondarySearch = true;
                LinkedHashMap<String, String> secObjectMap = new LinkedHashMap<String, String>(orphans.size());
                for (String orphanID : orphans) {
                    secObjectMap.put(orphanID, comp.getMetadataType());
                }
                orphans = this.searchForOrphans(comp, secObjectMap, true);
            }
            finally {
                this._isSecondarySearch = false;
            }
        }
        if (this._log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
            this._log.debug("Time to analyze " + objectMap.size() + " objects: " + (double)(t1 - t0) / 1000.0 + " seconds");
        }
        return orphans;
    }

    private List<String> searchForOrphans(OrphanObjectComponentInterface comp, Map<String, String> objectMap, boolean searchAllRepositories) throws MdException, RemoteException {
        String template;
        ArrayList<String> orphans = new ArrayList<String>();
        int flags = 526592;
        if (searchAllRepositories) {
            flags |= 0x4000;
        }
        if ((template = comp.getAnalyzeTemplate()) == null) {
            template = "";
            flags |= 1;
        } else {
            flags |= 4;
        }
        List objects = this._factory.getOMIUtil().getFastMetadata(objectMap, template, flags);
        if (objects != null && objects.size() > 0) {
            int length = objects.size();
            for (int i = 0; i < length; ++i) {
                String name;
                boolean orphaned;
                FastMetadata map = (FastMetadata)objects.get(i);
                String id = map.getAttribute("Id");
                if (id == null || !(orphaned = comp.isOrphan(map))) continue;
                orphans.add(id);
                if (!this._log.isDebugEnabled() || this.getOrphanCount(comp) > 100 || orphans.size() > 100 || !this.isFinalSearch() || (name = map.getAttribute("Name")) == null) continue;
                this._log.debug("Found orphaned " + comp.getComponentLabel() + ": " + name + " (" + id + ")");
            }
            objects.clear();
            objects = null;
        }
        return orphans;
    }

    private void setSearchDetails() throws ServiceException, RemoteException {
        if (!"PROJECT".equalsIgnoreCase(this._repository.getRepositoryType())) {
            List repositories = this._repository.getServer().getRepositories(true);
            for (OMIRepositoryInterface repos : repositories) {
                if (!"PROJECT".equalsIgnoreCase(repos.getRepositoryType())) continue;
                this._isSecondarySearchNeeded = true;
                return;
            }
            this._isSecondarySearchNeeded = false;
        }
    }

    private boolean isSecondarySearchNeeded() {
        return this._isSecondarySearchNeeded;
    }

    protected boolean isFinalSearch() {
        return this.isSecondarySearchNeeded() ? this._isSecondarySearch : true;
    }

    public boolean containsAssociations(FastMetadata objectMap) {
        if (objectMap != null) {
            for (Object value : objectMap.values()) {
                List assoc;
                if (!(value instanceof List) || (assoc = (List)value).size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void addOrphanObjects(OrphanObjectComponentInterface comp, List<String> objects) {
        List<String> totalOrphans = this._componentMap.get(comp);
        if (totalOrphans == null) {
            totalOrphans = new ArrayList<String>();
            this._componentMap.put(comp, totalOrphans);
        }
        totalOrphans.addAll(objects);
    }

    private boolean hasOrphans(OrphanObjectComponentInterface comp) {
        return this.getOrphanCount(comp) > 0;
    }

    private List<String> getOrphans(OrphanObjectComponentInterface comp) {
        return this._componentMap.get(comp);
    }

    private int getOrphanCount(OrphanObjectComponentInterface comp) {
        List<String> totalOrphans = this.getOrphans(comp);
        return totalOrphans != null ? totalOrphans.size() : 0;
    }

    @Override
    public void repairImpl() {
        try {
            for (OrphanObjectComponentInterface comp : this._componentMap.keySet()) {
                this.repairOrphanComponent(comp);
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (MdException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Repair.DeleteFailure.fmt.txt", (Object)this.getName(), (Object)e.getMessage());
            this._log.error(msg);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void repairOrphanComponent(OrphanObjectComponentInterface comp) throws MdException, RemoteException {
        if (!this.hasOrphans(comp)) return;
        ArrayList<ErrorCondition> conditions = new ArrayList<ErrorCondition>();
        int deletedCount = 0;
        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Repair.Objects.fmt.txt", (Object)comp.getComponentLabel()));
        String metadataType = comp.getMetadataType();
        String template = comp.getRepairTemplate();
        try {
            for (String orphanID : this.getOrphans(comp)) {
                try {
                    boolean deleted = this.deleteObject(orphanID, metadataType, template);
                    if (deleted) {
                        ++deletedCount;
                        continue;
                    }
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug("The object " + orphanID + " (" + metadataType + ") was not deleted, probably because it wasn't found on the server.");
                }
                catch (Exception e) {
                    String name = this.getObjectName(orphanID, metadataType);
                    conditions.add(new ErrorCondition(orphanID, metadataType, name, e.getLocalizedMessage()));
                    if (conditions.size() <= 100) continue;
                    throw new IllegalStateException(RB.getStringResource("AbstractOrphanObjectTool.Repair.Abort.txt"));
                    return;
                }
            }
        }
        finally {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Repair.Results.fmt.txt", (Object)comp.getComponentLabel(), (Object)new Integer(deletedCount));
            this._log.info(msg);
            if (conditions.size() > 0) {
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Repair.NumFailed.fmt.txt", (Object)new Integer(conditions.size())));
                for (ErrorCondition cond : conditions) {
                    String warnMsg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractOrphanObjectTool.Repair.ObjectDeleteFailure.fmt.txt", (Object)cond.getMetadataType(), (Object)cond.getName(), (Object)cond.getObjectID(), (Object)cond.getReason());
                    this._log.warn(warnMsg);
                }
                this._result.setWarningDetected(true);
            }
        }
    }

    private String getObjectName(String id, String metadataType) {
        ArrayList<String> attrs = new ArrayList<String>(1);
        attrs.add("Name");
        try {
            CMetadata meta = this._factory.getOMIUtil().getMetadataAllDepths((MdStore)this._store, metadataType, id, attrs, null, "", 0);
            return meta.getName();
        }
        catch (Exception e) {
            this._log.debug("Failure retrieving object name");
            return "";
        }
    }

    protected boolean deleteObject(String id, String metadataType, String template) throws RemoteException, MdException {
        List deletedList = this._factory.getOMIUtil().deleteMetadataObject(metadataType, id, template);
        return deletedList != null && deletedList.size() > 0;
    }

    class ErrorCondition {
        String id = null;
        String metadataType = null;
        String name = null;
        String reason = null;

        public ErrorCondition(String id, String type, String name, String reason) {
            this.id = id;
            this.metadataType = type;
            this.name = name;
            this.reason = reason;
        }

        public String getObjectID() {
            return this.id;
        }

        public String getMetadataType() {
            return this.metadataType;
        }

        public String getName() {
            return this.name;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

