/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl;

import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;

public class RequestContext {
    private SessionContextInterface session;
    private UserContextInterface user;
    private MetadataServerInterface server;
    private MdFactory factory;
    private IServer iserver;
    private boolean error;
    private boolean warning;

    RequestContext(SessionContextInterface session) {
        this.session = session;
        try {
            this.user = session.getUserContext();
            this.server = (MetadataServerInterface)this.user.getAuthServer();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public SessionContextInterface getSession() {
        return this.session;
    }

    public UserContextInterface getUser() {
        return this.user;
    }

    public MetadataServerInterface getServer() {
        return this.server;
    }

    public MdFactory getFactory() {
        if (this.factory == null) {
            this.factory = ((OMIServer)this.server).getMdFactory();
        }
        return this.factory;
    }

    public OMIRepositoryInterface getRepository(String name) {
        try {
            return (OMIRepositoryInterface)this.server.getRepository(name);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public IServer getIServer() {
        if (this.iserver == null) {
            try {
                this.iserver = this.getFactory().getConnection().MakeIServerConnection();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            catch (MdException e) {
                throw new RuntimeException(e);
            }
        }
        return this.iserver;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public void setWarning(boolean warning) {
        this.warning = warning;
    }
}

