/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogCapture {
    WriterAppender appender;
    StringWriter writer;
    Logger logger;

    public LogCapture(Logger logger) {
        this.startLogging(logger);
    }

    public void startLogging(Logger logger) {
        this.logger = logger;
        this.writer = new StringWriter();
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration logconfig = lc.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(logconfig).withPattern("%-5p %m%n").build();
        this.appender = ((WriterAppender.Builder)((WriterAppender.Builder)((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setName("LogCapture appender")).setTarget((Writer)this.writer).setLayout((Layout)layout)).setFilter((Filter)new ThreadFilter())).setConfiguration(logconfig)).build();
        this.appender.start();
        logconfig.addAppender((Appender)this.appender);
        lc.getLogger(logger.getName()).addAppender((Appender)this.appender);
    }

    public String endLogging() {
        if (this.appender == null) {
            return null;
        }
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = lc.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(this.logger.getName());
        loggerConfig.removeAppender(this.appender.getName());
        this.appender.stop();
        return this.writer.toString();
    }

    @Plugin(name="ThreadFilter", category="Core", elementType="filter", printObject=true)
    public final class ThreadFilter
    extends AbstractFilter {
        Thread loggingThread = Thread.currentThread();

        ThreadFilter() {
        }

        public Filter.Result filter(LogEvent arg0) {
            if (this.loggingThread == Thread.currentThread()) {
                return Filter.Result.NEUTRAL;
            }
            return Filter.Result.DENY;
        }

        @PluginFactory
        public ThreadFilter createFilter() {
            return new ThreadFilter();
        }
    }
}

