/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tk.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;

public class logOutput {
    private static FileOutputStream logfile;
    private static PrintStream plogfile;
    private static RandomAccessFile fd;
    private static File parentFile;
    private static PrintStream originalOut;
    private static PrintStream originalErr;

    public static synchronized byte[] snapLog() {
        byte[] rc;
        try {
            if (fd == null) {
                fd = new RandomAccessFile(parentFile, "r");
            }
            int length = (int)(fd.length() - fd.getFilePointer());
            rc = new byte[length];
            fd.read(rc);
        }
        catch (Exception e) {
            rc = new byte[]{};
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int stopLog() {
        int rc = 0;
        try {
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
        catch (SecurityException e) {
            rc = -1;
        }
        if (parentFile == null) {
            return -1;
        }
        if (logfile != null) {
            try {
                logfile.flush();
                logfile.close();
            }
            catch (IOException ioe) {
                rc = -1;
            }
            finally {
                logfile = null;
            }
        }
        if (plogfile != null) {
            plogfile.close();
            plogfile = null;
        }
        try {
            if (fd != null) {
                fd.close();
            }
        }
        catch (IOException ioe) {
            rc = -1;
        }
        finally {
            fd = null;
        }
        if (parentFile != null) {
            try {
                parentFile.delete();
            }
            catch (SecurityException se) {
                rc = -1;
            }
            finally {
                parentFile = null;
            }
        }
        return rc;
    }

    public static synchronized int startLog(String filename) {
        int rc = 0;
        if (parentFile != null) {
            return -1;
        }
        try {
            parentFile = new File(filename);
            logfile = new FileOutputStream(parentFile);
            plogfile = new PrintStream(logfile);
            System.setOut(plogfile);
            System.setErr(plogfile);
        }
        catch (IOException e) {
            logOutput.stopLog();
            rc = -1;
        }
        return rc;
    }

    public static int startLog() {
        String filename = System.getProperty("user.home") + "\\Application Data\\SAS\\LOGS\\sasjavaout.log";
        return logOutput.startLog(filename);
    }

    public static int startLog(long n1, long n2) {
        StringBuffer filename = new StringBuffer(256);
        String fileSeparator = System.getProperty("file.separator");
        filename.append(System.getProperty("user.home"));
        filename.append(fileSeparator);
        filename.append("Application Data");
        filename.append(fileSeparator);
        filename.append("SAS");
        filename.append(fileSeparator);
        filename.append("LOGS");
        filename.append(fileSeparator);
        filename.append("sasjava.");
        filename.append(Long.toHexString(n1));
        filename.append(".");
        filename.append(Long.toHexString(n2));
        filename.append(".log");
        int rc = logOutput.startLog(filename.toString());
        if (rc != 0) {
            filename.setLength(0);
            filename.append(System.getProperty("java.io.tmpdir"));
            filename.append(fileSeparator);
            filename.append("sasjava.");
            filename.append(Long.toHexString(n1));
            filename.append(".");
            filename.append(Long.toHexString(n2));
            filename.append(".log");
            rc = logOutput.startLog(filename.toString());
        }
        return rc;
    }

    public static byte[] getSeparationChars() {
        return System.getProperty("line.separator").getBytes();
    }

    public static byte[] getLogFilename() {
        byte[] rc;
        if (parentFile != null) {
            byte[] byteName = parentFile.getAbsolutePath().getBytes();
            rc = new byte[byteName.length + 1];
            System.arraycopy(byteName, 0, rc, 0, byteName.length);
            rc[byteName.length] = 0;
        } else {
            rc = new byte[]{};
        }
        return rc;
    }

    private logOutput() {
    }

    static {
        plogfile = null;
        fd = null;
        parentFile = null;
        originalOut = System.out;
        originalErr = System.err;
    }
}

