/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.RecoveryOptions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@JsonPropertyOrder(value={"name", "comment", "pauseComment", "includeConfig", "reorganizeRepositories", "rollForward", "verify", "instanceName", "exclude"})
@XmlRootElement(name="RecoveryOptions")
public class RecoveryOptionsMapper {
    private RecoveryOptions recoveryOptions;

    @XmlElement
    public String getName() {
        return this.getRecoveryOptions().getRecvoerySlugName();
    }

    public void setName(String name) {
        this.getRecoveryOptions().setRecvoerySlugName(name);
    }

    @XmlElement
    public String getInstanceName() {
        return this.getRecoveryOptions().getInstanceName();
    }

    public void setInstanceName(String instanceName) {
        this.getRecoveryOptions().setInstanceName(instanceName);
    }

    public RecoveryOptionsMapper() {
    }

    public RecoveryOptionsMapper(RecoveryOptions recoveryOptions) {
        this.recoveryOptions = recoveryOptions;
    }

    @XmlElement
    public RecoveryOptions getRecoveryOptions() {
        if (this.recoveryOptions == null) {
            this.recoveryOptions = new RecoveryOptions();
        }
        return this.recoveryOptions;
    }

    public void setForced(boolean forced) {
        this.getRecoveryOptions().setForced(forced);
    }

    public boolean isForced() {
        return this.getRecoveryOptions().isForced();
    }

    @XmlElement
    public List<String> getExclude() {
        List excludedSources = this.getRecoveryOptions().getExcludeFilter();
        ArrayList<String> excludedSourceNames = null;
        for (BackupSourceConfig.BackupSource source : excludedSources) {
            if (excludedSourceNames == null) {
                excludedSourceNames = new ArrayList<String>();
            }
            excludedSourceNames.add(source.name());
        }
        return excludedSourceNames;
    }

    public void setExclude(List<String> exclude) {
        ArrayList<BackupSourceConfig.BackupSource> excludeFilters = new ArrayList<BackupSourceConfig.BackupSource>();
        if (exclude != null && exclude.size() > 0) {
            for (String filter : exclude) {
                BackupSourceConfig.BackupSource[] sourceValues;
                for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
                    if (!source.getDisplayName().equalsIgnoreCase(filter)) continue;
                    excludeFilters.add(source);
                }
            }
            if (excludeFilters.size() > 0) {
                this.getRecoveryOptions().setExcludeFilter(excludeFilters);
            }
        }
    }

    @XmlElement
    public String getComment() {
        return this.getRecoveryOptions().getComment();
    }

    public void setComment(String comment) {
        this.getRecoveryOptions().setComment(comment);
    }

    @XmlElement
    public boolean isIncludeMetadataConfig() {
        return this.getRecoveryOptions().isIncludeConfig();
    }

    public void setIncludeMetadataConfig(boolean includeConfig) {
        this.getRecoveryOptions().setIncludeConfig(includeConfig);
    }

    @XmlElement
    public String getPauseComment() {
        return this.getRecoveryOptions().getPauseComment();
    }

    public void setPauseComment(String pauseComment) {
        this.getRecoveryOptions().setPauseComment(pauseComment);
    }

    @XmlElement
    public boolean isReorganizeMetadataRepositories() {
        return this.getRecoveryOptions().isReorganizeRepositories();
    }

    public void setReorganizeMetadataRepositories(boolean reorganizeRepositories) {
        this.getRecoveryOptions().setReorganizeRepositories(reorganizeRepositories);
    }

    @XmlElement
    public Date getRollForward() {
        return this.getRecoveryOptions().getRollForward();
    }

    public void setRollForward(Date rollForward) {
        this.getRecoveryOptions().setRollForward(rollForward);
    }

    @XmlElement
    public boolean isVerify() {
        return this.getRecoveryOptions().isVerify();
    }

    public void setVerify(boolean verify) {
        this.getRecoveryOptions().setVerify(verify);
    }
}

