/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.svcs.admin.backup.rest.BackupController;
import com.sas.svcs.admin.backup.rest.model.BackupHostDetail;
import com.sas.svcs.admin.backup.rest.model.BackupSourceEntryDetail;
import com.sas.svcs.admin.backup.rest.model.BackupSourceInstanceDetails;
import com.sas.svcs.admin.backup.rest.model.OperationDetailedData;
import com.sas.svcs.admin.backup.rest.model.OperationSourceDetail;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.BackupSourceEntryDetails;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.dao.BackupServiceUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@JsonPropertyOrder(value={"id", "name", "type", "status", "comment", "pauseComment", "scheduled", "runBy", "startTimeStamp", "endTimeStamp", "backupId", "errorMessage", "backupSources", "links"})
@XmlRootElement(name="recoveryDetails")
public class RecoveryDetailData
extends OperationDetailedData {
    private Links links = new Links();

    public RecoveryDetailData() {
    }

    public RecoveryDetailData(OperationDetails recoveryDetails) {
        super(recoveryDetails);
        String bkupid = this.getBackupId();
        if (bkupid != null) {
            Links links = new Links();
            Link link = new Link("get", "backup", "/backups/" + bkupid);
            link.setType("application/vnd.sas.admin.backup");
            links.add(link);
            this.setLinks(links.getLinks());
        }
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links.getLinks();
    }

    public void setLinks(List<Link> links) {
        this.links = new Links(links);
    }

    @XmlElement
    public String getPauseComment() {
        if (this.operationDetails instanceof RecoveryDetails) {
            return ((RecoveryDetails)this.operationDetails).getPauseComments();
        }
        return "";
    }

    @XmlElement
    public String getBackupId() {
        BackupDetails bkupDets;
        if (this.operationDetails instanceof RecoveryDetails && (bkupDets = ((RecoveryDetails)this.operationDetails).getBackupDetails()) != null) {
            return bkupDets.getName();
        }
        return null;
    }

    @XmlElement
    public Collection<OperationSourceDetail> getBackupSources() {
        List sourceDetails = this.operationDetails.getSourceDetails();
        LinkedList<OperationSourceDetail> srcDets = new LinkedList<OperationSourceDetail>();
        HashMap hostsForSource = new HashMap();
        for (BackupSourceDetails srcDetail : sourceDetails) {
            List hosts = null;
            String souceType = srcDetail.getSourceConfig().getSourceType().getDisplayName();
            BackupHostDetail temp = null;
            hosts = !hostsForSource.containsKey(souceType) ? new LinkedList() : (List)hostsForSource.get(souceType);
            temp = new BackupHostDetail(srcDetail.getSourceConfig().getBackupSourceNode());
            temp.setSize(srcDetail.getSize());
            temp.setBackupLocation(srcDetail.getBackupLocation());
            temp.setLogFilePath(srcDetail.getLogFilePath());
            Map instanceDetails = srcDetail.getSourceInstances();
            if (instanceDetails != null) {
                Set keys = instanceDetails.keySet();
                LinkedList<BackupSourceInstanceDetails> instancesCollection = new LinkedList<BackupSourceInstanceDetails>();
                for (String key : keys) {
                    LinkedList<BackupSourceEntryDetail> srcEntryDets = new LinkedList<BackupSourceEntryDetail>();
                    com.sas.svcs.backup.client.BackupSourceInstanceDetails instanceDetail = (com.sas.svcs.backup.client.BackupSourceInstanceDetails)instanceDetails.get(key);
                    BackupSourceInstanceDetails tempInstance = new BackupSourceInstanceDetails(instanceDetail.getInstanceName(), instanceDetail.getHost(), instanceDetail.getPort());
                    List sourceEntries = instanceDetail.getSourceEntries();
                    if (sourceEntries != null && !sourceEntries.isEmpty()) {
                        for (BackupSourceEntryDetails sourceEntry : sourceEntries) {
                            if (instanceDetail.getBackupHoldingNode() == null || !BackupServiceUtils.isHostsEqual((String)instanceDetail.getBackupHoldingNode(), (String)temp.getHostName())) continue;
                            BackupSourceEntryDetail srcEntry = new BackupSourceEntryDetail(sourceEntry);
                            srcEntryDets.add(srcEntry);
                        }
                        tempInstance.setSourceEntries(srcEntryDets);
                    }
                    instancesCollection.add(tempInstance);
                }
                temp.setSourceInstances(instancesCollection);
            }
            this.updateIncludedPaths(srcDetail, temp);
            if (srcDetail.getStatus() != null) {
                BackupController.serviceSideStatusConstants tempsts = BackupController.serviceSideStatusConstants.valueOf(srcDetail.getStatus().toString());
                if (tempsts != null) {
                    temp.setStatus(tempsts.toString());
                } else {
                    temp.setStatus(BackupController.serviceSideStatusConstants.UNKNOWN.toString());
                }
            }
            hosts.add(temp);
            if (hostsForSource.get(souceType) != null) {
                hostsForSource.remove(souceType);
            }
            hostsForSource.put(souceType, hosts);
        }
        if (sourceDetails != null) {
            HashSet<String> srcTypes = new HashSet<String>();
            for (BackupSourceDetails sourceDetail : sourceDetails) {
                if (srcTypes.contains(sourceDetail.getSourceConfig().getSourceType().getDisplayName())) continue;
                OperationSourceDetail srcDet = new OperationSourceDetail(sourceDetail);
                srcDet.setHosts((Collection)hostsForSource.get(srcDet.getSourceType()));
                srcDets.add(srcDet);
                srcTypes.add(srcDet.getSourceType());
            }
        }
        return srcDets;
    }
}

