/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.svcs.admin.backup.rest.BackupController;
import com.sas.svcs.admin.backup.rest.model.BackupHostDetail;
import com.sas.svcs.admin.backup.rest.model.BackupSourceInstanceDetails;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.OperationDetails;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@JsonPropertyOrder(value={"sourceType", "status", "serverSideReturnCode", "hosts"})
@XmlRootElement
public class OperationSourceDetail {
    private Collection<BackupHostDetail> hostDets;
    private Collection<BackupSourceInstanceDetails> sourceInstances;
    BackupSourceDetails sourceDetails;

    public Collection<BackupHostDetail> readHostDets() {
        return this.hostDets;
    }

    public OperationSourceDetail() {
    }

    public OperationSourceDetail(BackupSourceDetails sourceDetails) {
        this.sourceDetails = sourceDetails;
    }

    protected BackupSourceDetails readSourceDetails() {
        if (this.sourceDetails == null) {
            this.sourceDetails = new BackupSourceDetails();
        }
        return this.sourceDetails;
    }

    @XmlElement
    public String getServerSideReturnCode() {
        int intCode = this.readSourceDetails().getServerSideErrorCode();
        String returnCode = intCode == 0 ? null : String.valueOf(intCode);
        return returnCode;
    }

    public void setServerSideReturnCode(String errorCode) {
        this.readSourceDetails().setServerSideErrorCode(Integer.parseInt(errorCode));
    }

    @XmlElement
    public String getStatus() {
        OperationDetails.OperationStatus status = this.readSourceDetails().getStatus();
        if (status != null) {
            String srcStatus = this.readSourceDetails().getStatus().toString();
            return BackupController.serviceSideStatusConstants.valueOf(srcStatus).toString();
        }
        return BackupController.serviceSideStatusConstants.UNKNOWN.toString();
    }

    public void setStatus(String status) {
        for (BackupController.serviceSideStatusConstants sts : BackupController.serviceSideStatusConstants.values()) {
            if (!sts.toString().equals(status)) continue;
            this.readSourceDetails().setStatus(OperationDetails.OperationStatus.valueOf((String)sts.name()));
        }
    }

    @XmlElement
    public String getSourceType() {
        BackupSourceConfig sourceConfig = this.readSourceDetails().getSourceConfig();
        return sourceConfig != null ? (sourceConfig.getSourceType() != null ? sourceConfig.getSourceType().getDisplayName() : null) : null;
    }

    public void setSourceType(String sourceType) {
        BackupSourceConfig.BackupSource[] sourceValues;
        BackupSourceConfig sourceConfig = this.readSourceDetails().getSourceConfig();
        for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
            if (!source.getDisplayName().equalsIgnoreCase(sourceType)) continue;
            sourceConfig.setSourceType(source);
        }
    }

    @XmlElement
    public Collection<BackupHostDetail> getHosts() {
        return this.hostDets;
    }

    public void setHosts(Collection<BackupHostDetail> hosts) {
        this.hostDets = hosts;
    }
}

