/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.commons.rest.util.Timestamp;
import com.sas.svcs.admin.backup.rest.BackupController;
import com.sas.svcs.admin.backup.rest.model.BackupSourceDetail;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupSourceDetails;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.common.definitions.BackupException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@JsonPropertyOrder(value={"id", "name", "type", "status", "runBy", "scheduled", "startTimeStamp", "endTimeStamp", "backupSources"})
@XmlRootElement
public class OperationHistoryData {
    OperationDetails operationDetails;

    public OperationHistoryData() {
    }

    protected OperationDetails readOprDetails() {
        if (this.operationDetails == null) {
            this.operationDetails = new BackupDetails();
        }
        return this.operationDetails;
    }

    public OperationHistoryData(OperationDetails operationDetails) {
        this.operationDetails = operationDetails;
    }

    @XmlElement
    public String getId() {
        return this.operationDetails.getName();
    }

    public void setId(String name) {
        this.readOprDetails().setName(name);
    }

    @XmlElement
    public String getName() {
        return this.operationDetails.getSlug();
    }

    public void setName(String slug) {
        this.readOprDetails().setSlug(slug);
    }

    @XmlElement
    public String getType() {
        return this.operationDetails.getType();
    }

    public void setType(String type) {
        this.readOprDetails().setType(type);
    }

    @XmlElement
    public String getStartTimeStamp() {
        Date startDate = this.operationDetails.getStartTime();
        if (startDate != null) {
            return Timestamp.timestamp((Date)startDate);
        }
        return "";
    }

    public void setStartTimeStamp(String startTime) {
        SimpleDateFormat dtgFormat = new SimpleDateFormat("E-dd-MMM:HH:mm:ss-yyyy");
        this.readOprDetails().setStartTime(new Date(startTime));
    }

    @XmlElement
    public String getEndTimeStamp() {
        Date endDate = this.operationDetails.getEndTime();
        if (endDate != null) {
            return Timestamp.timestamp((Date)endDate);
        }
        return "";
    }

    public void setEndTimeStamp(String endTime) {
        this.readOprDetails().setEndTime(new Date(endTime));
    }

    @XmlElement
    public String getStatus() {
        String status = this.operationDetails.getStatus().toString();
        if (status != null) {
            return BackupController.serviceSideStatusConstants.valueOf(status).toString();
        }
        return "UNKNOWN";
    }

    public void setStatus(String status) {
        for (BackupController.serviceSideStatusConstants sts : BackupController.serviceSideStatusConstants.values()) {
            if (!sts.toString().equals(status)) continue;
            try {
                this.readOprDetails().setStatus(OperationDetails.OperationStatus.valueOf((String)sts.name()));
            }
            catch (BackupException e) {
                e.printStackTrace();
            }
        }
    }

    @XmlElement
    public boolean isScheduled() {
        return this.operationDetails.isScheduled();
    }

    public void setScheduled(boolean isScheduled) {
        this.readOprDetails().setScheduled(isScheduled);
    }

    @XmlElement
    public String getRunBy() {
        return this.operationDetails.getRunBy();
    }

    public void setRunBy(String runBy) {
        this.readOprDetails().setRunBy(runBy);
    }

    public void setSize(String size) {
    }

    @XmlElement
    public Collection<BackupSourceDetail> getBackupSources() {
        List sourceDetails = this.operationDetails.getSourceDetails();
        LinkedList<BackupSourceDetail> srcDets = new LinkedList<BackupSourceDetail>();
        if (sourceDetails != null) {
            for (BackupSourceDetails sourceDetail : sourceDetails) {
                srcDets.add(new BackupSourceDetail(sourceDetail));
            }
        }
        return srcDets;
    }

    public void setBackupSources(Collection<BackupSourceDetail> sources) {
        this.readOprDetails().setSourceDetails(new ArrayList<BackupSourceDetail>(sources));
    }
}

