/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.svcs.admin.backup.rest.model.OperationHistoryData;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.OperationDetails;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@JsonPropertyOrder(value={"id", "name", "type", "status", "size", "runBy", "scheduled", "startTimeStamp", "endTimeStamp", "purged", "backupSources", "links"})
@XmlRootElement(name="history")
public class BackupHistoryData
extends OperationHistoryData {
    private Links links = new Links();

    public BackupHistoryData() {
    }

    public BackupHistoryData(OperationDetails operationDetails) {
        super(operationDetails);
        if (operationDetails.getName() != null) {
            Link link = new Link("get", "self", "/backups/" + operationDetails.getName());
            link.setType("application/vnd.sas.admin.backup");
            Links links = new Links();
            links.add(link);
            this.setLinks(links.getLinks());
        }
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links.getLinks();
    }

    public void setLinks(List<Link> links) {
        this.links = new Links(links);
    }

    @XmlElement
    public long getSize() {
        long size = this.operationDetails.getSize();
        return size;
    }

    public void setSize(long size) {
        this.readOprDetails().setSize(size);
    }

    @XmlElement
    public Boolean isPurged() {
        OperationDetails.OperationStatus oprStatus = this.operationDetails.getStatus();
        if (oprStatus != null && oprStatus != OperationDetails.OperationStatus.NOT_STARTED) {
            return ((BackupDetails)this.operationDetails).isOffline();
        }
        return null;
    }
}

