/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.svcs.admin.backup.rest.model.BackupSourceConfiguration;
import com.sas.svcs.admin.backup.rest.model.HostDetailData;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupSourceConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@JsonPropertyOrder(value={"id", "vaultLocation", "emailToList", "scheduledBackupsAllowed", "daysToRetainBackup", "backupSources"})
@XmlRootElement(name="configuration")
public class BackupConfig {
    private String id = "default";
    private Links links = new Links();
    public Boolean scheduledAllowed = null;
    private BackupConfiguration backupConfig;

    public BackupConfig() {
        Link link = new Link("put", "update", "/configurations/" + this.id);
        Links links = new Links();
        links.add(link);
        this.setLinks(links.getLinks());
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links.getLinks();
    }

    public void setLinks(List<Link> links) {
        this.links = new Links(links);
    }

    public BackupConfiguration readBackupConfigObject() {
        return this.backupConfig;
    }

    public void setBackupConfig(BackupConfiguration backupConfig) {
        this.backupConfig = backupConfig;
    }

    public BackupConfig(BackupConfiguration backupConfig) {
        this.backupConfig = backupConfig;
        Link link = new Link("put", "update", "/configurations/" + this.id);
        Links links = new Links();
        links.add(link);
        this.setLinks(links.getLinks());
    }

    private BackupConfiguration getBackupConfigInstance() {
        if (this.backupConfig == null) {
            this.backupConfig = new BackupConfiguration();
        }
        return this.backupConfig;
    }

    @XmlElement
    public String[] getEmailToList() {
        return this.getBackupConfigInstance().getEmailToList();
    }

    public void setEmailToList(String[] emailToList) {
        if (emailToList != null) {
            this.getBackupConfigInstance().setEmailToList(emailToList);
        }
    }

    @XmlElement
    public String getVaultLocation() {
        return this.getBackupConfigInstance().getVaultLocation();
    }

    @XmlElement
    public boolean getScheduledBackupsAllowed() {
        return this.getBackupConfigInstance().isScheduledBackupsAllowed();
    }

    @XmlElement
    public int getDaysToRetainBackup() {
        return this.getBackupConfigInstance().getDaysToRetainBackups();
    }

    public void setVaultLocation(String vaultLocation) {
        if (vaultLocation != null) {
            this.getBackupConfigInstance().setVaultLocation(vaultLocation);
        }
    }

    public void setScheduledBackupsAllowed(Boolean scheduledAllowed) {
        this.scheduledAllowed = scheduledAllowed;
        this.getBackupConfigInstance().setScheduledBackupsAllowed(scheduledAllowed.booleanValue());
    }

    public void setDaysToRetainBackup(int days) {
        if (days == 0) {
            days = -1;
        }
        this.getBackupConfigInstance().setDaysToRetainBackups(days);
    }

    @XmlElement
    public Collection<BackupSourceConfiguration> getBackupSources() {
        List sourceConfigs = this.getBackupConfigInstance().getSources();
        LinkedList<BackupSourceConfiguration> srcConfs = new LinkedList<BackupSourceConfiguration>();
        HashMap hostsForSource = new HashMap();
        for (BackupSourceConfig srcConfig : sourceConfigs) {
            List<HostDetailData> hosts = null;
            String souceType = srcConfig.getSourceType().name();
            HostDetailData temp = null;
            if (!hostsForSource.containsKey(souceType)) {
                hosts = new LinkedList();
                temp = new HostDetailData(srcConfig.getBackupSourceNode());
                hosts.add(temp);
                hostsForSource.put(souceType, hosts);
                continue;
            }
            hosts = (List)hostsForSource.get(souceType);
            temp = new HostDetailData(srcConfig.getBackupSourceNode());
            hosts.add(new HostDetailData(srcConfig.getBackupSourceNode()));
        }
        if (sourceConfigs != null) {
            HashSet<String> srcTypes = new HashSet<String>();
            for (BackupSourceConfig sourceConfig : sourceConfigs) {
                BackupSourceConfiguration bkSrcCnfg = new BackupSourceConfiguration(sourceConfig);
                bkSrcCnfg.setHosts((Collection)hostsForSource.get(sourceConfig.getSourceType().name()));
                if (srcTypes.contains(sourceConfig.getSourceType().name())) continue;
                srcConfs.add(bkSrcCnfg);
                srcTypes.add(sourceConfig.getSourceType().name());
            }
        }
        return srcConfs;
    }

    public void setBackupSources(Collection<BackupSourceConfiguration> configs) {
        ArrayList<BackupSourceConfig> sourceConfigs = new ArrayList<BackupSourceConfig>();
        for (BackupSourceConfiguration config : configs) {
            Collection<HostDetailData> hosts = config.getHosts();
            for (HostDetailData host : hosts) {
                BackupSourceConfig.BackupSource[] sourceValues;
                BackupSourceConfig sourceConfig = new BackupSourceConfig();
                sourceConfig.setBackupSourceNode(host.readBackupSourceNode());
                for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
                    if (!source.getDisplayName().equalsIgnoreCase(config.getSourceType())) continue;
                    sourceConfig.setSourceType(source);
                }
                sourceConfigs.add(sourceConfig);
            }
        }
        if (sourceConfigs.size() > 0) {
            this.getBackupConfigInstance().setSources(sourceConfigs);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

