/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest.model;

import com.sas.svcs.backup.analyze.model.AnalysisResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AnalysisResultData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<AnalysisProblemData> analysisProblems = new ArrayList<AnalysisProblemData>();

    public List<AnalysisProblemData> getAnalysisProblems() {
        return this.analysisProblems;
    }

    public boolean addAnalysisProblemData(AnalysisProblemData problemData) {
        return this.analysisProblems.add(problemData);
    }

    public static AnalysisResultData getInstance(AnalysisResult analysisResult) {
        AnalysisResultData analysisResultData = new AnalysisResultData();
        for (AnalysisResult.AnalysisProblem problem : analysisResult.getAllSourcesErrors()) {
            analysisResultData.addAnalysisProblemData(new AnalysisProblemData(problem));
        }
        return analysisResultData;
    }

    public static class AnalysisProblemData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int statusCode;
        private String possibleCause;
        private String remedyMessage;

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getPossibleCause() {
            return this.possibleCause != null && !this.possibleCause.isEmpty() ? this.possibleCause : null;
        }

        public String getRemedyMessage() {
            return this.remedyMessage != null && !this.remedyMessage.isEmpty() ? this.remedyMessage : null;
        }

        public AnalysisProblemData(AnalysisResult.AnalysisProblem problem) {
            if (problem != null) {
                this.statusCode = problem.getStatusCode();
                this.possibleCause = problem.getPossibleCause();
                this.remedyMessage = problem.getRemedyMessage();
            }
        }
    }
}

