/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest;

import com.sas.svcs.admin.backup.rest.RBUtils;
import com.sas.svcs.admin.backup.rest.model.BackupErrorData;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class ServiceAccessControlUtil {
    private static final Logger logger = LogManager.getLogger(ServiceAccessControlUtil.class);
    public static final String UNRESTRICTED_ADMIN_AUTHORITY_ROLE = "META: Unrestricted Users Role";
    public static final String ADMIN_AUTHORITY_GROUP = "GROUP_SASAdministrators";
    public static final String AUTHORIZATION_FORBIDDEN_KEY = "BackupController.api.access.forbidden.txt";
    public static final String UNRESTRICTED_ROLE_OR_ADMIN_AUTHORIZATION_REQUIRED_KEY = "BackupController.api.access.forbidden.unrestricted.admin.role.required.txt";
    public static final String[] AUTHORITIES = new String[]{"META: Unrestricted Users Role", "GROUP_SASAdministrators"};
    @Autowired
    RBUtils rbUtils;

    public boolean isUserAuthorizedForRequest() {
        logger.trace("Inside isUserAuthorizedForRequest");
        Collection auths = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        for (String authority : AUTHORITIES) {
            for (GrantedAuthority obj : auths) {
                if (!authority.equalsIgnoreCase(obj.getAuthority())) continue;
                return true;
            }
        }
        return false;
    }

    public ResponseEntity<BackupErrorData> getBackupErrorForForbiddenAccessForRESTApi() {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        ResponseEntity restAPIForbiddenError = new ResponseEntity((Object)new BackupErrorData(HttpStatus.FORBIDDEN.value(), this.rbUtils.getPropertyValueFromRB(AUTHORIZATION_FORBIDDEN_KEY), AUTHORIZATION_FORBIDDEN_KEY, this.rbUtils.getPropertyValueFromRB(UNRESTRICTED_ROLE_OR_ADMIN_AUTHORIZATION_REQUIRED_KEY), UNRESTRICTED_ROLE_OR_ADMIN_AUTHORIZATION_REQUIRED_KEY), (MultiValueMap)responseHeaders, HttpStatus.FORBIDDEN);
        return restAPIForbiddenError;
    }
}

