/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.svcs.admin.backup.rest.model.ConfigurableServerProxyData;
import com.sas.svcs.admin.backup.rest.model.ConfigurableServerProxyLinksData;
import com.sas.svcs.admin.backup.rest.model.ConfigurationFilterData;
import com.sas.svcs.admin.backup.rest.model.SASTierData;
import com.sas.svcs.admin.backup.rest.model.UserBackupConfigData;
import com.sas.svcs.admin.backup.rest.model.UserOptionsData;
import com.sas.svcs.admin.backup.rest.model.UserSourceConfigData;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.ConfigurationFilter;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.UserBackupConfiguration;
import com.sas.svcs.backup.client.UserOptionsProxy;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Repository;

@Repository(value="RestServiceBeanConverter")
public class RestServiceBeanConverter {
    public UserBackupConfigData getRestObjectUserBackupConfig(UserBackupConfiguration serviceConfig, String configurationid) {
        UserBackupConfigData proxyData = new UserBackupConfigData();
        proxyData.setVaultLocation(serviceConfig.getVaultLocation());
        proxyData.setDaysToRetainBackup(serviceConfig.getDaysToRetainBackups());
        proxyData.setEmailToList(serviceConfig.getEmailToList());
        proxyData.setScheduledBackupsAllowed(serviceConfig.isScheduledBackupsAllowed());
        ConfigurationFilterData cfdFilter = null;
        ConfigurationFilter cfFilter = serviceConfig.getFilter();
        if (cfFilter != null) {
            cfdFilter = new ConfigurationFilterData();
            if (cfFilter.getExcludes() != null && cfFilter.getExcludes().size() > 0) {
                cfdFilter.setExcludes(cfFilter.getExcludes());
            }
            if (cfFilter.getIncludes() != null && cfFilter.getIncludes().size() > 0) {
                cfdFilter.setIncludes(cfFilter.getIncludes());
            }
        }
        if (cfdFilter != null) {
            proxyData.setFilter(cfdFilter);
        }
        List lstServiceSourceConfig = serviceConfig.getSources();
        ArrayList<UserSourceConfigData> lstSrcProxyData = null;
        if (lstServiceSourceConfig != null && lstServiceSourceConfig.size() > 0) {
            lstSrcProxyData = new ArrayList<UserSourceConfigData>(lstServiceSourceConfig.size());
            UserSourceConfigData srcProxyData = null;
            for (UserSourceConfiguration cfg : lstServiceSourceConfig) {
                srcProxyData = this.getRestUserConfigObject(cfg, configurationid, cfg.getSourceType(), false);
                if (srcProxyData == null) continue;
                lstSrcProxyData.add(srcProxyData);
            }
            if (lstSrcProxyData != null && lstSrcProxyData.size() > 0) {
                proxyData.setSourceconfiguration(lstSrcProxyData);
            }
        }
        return proxyData;
    }

    public UserBackupConfiguration getServiceObjectUserBackupConfig(UserBackupConfigData proxyData) {
        UserBackupConfiguration serviceData = new UserBackupConfiguration();
        serviceData.setVaultLocation(proxyData.getVaultLocation());
        serviceData.setDaysToRetainBackups(proxyData.getDaysToRetainBackup());
        serviceData.setEmailToList(proxyData.getEmailToList());
        serviceData.setScheduledBackupsAllowed(proxyData.getScheduledBackupsAllowed());
        serviceData.setId(proxyData.getId());
        ConfigurationFilter proxyFilter = this.getServiceObjectFilter(proxyData.getFilter());
        if (proxyFilter != null) {
            serviceData.setFilter(proxyFilter);
        }
        return serviceData;
    }

    public SASTierProxy getServiceTierObject(SASTierData tier) {
        SASTierProxy proxy = new SASTierProxy();
        proxy.setIncluded(tier.isIncluded());
        proxy.setSasConfig(tier.getSasConfig());
        proxy.setSasHome(tier.getSasHome());
        proxy.setTierHost(tier.getTierHost());
        proxy.setTierName(tier.getTierName());
        proxy.setTierDisplayName(tier.getTierDisplayName());
        return proxy;
    }

    public SASTierData getDataObject(SASTierProxy tier) {
        SASTierData tierData = new SASTierData();
        tierData.setTierHost(tier.getTierHost());
        tierData.setSasHome(tier.getSasHome());
        tierData.setSasConfig(tier.getSasConfig());
        tierData.setTierName(tier.getTierName());
        tierData.setId(tier.getTierName());
        if (tier.isIncluded() != null) {
            tierData.setIncluded(tier.isIncluded());
        }
        tierData.setTierDisplayName(tier.getTierDisplayName());
        return tierData;
    }

    public ConfigurableServerProxy getServiceConfigurableServerObject(ConfigurableServerProxyData configurableServer) {
        UserOptionsProxy optionsProxy;
        ConfigurationFilter proxyFilter;
        ConfigurableServerProxy configurableServerProxy = new ConfigurableServerProxy();
        configurableServerProxy.setSasTierId(configurableServer.getSasTierId());
        configurableServerProxy.setConfigurablePath(configurableServer.getConfigurablePath());
        configurableServerProxy.setName(configurableServer.getName());
        if (configurableServer.isIncluded() != null) {
            configurableServerProxy.setIncluded(configurableServer.isIncluded());
        }
        if ((proxyFilter = this.getServiceObjectFilter(configurableServer.getFilter())) != null) {
            configurableServerProxy.setFilter(proxyFilter);
        }
        if ((optionsProxy = this.getServiceObjectOptions(configurableServer.getUseroptions())) != null) {
            configurableServerProxy.setUseroptions(optionsProxy);
        }
        return configurableServerProxy;
    }

    public UserOptionsProxy getServiceObjectOptions(UserOptionsData options) {
        UserOptionsProxy ServiceOptions = null;
        if (options != null && !options.getOptions().isEmpty()) {
            ServiceOptions = new UserOptionsProxy();
            ServiceOptions.setOptions(options.getOptions());
        }
        return ServiceOptions;
    }

    public UserOptionsData getRestObjectOptions(UserOptionsProxy options) {
        UserOptionsData restOptions = null;
        if (options != null && !options.getOptions().isEmpty()) {
            restOptions = new UserOptionsData();
            restOptions.setOptions(options.getOptions());
        }
        return restOptions;
    }

    public ConfigurationFilter getServiceObjectFilter(ConfigurationFilterData dataFilter) {
        ConfigurationFilter cfFilter = null;
        if (dataFilter != null) {
            cfFilter = new ConfigurationFilter();
            if (dataFilter.getExcludes() != null && dataFilter.getExcludes().size() > 0) {
                cfFilter.setExcludes(dataFilter.getExcludes());
            }
            if (dataFilter.getIncludes() != null && dataFilter.getIncludes().size() > 0) {
                cfFilter.setIncludes(dataFilter.getIncludes());
            }
        }
        return cfFilter;
    }

    public ConfigurableServerProxyLinksData getRestConfigurableServerObject(ConfigurableServerProxy configurableServerProxy, String configurationid, String sourcetype) {
        UserOptionsData optionsData;
        ConfigurationFilterData restFilter;
        ConfigurableServerProxyLinksData configurableServerProxyData = new ConfigurableServerProxyLinksData();
        configurableServerProxyData.setSasTierId(configurableServerProxy.getSasTierId());
        configurableServerProxyData.setConfigurablePath(configurableServerProxy.getConfigurablePath());
        configurableServerProxyData.setName(configurableServerProxy.getName());
        configurableServerProxyData.setId(configurableServerProxy.getId());
        if (configurableServerProxy.isIncluded() != null) {
            configurableServerProxyData.setIncluded(configurableServerProxy.isIncluded());
        }
        if ((restFilter = this.getRestObjectFilter(configurableServerProxy.getFilter())) != null) {
            configurableServerProxyData.setFilter(restFilter);
        }
        if ((optionsData = this.getRestObjectOptions(configurableServerProxy.getUseroptions())) != null) {
            configurableServerProxyData.setUseroptions(optionsData);
        }
        return configurableServerProxyData;
    }

    public ConfigurableServerProxyLinksData getRestConfigurableServerLinkObject(ConfigurableServerProxy configurableServerProxy, String configurationid, String sourcetype, boolean sublink) {
        Links links = new Links();
        ConfigurableServerProxyLinksData configurableServerProxyData = this.getRestConfigurableServerObject(configurableServerProxy, configurationid, sourcetype);
        ConfigurableServerProxyLinksData configurableServerProxyLinksData = new ConfigurableServerProxyLinksData(configurableServerProxyData);
        if (sublink) {
            sourcetype = BackupSourceConfig.BackupSource.valueOf((String)sourcetype.toUpperCase()).getDisplayName();
        }
        if (configurableServerProxy.getId() != null) {
            Link link = new Link(HttpMethod.GET.name(), "self", "/configurations/" + configurationid + "/" + sourcetype + "/" + configurableServerProxy.getId());
            links.add(link);
            link = new Link(HttpMethod.PUT.name(), "update", "/configurations/" + configurationid + "/" + sourcetype + "/" + configurableServerProxy.getId());
            links.add(link);
            if (!sourcetype.equals(BackupSourceConfig.BackupSource.CONFIGDIR.toString()) && !sourcetype.equals(BackupSourceConfig.BackupSource.CONFIGDIR.getDisplayName())) {
                link = new Link(HttpMethod.DELETE.name(), "delete", "/configurations/" + configurationid + "/" + sourcetype + "/" + configurableServerProxy.getId());
                links.add(link);
            }
        }
        if (!links.getLinks().isEmpty()) {
            configurableServerProxyLinksData.setLinks(links.getLinks());
        }
        return configurableServerProxyLinksData;
    }

    public ConfigurationFilterData getRestObjectFilter(ConfigurationFilter filter) {
        ConfigurationFilterData cfdFilter = null;
        if (filter != null) {
            cfdFilter = new ConfigurationFilterData();
            if (filter.getExcludes() != null && filter.getExcludes().size() > 0) {
                cfdFilter.setExcludes(filter.getExcludes());
            }
            if (filter.getIncludes() != null && filter.getIncludes().size() > 0) {
                cfdFilter.setIncludes(filter.getIncludes());
            }
        }
        return cfdFilter;
    }

    public UserSourceConfiguration getServiceUserConfigObject(UserSourceConfigData sourceconfig) {
        UserSourceConfiguration configuration = new UserSourceConfiguration();
        List<ConfigurableServerProxyLinksData> lstConfigurableServers = sourceconfig.getConfigurableServers();
        ArrayList<ConfigurableServerProxy> lstConfigurableServersProxy = null;
        if (lstConfigurableServers != null && lstConfigurableServers.size() > 0) {
            lstConfigurableServersProxy = new ArrayList<ConfigurableServerProxy>(lstConfigurableServers.size());
            for (ConfigurableServerProxyData configurableServerProxyData : lstConfigurableServers) {
                ConfigurableServerProxy serverProxy = this.getServiceConfigurableServerObject(configurableServerProxyData);
                if (serverProxy == null) continue;
                lstConfigurableServersProxy.add(serverProxy);
            }
        }
        if (lstConfigurableServersProxy != null && lstConfigurableServersProxy.size() > 0) {
            configuration.setConfigurableServers((List)lstConfigurableServersProxy);
        }
        return configuration;
    }

    public UserSourceConfigData getRestUserConfigObject(UserSourceConfiguration userConfigProxy, String configurationid, String sourcetype, boolean sublink) {
        UserSourceConfigData configuration = new UserSourceConfigData();
        List lstConfigurableServersProxy = userConfigProxy.getConfigurableServers();
        ArrayList<ConfigurableServerProxyLinksData> lstConfigurableServersData = null;
        if (lstConfigurableServersProxy != null && lstConfigurableServersProxy.size() > 0) {
            lstConfigurableServersData = new ArrayList<ConfigurableServerProxyLinksData>(lstConfigurableServersProxy.size());
            for (ConfigurableServerProxy serverproxy : lstConfigurableServersProxy) {
                ConfigurableServerProxyLinksData serverData = null;
                serverData = sublink ? this.getRestConfigurableServerLinkObject(serverproxy, configurationid, sourcetype, sublink) : this.getRestConfigurableServerObject(serverproxy, configurationid, sourcetype);
                if (serverData == null) continue;
                lstConfigurableServersData.add(serverData);
            }
        }
        if (lstConfigurableServersData != null && lstConfigurableServersData.size() > 0) {
            configuration.setConfigurableServers((List<ConfigurableServerProxyLinksData>)lstConfigurableServersData);
        }
        if (sublink) {
            sourcetype = BackupSourceConfig.BackupSource.valueOf((String)sourcetype.toUpperCase()).getDisplayName();
        }
        configuration.setSourceType(sourcetype);
        String Type = "application/vnd.sas.admin.backup.configuration.source";
        if (sourcetype.equalsIgnoreCase(BackupSourceConfig.BackupSource.CONFIGDIR.getDisplayName())) {
            Type = "application/vnd.sas.admin.backup.configuration.configdirectories";
        } else if (sourcetype.equalsIgnoreCase(BackupSourceConfig.BackupSource.CUSTOMDIR.getDisplayName())) {
            Type = "application/vnd.sas.admin.backup.configuration.customdirectories";
        } else if (sourcetype.equalsIgnoreCase(BackupSourceConfig.BackupSource.DATABASE.getDisplayName())) {
            Type = "application/vnd.sas.admin.backup.configuration.database";
        } else if (sourcetype.equalsIgnoreCase(BackupSourceConfig.BackupSource.METADATASERVER.getDisplayName())) {
            Type = "application/vnd.sas.admin.backup.configuration.metadataserver";
        } else if (sourcetype.equalsIgnoreCase(BackupSourceConfig.BackupSource.CONTENTSERVER.getDisplayName())) {
            Type = "application/vnd.sas.admin.backup.configuration.contentserver";
        }
        Links links = new Links();
        Link link = new Link(HttpMethod.GET.name(), "self", "/configurations/" + configurationid + "/" + sourcetype);
        link.setType(Type);
        links.add(link);
        if (!sourcetype.equalsIgnoreCase(BackupSourceConfig.BackupSource.CONFIGDIR.getDisplayName())) {
            link = new Link(HttpMethod.POST.name(), "post", "/configurations/" + configurationid + "/" + sourcetype);
            link.setType(Type);
            links.add(link);
        }
        if (!links.getLinks().isEmpty()) {
            configuration.setLinks(links.getLinks());
        }
        return configuration;
    }

    public int getIdForNewServer(UserSourceConfiguration userConfigProxy) {
        List lstProxyServer;
        int objectId = 1;
        if (userConfigProxy != null && (lstProxyServer = userConfigProxy.getConfigurableServers()) != null && lstProxyServer.size() > 0) {
            objectId = this.getMaxIdCount(lstProxyServer);
        }
        return objectId;
    }

    private int getMaxIdCount(List<ConfigurableServerProxy> lstProxyServer) {
        int Max = 1;
        for (ConfigurableServerProxy proxy : lstProxyServer) {
            if (Integer.parseInt(proxy.getId()) <= Max) continue;
            Max = Integer.parseInt(proxy.getId());
        }
        return ++Max;
    }

    public List<SASTierData> getRestTierConfigObject(List<SASTierProxy> tiersList, String configurationid) {
        ArrayList<SASTierData> tiersDataList = new ArrayList<SASTierData>(tiersList.size());
        if (tiersList.size() > 0) {
            for (SASTierProxy tier : tiersList) {
                SASTierData data = this.getDataObject(tier);
                Links links = new Links();
                Link link = new Link(HttpMethod.GET.name(), "self", "/configurations/" + configurationid + "/sastiers/" + tier.getTierName());
                link.setType("application/vnd.sas.admin.backup.configuration.sastiers");
                links.add(link);
                link = new Link(HttpMethod.PUT.name(), "update", "/configurations/" + configurationid + "/sastiers/" + tier.getTierName());
                link.setType("application/vnd.sas.admin.backup.configuration.sastiers");
                data.setLinks(links);
                tiersDataList.add(data);
            }
        }
        return tiersDataList;
    }
}

